/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationFactory;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfigurationType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public final class RackRunConfigurationProducer
extends LazyRunConfigurationProducer<RackRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        RackRunConfigurationFactory rackRunConfigurationFactory = RackRunConfigurationType.getInstance().getFactory();
        if (rackRunConfigurationFactory == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return rackRunConfigurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull RackRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        String configPath = configuration.getRackScriptPath();
        VirtualFile locationalFile = PsiUtilCore.getVirtualFile((PsiElement)context.getPsiLocation());
        if (configPath == null || locationalFile == null || !locationalFile.getPath().equals(configPath)) {
            return false;
        }
        return configuration.getServer().equals("Default") && configuration.getHost().equals(RackUtil.RACK_SERVER_LOCALHOST) && configuration.getPort().equals(String.valueOf(9292));
    }

    protected boolean setupConfigurationFromContext(@NotNull RackRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile file;
        if (configuration == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            RackRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)sourceElement.get()))) == null || !RackUtil.isRackConfig(file)) {
            return false;
        }
        if (context.getLocation() == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)configuration.getProject());
        if (module == null) {
            return false;
        }
        configuration.setName(file.getName());
        configuration.setModule(module);
        RunConfigurationUtil.setRailsWorkingDirectoryIfNecessary(configuration, file, configuration.getProject(), module);
        configuration.setConfig(file.getName());
        RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, context.getLocation());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationProducer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

