/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rack.RackUtil;
import org.jetbrains.plugins.ruby.rack.run.RackRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleFilterProvider;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RackRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String RACK_RUNNER_PARAMS_GROUP_ID = "ruby.rack.runner";

    public RackRunCommandLineState(RackRunConfiguration config, ExecutionEnvironment env) {
        super(config, env, false);
    }

    public RackRunConfiguration getConfig() {
        return (RackRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        RackRunConfiguration config = this.getConfig();
        String runnerId = this.getRunnerId();
        return RackRunCommandLineState.createCommandLine(config, runnerId);
    }

    @Override
    public Pair<RubyCommandLineData, ProcessHandler> createCommandLineAndProcessHandler() throws ExecutionException {
        Pair<RubyCommandLineData, ProcessHandler> data = super.createCommandLineAndProcessHandler();
        ProcessHandler processHandler = (ProcessHandler)data.getSecond();
        final String url = this.getConfig().getBrowserUrl();
        if (url != null) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    browserStarted.set((Object)true);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        TimeoutUtil.sleep((long)5000L);
                        if (RackRunCommandLineState.this.isInRubyDebugMode() && RackRunCommandLineState.this.getConfig().isLaunchJavascriptDebugger() && JavaScriptDebuggerStarter.Util.start((RunConfiguration)RackRunCommandLineState.this.getConfig(), (String)("http://" + RackRunCommandLineState.this.getConfig().getHost() + ":" + RackRunCommandLineState.this.getConfig().getPort() + "/"))) {
                            return;
                        }
                        BrowserUtil.browse((String)url);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rack/run/RackRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return data;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> filters = super.createConsoleMessageFilters();
        RackRunConfiguration config = this.getConfig();
        Project project = config.getProject();
        String workingDir = VfsUtil.getParentDir((String)config.getRackScriptPath());
        Sdk sdk = config.getSdk();
        for (RubyConsoleFilterProvider consoleFilterProvider : (RubyConsoleFilterProvider[])RubyConsoleFilterProvider.EP_NAME.getExtensions()) {
            Filter filter = consoleFilterProvider.createFilter(project, workingDir, sdk);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters;
    }

    public static RubyCommandLineData createCommandLine(@NotNull RackRunConfiguration config, String runnerId) throws ExecutionException {
        String path;
        if (config == null) {
            RackRunCommandLineState.$$$reportNull$$$0(0);
        }
        RubyCommandLineData data = RackRunCommandLineState.createDefaultCommandLine(config, runnerId);
        Sdk sdk = config.getSdk();
        Module module = config.getModule();
        if (module != null && sdk != null && (path = RackUtil.findRackupExecutablePath(module, sdk)) != null) {
            RubyCommandLine commandLine = data.getCommandLine();
            ParamsGroup runnerParamsGroup = RackRunCommandLineState.addExecutionScriptGroup(RACK_RUNNER_PARAMS_GROUP_ID, data, commandLine, path, sdk, module);
            RackUtil.RackServers[] servers = RackUtil.RackServers.values();
            String serverName = config.getServer();
            if (!serverName.equals(RackUtil.RackServers.DEFAULT.getServerName())) {
                for (Object server : servers) {
                    if (!server.getServerName().equals(serverName)) continue;
                    RackRunCommandLineState.addOption(runnerParamsGroup, "-s", server.getCommandOption());
                }
            }
            String hostAddress = (String)ObjectUtils.coalesce((Object)((String)commandLine.getUserData(RubyCommandLineData.RACK_SERVER_HOST_KEY)), (Object)config.getHost());
            RackRunCommandLineState.addOption(runnerParamsGroup, "-o", hostAddress);
            RackRunCommandLineState.addOption(runnerParamsGroup, "-p", config.getPort());
            int portInt = Integer.valueOf(config.getPort());
            RunConfigurationUtil.addPortForwarding(data, PortForwarding.remoteToLocal(hostAddress, portInt, portInt));
            Map envs = config.getEnvs();
            for (String env : envs.keySet()) {
                if (!env.equals("RACK_ENV")) continue;
                RackRunCommandLineState.addOption(runnerParamsGroup, "-E", (String)envs.get(env));
            }
            String configRu = config.getRackupConfig();
            if (!configRu.isEmpty()) {
                runnerParamsGroup.addParameter(configRu);
            }
        }
        return data;
    }

    private static void addOption(ParamsGroup paramsGroup, String option, String value) {
        if (!value.isEmpty()) {
            paramsGroup.addParametersString(option);
            paramsGroup.addParameter(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/plugins/ruby/rack/run/RackRunCommandLineState", "createCommandLine"));
    }
}

