/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.mongoid;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public final class MongoidUtil {
    public static final String MONGOID = "Mongoid";
    public static final String TYPE_KEY = "type";

    public static boolean isMongoidIncluded(@NotNull RClass rClass) {
        PsiElement element;
        if (rClass == null) {
            MongoidUtil.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)rClass.getProject())) {
            return false;
        }
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (classSymbol != null && (element = classSymbol.getPsiElement()) != null) {
            List<Symbol> symbols = ((ClassModuleSymbol)classSymbol).getIncludeSymbols(element);
            for (Symbol symbol : symbols) {
                Symbol parentSymbol = symbol.getParentSymbol();
                String parentName = parentSymbol != null ? parentSymbol.getName() : null;
                if (parentName == null || !parentName.equals(MONGOID)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rClass", "org/jetbrains/plugins/ruby/mongoid/MongoidUtil", "isMongoidIncluded"));
    }
}

