/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.navigation;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.list.TargetPopup;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;

public final class NavigationTargetPopup {
    private NavigationTargetPopup() {
    }

    @RequiresReadLock
    @RequiresEdt
    @NotNull
    public static Builder builder(@NotNull Collection<? extends NavigationTarget> targets) {
        if (targets == null) {
            NavigationTargetPopup.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return new Builder(targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "org/jetbrains/plugins/ruby/model/navigation/NavigationTargetPopup", "builder"));
    }

    public static final class Builder {
        private final List<NavigationTarget> myTargets;
        private @NlsContexts.PopupTitle @Nullable String myTitle;
        @Nullable
        private Runnable myNoTargetsHandler;

        private Builder(@NotNull Collection<? extends NavigationTarget> targets) {
            if (targets == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myTargets = List.copyOf(targets);
        }

        @RequiresEdt
        public void navigateOrShow(@NotNull RelativePoint point) {
            if (point == null) {
                Builder.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            JBPopup popup = this.navigateOrCreatePopup();
            if (popup != null) {
                popup.show(point);
            }
        }

        @RequiresEdt
        public void navigateOrShowInBestPositionFor(@NotNull Editor editor) {
            if (editor == null) {
                Builder.$$$reportNull$$$0(2);
            }
            ThreadingAssertions.assertEventDispatchThread();
            JBPopup popup = this.navigateOrCreatePopup();
            if (popup != null) {
                popup.showInBestPositionFor(editor);
            }
        }

        @NotNull
        public Builder onNoTargets(@NotNull Runnable runnable) {
            if (runnable == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myNoTargetsHandler = runnable;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder withHintOnNoTargets(@NotNull Editor editor, @NlsContexts.HintText @NotNull String message) {
            if (editor == null) {
                Builder.$$$reportNull$$$0(5);
            }
            if (message == null) {
                Builder.$$$reportNull$$$0(6);
            }
            Builder builder2 = this.onNoTargets(() -> HintManager.getInstance().showErrorHint(editor, message));
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder withTitle(@NlsContexts.PopupTitle @NotNull String title) {
            if (title == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myTitle = title;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @Nullable
        private JBPopup navigateOrCreatePopup() {
            if (this.myTargets.isEmpty()) {
                if (this.myNoTargetsHandler != null) {
                    this.myNoTargetsHandler.run();
                }
            } else if (this.myTargets.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                this.myTargets.get(0).getNavigatable().navigate(true);
            } else {
                List presentations = ContainerUtil.map(this.myTargets, com.intellij.platform.backend.navigation.NavigationTarget::computePresentation);
                return TargetPopup.createTargetPopup((String)Objects.requireNonNull(this.myTitle), this.myTargets, (List)presentations, target -> target.getNavigatable().navigate(true));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/model/navigation/NavigationTargetPopup$Builder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/model/navigation/NavigationTargetPopup$Builder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "onNoTargets";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHintOnNoTargets";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "navigateOrShow";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "navigateOrShowInBestPositionFor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onNoTargets";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withHintOnNoTargets";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withTitle";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 9 -> new IllegalStateException(string);
            };
        }
    }
}

