/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.metrics.abc;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RRescueBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class ABCMetricVisitor
extends RubyRecursiveElementVisitor {
    private static final Object2DoubleOpenHashMap<@NlsSafe String> CALL_WEIGHTS = new Object2DoubleOpenHashMap();
    private final Stack<String> classStack = new Stack();
    private final Stack<String> methodStack = new Stack();
    private final Map<String, double[]> result = new HashMap<String, double[]>();
    private double multiplier = 1.0;

    public void visitRClass(@NotNull RClass rClass) {
        if (rClass == null) {
            ABCMetricVisitor.$$$reportNull$$$0(0);
        }
        this.classStack.push((Object)rClass.getFQN().getFullPath());
        this.penalizeBy(1.0, () -> {
            RSuperClass superClass = rClass.getPsiSuperClass();
            if (superClass != null) {
                this.visitRSuperClass(superClass);
            }
        });
        this.visitRCompoundStatement(rClass.getCompoundStatement());
        this.classStack.pop();
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            ABCMetricVisitor.$$$reportNull$$$0(1);
        }
        this.classStack.push((Object)rModule.getFQN().getFullPath());
        super.visitRModule(rModule);
        this.classStack.pop();
    }

    public void visitRObjectClass(@NotNull RObjectClass rsClass) {
        if (rsClass == null) {
            ABCMetricVisitor.$$$reportNull$$$0(2);
        }
        this.addToScore(Type.SELF_CLASS);
        this.penalizeBy(0.5, () -> this.visitRObjectClass(rsClass));
    }

    public void visitRMethod(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            ABCMetricVisitor.$$$reportNull$$$0(3);
        }
        this.methodStack.push((Object)rMethod.getName());
        super.visitRMethod(rMethod);
        this.methodStack.pop();
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            ABCMetricVisitor.$$$reportNull$$$0(4);
        }
        super.visitElement(element);
        IElementType type = element.getNode().getElementType();
        if (type == RubyElementTypes.INTEGER) {
            String text = element.getText();
            if (!"0".equals(text) && !"-1".equals(text)) {
                this.addToScore(Type.FIXNUM);
            }
        } else if (type == RubyElementTypes.PREDEFINED_ARGUMENT) {
            this.addToScore(Type.ASSIGNMENT);
        }
    }

    public void visitRCompoundStatement(@NotNull RCompoundStatement rCompoundStatement) {
        if (rCompoundStatement == null) {
            ABCMetricVisitor.$$$reportNull$$$0(5);
        }
        double bonus = rCompoundStatement.getParent() instanceof PsiFile ? 0.0 : 0.1;
        this.penalizeBy(bonus, () -> super.visitRCompoundStatement(rCompoundStatement));
    }

    public void visitRSingletonMethod(@NotNull RSingletonMethod rMethod) {
        if (rMethod == null) {
            ABCMetricVisitor.$$$reportNull$$$0(6);
        }
        this.methodStack.push((Object)rMethod.getName());
        super.visitRSingletonMethod(rMethod);
        this.methodStack.pop();
    }

    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            ABCMetricVisitor.$$$reportNull$$$0(7);
        }
        String command = rCall.getCommand();
        double weight = ABCMetricVisitor.getCallWeight(command);
        this.addToScore(Type.BRANCHING.type, weight);
        this.penalizeBy(0.2, () -> super.visitRCall(rCall));
    }

    public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
        RCondition condition;
        if (ifStatement == null) {
            ABCMetricVisitor.$$$reportNull$$$0(8);
        }
        if ((condition = ifStatement.getCondition()) != null) {
            super.visitRCondition(condition);
        }
        this.penalizeBy(0.1, () -> {
            RCompoundStatement thenBlock = ifStatement.getThenBlock();
            if (thenBlock != null) {
                this.visitRCompoundStatement(thenBlock);
            }
            for (RElsifBlock block : ifStatement.getElsifBlocks()) {
                this.visitRElsifBlock(block);
            }
            RElseBlock elseBlock = ifStatement.getElseBlock();
            if (elseBlock != null) {
                this.visitRElseBlock(elseBlock);
            }
        });
        this.addToScore(Type.CONDITION);
    }

    public void visitRElsifBlock(@NotNull RElsifBlock rElsifBlock) {
        if (rElsifBlock == null) {
            ABCMetricVisitor.$$$reportNull$$$0(9);
        }
        this.penalizeBy(-0.1, () -> {
            RCondition condition = rElsifBlock.getCondition();
            if (condition != null) {
                this.visitRCondition(condition);
            }
        });
        this.visitRCompoundStatement(rElsifBlock.getBody());
        this.addToScore(Type.CONDITION);
    }

    public void visitRRescueBlock(@NotNull RRescueBlock rRescueBlock) {
        if (rRescueBlock == null) {
            ABCMetricVisitor.$$$reportNull$$$0(10);
        }
        super.visitRRescueBlock(rRescueBlock);
        this.addToScore(Type.CONDITION);
    }

    public void visitRAliasStatement(@NotNull RAliasStatement rAliasStatement) {
        if (rAliasStatement == null) {
            ABCMetricVisitor.$$$reportNull$$$0(11);
        }
        super.visitRAliasStatement(rAliasStatement);
        this.addToScore(Type.ALIAS);
    }

    public void visitRYieldStatement(@NotNull RYieldStatement rYieldStatement) {
        if (rYieldStatement == null) {
            ABCMetricVisitor.$$$reportNull$$$0(12);
        }
        super.visitRYieldStatement(rYieldStatement);
        this.addToScore(Type.CONDITION);
    }

    public void visitRConditionalStatement(@NotNull RConditionalStatement rConditionalStatement) {
        if (rConditionalStatement == null) {
            ABCMetricVisitor.$$$reportNull$$$0(13);
        }
        super.visitRConditionalStatement(rConditionalStatement);
        this.addToScore(Type.CONDITION);
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            ABCMetricVisitor.$$$reportNull$$$0(14);
        }
        this.addToScore(Type.ASSIGNMENT);
        super.visitRAssignmentExpression(assignmentExpression);
    }

    public void visitRSelfAssignmentExpression(RSelfAssignmentExpression selfAssignmentExpression) {
        this.addToScore(Type.ASSIGNMENT);
        super.visitRSelfAssignmentExpression(selfAssignmentExpression);
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        if (rBinaryExpression == null) {
            ABCMetricVisitor.$$$reportNull$$$0(15);
        }
        if (rBinaryExpression instanceof RBoolBinExpression) {
            this.penalizeBy(0.1, () -> super.visitRBinaryExpression(rBinaryExpression));
        } else {
            this.penalizeBy(0.2, () -> super.visitRBinaryExpression(rBinaryExpression));
        }
        this.addToScore(Type.BRANCHING);
    }

    public void visitRDoBlockCall(@NotNull RDoBlockCall rDoBlockCall) {
        if (rDoBlockCall == null) {
            ABCMetricVisitor.$$$reportNull$$$0(16);
        }
        this.penalizeBy(0.1, () -> super.visitRDoBlockCall(rDoBlockCall));
    }

    public void visitRBraceCodeBlock(@NotNull RBraceCodeBlock rBraceCodeBlock) {
        if (rBraceCodeBlock == null) {
            ABCMetricVisitor.$$$reportNull$$$0(17);
        }
        this.penalizeBy(0.1, () -> super.visitRBraceCodeBlock(rBraceCodeBlock));
        RBlockArgumentList params = rBraceCodeBlock.getBlockArguments();
        if (params != null) {
            Type assignment = Type.ASSIGNMENT;
            this.addToScore(assignment.type, assignment.weight * (double)params.getArguments().size());
        }
    }

    public void visitRColonReference(@NotNull RColonReference rColonReference) {
        if (rColonReference == null) {
            ABCMetricVisitor.$$$reportNull$$$0(18);
        }
        this.addToScore(Type.BRANCHING);
        this.penalizeBy(0.2, () -> super.visitRColonReference(rColonReference));
    }

    public void visitRDotReference(@NotNull RDotReference rDotReference) {
        if (rDotReference == null) {
            ABCMetricVisitor.$$$reportNull$$$0(19);
        }
        this.addToScore(Type.BRANCHING);
        this.penalizeBy(0.2, () -> super.visitRDotReference(rDotReference));
    }

    private void addToScore(Type type) {
        this.addToScore(type.type, type.weight);
    }

    private void addToScore(int type, double weight) {
        String clazz = this.getClassName();
        String method = this.getMethodName();
        String key = ABCMetricVisitor.createKey(clazz, method);
        this.addToScore(key, type, weight);
    }

    private void addToScore(String key, int type, double weight) {
        double[] trinity = this.result.containsKey(key) ? this.result.get(key) : new double[3];
        int n = type;
        trinity[n] = trinity[n] + weight * this.multiplier;
        this.result.put(key, trinity);
    }

    private static double getCallWeight(String command) {
        if (CALL_WEIGHTS.containsKey((Object)command)) {
            return CALL_WEIGHTS.getDouble((Object)command);
        }
        return 1.0;
    }

    @NlsSafe
    private static String createKey(String clazz, String method) {
        return clazz + "#" + method;
    }

    @NotNull
    @NlsSafe
    private String getMethodName() {
        return !this.methodStack.isEmpty() ? (String)this.methodStack.peek() : "none";
    }

    @NotNull
    @NlsSafe
    public String getClassName() {
        return !this.classStack.isEmpty() ? (String)this.classStack.peek() : "main";
    }

    private void penalizeBy(double bonus, Runnable block) {
        this.multiplier += bonus;
        block.run();
        this.multiplier -= bonus;
    }

    public String dumpAsIs() {
        StringBuilder dump = new StringBuilder();
        for (Map.Entry<String, double[]> entry : this.result.entrySet()) {
            double[] value = entry.getValue();
            double result = 0.0;
            for (double w : value) {
                result += w * w;
            }
            result = Math.sqrt(result);
            long round = Math.round(result * 10.0);
            System.err.println(entry.getKey() + value[0]);
            dump.append(entry.getKey()).append(": ").append(round / 10L).append(".").append(round % 10L).append("\n");
        }
        return dump.toString();
    }

    static {
        CALL_WEIGHTS.put((Object)"eval", 5.0);
        CALL_WEIGHTS.put((Object)"module_eval", 5.0);
        CALL_WEIGHTS.put((Object)"class_eval", 5.0);
        CALL_WEIGHTS.put((Object)"instance_eval", 5.0);
        CALL_WEIGHTS.put((Object)"define_method", 5.0);
        CALL_WEIGHTS.put((Object)"alias_method", 2.0);
        CALL_WEIGHTS.put((Object)"extend", 2.0);
        CALL_WEIGHTS.put((Object)"include", 2.0);
        CALL_WEIGHTS.put((Object)"instance_method", 2.0);
        CALL_WEIGHTS.put((Object)"instance_methods", 2.0);
        CALL_WEIGHTS.put((Object)"method_added", 2.0);
        CALL_WEIGHTS.put((Object)"method_defined?", 2.0);
        CALL_WEIGHTS.put((Object)"method_removed", 2.0);
        CALL_WEIGHTS.put((Object)"method_undefined", 2.0);
        CALL_WEIGHTS.put((Object)"private_class_method", 2.0);
        CALL_WEIGHTS.put((Object)"private_instance_methods", 2.0);
        CALL_WEIGHTS.put((Object)"private_method_defined?", 2.0);
        CALL_WEIGHTS.put((Object)"protected_instance_methods", 2.0);
        CALL_WEIGHTS.put((Object)"protected_method_defined?", 2.0);
        CALL_WEIGHTS.put((Object)"public_class_method", 2.0);
        CALL_WEIGHTS.put((Object)"public_instance_methods", 2.0);
        CALL_WEIGHTS.put((Object)"public_method_defined?", 2.0);
        CALL_WEIGHTS.put((Object)"remove_method", 2.0);
        CALL_WEIGHTS.put((Object)"send", 3.0);
        CALL_WEIGHTS.put((Object)"undef_method", 2.0);
        CALL_WEIGHTS.put((Object)"inject", 2.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rsClass";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCompoundStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rElsifBlock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rRescueBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAliasStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rYieldStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConditionalStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDoBlockCall";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceCodeBlock";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rColonReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDotReference";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/metrics/abc/ABCMetricVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRObjectClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCompoundStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSingletonMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIfStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRElsifBlock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRRescueBlock";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAliasStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRYieldStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRConditionalStatement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAssignmentExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBinaryExpression";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDoBlockCall";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBraceCodeBlock";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRColonReference";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDotReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Type {
        ALIAS(1, 2.0),
        ASSIGNMENT(0, 1.0),
        BLOCK(1, 1.0),
        BLOCK_PASS(1, 1.0),
        BRANCHING(1, 1.0),
        CONDITION(2, 1.0),
        FIXNUM(1, 0.25),
        SELF_CLASS(1, 5.0),
        SUPER(1, 1.0),
        TO_PROC_ICKY(1, 10.0),
        TO_PROC(1, 5.0),
        YIELD(1, 1.0);

        public int type;
        public double weight;

        private Type(int type, double weight) {
            this.type = type;
            this.weight = weight;
        }
    }
}

