/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.helpers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.jruby.warbler.WarblerConstants;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.settings.WarblerSettings;
import org.jetbrains.plugins.ruby.jruby.warbler.utils.WarblerPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.words.RAbstractWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public final class WarblerConfigHelper {
    private static final Logger LOG = Logger.getInstance(WarblerConfigHelper.class);
    private static final String CONFIG_FEATURES_ASSIGNMENT_TEMPLATE = "config.features = %%w(%s)";
    private static final String CONFIG_DIRS_ASSIGNMENT_TEMPLATE = "config.dirs = %%w(%s)";
    private static final String CONFIG_INCLUDES_ASSIGNMENT_TEMPLATE = "config.includes = FileList[%s]";
    private static final String CONFIG_EXCLUDES_ASSIGNMENT_TEMPLATE = "config.excludes = FileList[%s])";
    private static final String CONFIG_WEBINF_FILES_ASSIGNMENT_TEMPLATE = "config.webinf_files = FileList[%s]";
    private static final String CONFIG_WAR_NAME_ASSIGNMENT_TEMPLATE = "#Warbler output file name\nconfig.jar_name = \"%s\"";
    private static final String ASSIGNMENTS_CONTAINER = "assignmentsContainer";
    private static final String WARBLER_CONFIG_TEMPLATE = "Warbler::Config.new do |config|\n  config.features = %%w()\n\n  config.dirs = %%w()\n\n  config.includes = FileList[]\n  config.excludes = FileList[]\n\n  config.webinf_files += FileList[]\n\n  config.jar_name = \"%s\"\nend";

    private WarblerConfigHelper() {
    }

    @NotNull
    public static WarblerConfigModel readConfig(@NotNull Module module) {
        WarblerConfigModel model;
        RFile configFile;
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(0);
        }
        if ((configFile = WarblerConfigHelper.getConfigFile(module)) != null) {
            model = new WarblerConfigModel();
            WarblerConfigHelper.parseWarbleConfig(module, model, configFile);
        } else {
            model = WarblerConfigHelper.getDefaultModel(module);
        }
        if (model.getFileName() == null) {
            model.setFileName(module.getName());
        }
        model.setTrace(WarblerSettings.getInstance((Module)module).myWarblerTraceMode);
        WarblerConfigModel warblerConfigModel = model;
        if (warblerConfigModel == null) {
            WarblerConfigHelper.$$$reportNull$$$0(1);
        }
        return warblerConfigModel;
    }

    public static void saveConfig(@NotNull Module module, @NotNull WarblerConfigModel model) throws IOException {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(2);
        }
        if (model == null) {
            WarblerConfigHelper.$$$reportNull$$$0(3);
        }
        HashMap configAssignments = new HashMap();
        RFile existedWarbleConfigFile = WarblerConfigHelper.prepareWarblerConfigFile(module);
        ApplicationManager.getApplication().runReadAction(() -> {
            Map<String, PsiElement> a = WarblerConfigHelper.getConfigAssignments((PsiElement)existedWarbleConfigFile);
            configAssignments.putAll(a);
        });
        if (configAssignments.get(ASSIGNMENTS_CONTAINER) == null) {
            throw new IOException(RBundle.message((String)"warbler.error.cant.write.to.config"));
        }
        Map<String, PsiElement> newConfigValues = WarblerConfigHelper.getNewConfigValues(module, model, (PsiElement)existedWarbleConfigFile);
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{existedWarbleConfigFile}).run(() -> {
            for (Map.Entry newConfigValueEntry : newConfigValues.entrySet()) {
                RAssignmentExpression assignment = (RAssignmentExpression)configAssignments.get(newConfigValueEntry.getKey());
                if (assignment != null) {
                    PsiElement newValue = (PsiElement)newConfigValueEntry.getValue();
                    assignment.replace(newValue);
                    continue;
                }
                ((PsiElement)configAssignments.get(ASSIGNMENTS_CONTAINER)).add((PsiElement)newConfigValueEntry.getValue());
            }
        });
    }

    @NotNull
    private static RFile prepareWarblerConfigFile(@NotNull Module module) throws IOException {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(4);
        }
        RFile configFile = WarblerConfigHelper.getConfigFile(module);
        HashMap configAssignments = new HashMap();
        if (configFile == null) {
            configFile = WarblerConfigHelper.createWarblerConfig(module);
        } else {
            RFile existedWarbleConfigFile = configFile;
            ApplicationManager.getApplication().runReadAction(() -> WarblerConfigHelper.lambda$prepareWarblerConfigFile$2((PsiElement)existedWarbleConfigFile, configAssignments));
            if (configAssignments.get(ASSIGNMENTS_CONTAINER) == null) {
                configFile = WarblerConfigHelper.createWarblerConfig(module);
            }
        }
        RFile rFile = configFile;
        if (rFile == null) {
            WarblerConfigHelper.$$$reportNull$$$0(5);
        }
        return rFile;
    }

    @NotNull
    public static WarblerConfigModel getDefaultModel(@NotNull Module module) {
        String[] defaultAddedDirs;
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(6);
        }
        WarblerConfigModel result = new WarblerConfigModel();
        VirtualFile moduleDir = WarblerConfigHelper.getModuleDir(module);
        result.setFileName(module.getName());
        for (String dir : defaultAddedDirs = WarblerConstants.DEFAULT_DIRS) {
            VirtualFile defaultAddedDir = moduleDir.findFileByRelativePath(dir);
            if (defaultAddedDir == null) continue;
            result.getIncludeModel().addFile(defaultAddedDir);
        }
        WarblerConfigModel warblerConfigModel = result;
        if (warblerConfigModel == null) {
            WarblerConfigHelper.$$$reportNull$$$0(7);
        }
        return warblerConfigModel;
    }

    private static void putValueIntoConfigModel(@NotNull Module module, @NotNull WarblerConfigModel model, @NotNull String key, String @NotNull [] values) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(8);
        }
        if (model == null) {
            WarblerConfigHelper.$$$reportNull$$$0(9);
        }
        if (key == null) {
            WarblerConfigHelper.$$$reportNull$$$0(10);
        }
        if (values == null) {
            WarblerConfigHelper.$$$reportNull$$$0(11);
        }
        if (key.equals("config.features")) {
            for (String feature : values) {
                if (feature.equalsIgnoreCase("executable")) {
                    model.setExecutable(true);
                    continue;
                }
                if (feature.equalsIgnoreCase("compiled")) {
                    model.setPrecompiled(true);
                    continue;
                }
                if (!feature.equalsIgnoreCase("gemjar")) continue;
                model.setGemJar(true);
            }
        } else if (key.equals("config.dirs")) {
            for (String dir : values) {
                VirtualFile vDir = WarblerConfigHelper.getModuleDir(module).findChild(dir);
                if (vDir == null) continue;
                model.getIncludeModel().addFile(vDir);
            }
        } else if (key.equals("config.jar_name") || key.equals("config.war_name")) {
            model.setFileName(values[0]);
        } else {
            block12: for (String filePath : values) {
                VirtualFile f = WarblerConfigHelper.getModuleDir(module).findFileByRelativePath(filePath);
                if (f == null) continue;
                switch (key) {
                    case "config.includes": {
                        model.getIncludeModel().addFile(f);
                        continue block12;
                    }
                    case "config.excludes": {
                        model.getExcludeModel().addFile(f);
                        continue block12;
                    }
                    case "config.webinf_files": {
                        model.getWebInfConfigModel().addFile(f);
                    }
                }
            }
        }
    }

    @NotNull
    public static VirtualFile getModuleDir(@NotNull Module module) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(12);
        }
        VirtualFile virtualFile = ModuleRootManager.getInstance((Module)module).getContentRoots()[0];
        if (virtualFile == null) {
            WarblerConfigHelper.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @NotNull
    private static Map<String, PsiElement> getConfigAssignments(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            WarblerConfigHelper.$$$reportNull$$$0(14);
        }
        HashMap<String, PsiElement> result = new HashMap<String, PsiElement>();
        PsiElement doCodeBlock = WarblerPsiUtil.findElementInPsiTree(psiElement, RDoCodeBlock.class);
        if (doCodeBlock != null) {
            PsiElement assignmentsContainer = WarblerPsiUtil.findElementInPsiTree(doCodeBlock, RCompoundStatement.class);
            result.put(ASSIGNMENTS_CONTAINER, assignmentsContainer);
            if (assignmentsContainer != null) {
                for (PsiElement child : assignmentsContainer.getChildren()) {
                    RPsiElement object;
                    if (!(child instanceof RAssignmentExpression) || !((object = ((RAssignmentExpression)child).getObject()) instanceof RDotReference)) continue;
                    String objectName = WarblerPsiUtil.getSimpleDotReferenceName((RDotReference)object);
                    result.put(objectName, child);
                }
            }
        }
        HashMap<String, PsiElement> hashMap = result;
        if (hashMap == null) {
            WarblerConfigHelper.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    private static void parseConfigAssignment(@NotNull Module module, @NotNull WarblerConfigModel model, @NotNull RAssignmentExpression assignment) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(16);
        }
        if (model == null) {
            WarblerConfigHelper.$$$reportNull$$$0(17);
        }
        if (assignment == null) {
            WarblerConfigHelper.$$$reportNull$$$0(18);
        }
        RPsiElement object = assignment.getObject();
        RPsiElement value = assignment.getValue();
        if (object instanceof RDotReference && value != null) {
            String variableName = WarblerPsiUtil.getSimpleDotReferenceName((RDotReference)object);
            String[] words = null;
            if (assignment.getValue() instanceof RAbstractWords) {
                words = WarblerPsiUtil.parseStringArray((RAbstractWords)value);
            } else if (assignment.getValue() instanceof RArrayIndexing) {
                words = WarblerPsiUtil.parseStringArray((RArrayIndexing)value);
            } else if (assignment.getValue() instanceof RBaseString) {
                RBaseString string = (RBaseString)value;
                words = new String[]{string.getContent()};
            }
            if (words != null) {
                WarblerConfigHelper.putValueIntoConfigModel(module, model, variableName, words);
            }
        }
    }

    private static void parseWarbleConfig(@NotNull Module module, @NotNull WarblerConfigModel config, @NotNull RFile configFile) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(19);
        }
        if (config == null) {
            WarblerConfigHelper.$$$reportNull$$$0(20);
        }
        if (configFile == null) {
            WarblerConfigHelper.$$$reportNull$$$0(21);
        }
        Map<String, PsiElement> configAssignments = WarblerConfigHelper.getConfigAssignments((PsiElement)configFile);
        for (Map.Entry<String, PsiElement> entry : configAssignments.entrySet()) {
            if (entry.getKey().equals(ASSIGNMENTS_CONTAINER)) continue;
            WarblerConfigHelper.parseConfigAssignment(module, config, (RAssignmentExpression)entry.getValue());
        }
        WarblerConfigModel defaultConfig = WarblerConfigHelper.getDefaultModel(module);
        if (config.getIncludeModel().getFileList().length == 0) {
            for (VirtualFile file : defaultConfig.getIncludeModel().getFileList()) {
                config.getIncludeModel().addFile(file);
            }
        }
    }

    @Nullable
    private static VirtualFile getVirtualConfigFile(@NotNull Module module) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(22);
        }
        VirtualFile moduleDir = WarblerConfigHelper.getModuleDir(module);
        return moduleDir.findFileByRelativePath("config/warble.rb");
    }

    @Nullable
    private static RFile getConfigFile(@NotNull Module module) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(23);
        }
        Ref result = new Ref();
        VirtualFile warbleConfig = WarblerConfigHelper.getVirtualConfigFile(module);
        if (warbleConfig != null && !warbleConfig.isDirectory()) {
            ApplicationManager.getApplication().runReadAction(() -> result.set((Object)PsiManager.getInstance((Project)module.getProject()).findFile(warbleConfig)));
        }
        return (RFile)result.get();
    }

    @NotNull
    private static String getConfigFeaturesAssignments(@NotNull WarblerConfigModel config) {
        if (config == null) {
            WarblerConfigHelper.$$$reportNull$$$0(24);
        }
        ArrayList<String> features = new ArrayList<String>();
        if (config.isExecutable()) {
            features.add("executable");
        }
        if (config.isPrecompiled()) {
            features.add("compiled");
        }
        if (config.isGemJar()) {
            features.add("gemjar");
        }
        String string = String.format(CONFIG_FEATURES_ASSIGNMENT_TEMPLATE, StringUtil.join(features, (String)" "));
        if (string == null) {
            WarblerConfigHelper.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String getConfigDirsValue(@NotNull Module module, @NotNull WarblerConfigModel config) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(26);
        }
        if (config == null) {
            WarblerConfigHelper.$$$reportNull$$$0(27);
        }
        VirtualFile moduleDir = WarblerConfigHelper.getModuleDir(module);
        ArrayList<String> dirs = new ArrayList<String>();
        for (VirtualFile file : config.getIncludeModel().getFileList()) {
            if (!file.isDirectory() || !file.getParent().equals(moduleDir)) continue;
            dirs.add(file.getName());
        }
        String string = String.format(CONFIG_DIRS_ASSIGNMENT_TEMPLATE, StringUtil.join(dirs, (String)" "));
        if (string == null) {
            WarblerConfigHelper.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String getConfigFileListValues(@NotNull VirtualFile moduleDir, VirtualFile @NotNull [] fileList, @NotNull FileFilter fileFilter, @NotNull String template) {
        if (moduleDir == null) {
            WarblerConfigHelper.$$$reportNull$$$0(29);
        }
        if (fileFilter == null) {
            WarblerConfigHelper.$$$reportNull$$$0(30);
        }
        if (template == null) {
            WarblerConfigHelper.$$$reportNull$$$0(31);
        }
        if (fileList == null) {
            WarblerConfigHelper.$$$reportNull$$$0(32);
        }
        ArrayList<CallSite> includes = new ArrayList<CallSite>();
        for (VirtualFile file : fileList) {
            if (!fileFilter.accept(file)) continue;
            includes.add((CallSite)((Object)("\"" + VfsUtilCore.findRelativePath((VirtualFile)moduleDir, (VirtualFile)file, (char)'/') + "\"")));
        }
        String string = String.format(template, StringUtil.join(includes, (String)", "));
        if (string == null) {
            WarblerConfigHelper.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String getConfigWarFileNameValue(@NotNull WarblerConfigModel config) {
        if (config == null) {
            WarblerConfigHelper.$$$reportNull$$$0(34);
        }
        String string = String.format(CONFIG_WAR_NAME_ASSIGNMENT_TEMPLATE, config.getFileName());
        if (string == null) {
            WarblerConfigHelper.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static Map<String, PsiElement> getNewConfigValues(@NotNull Module module, @NotNull WarblerConfigModel config, PsiElement file) {
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(36);
        }
        if (config == null) {
            WarblerConfigHelper.$$$reportNull$$$0(37);
        }
        HashMap<String, PsiElement> result = new HashMap<String, PsiElement>();
        String rubyCode = WarblerConfigHelper.getConfigFeaturesAssignments(config);
        result.put("config.features", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        rubyCode = WarblerConfigHelper.getConfigDirsValue(module, config);
        result.put("config.dirs", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        VirtualFile moduleDir = WarblerConfigHelper.getModuleDir(module);
        ConfigIncludesFileFilter includeFileFilter = new ConfigIncludesFileFilter(moduleDir);
        rubyCode = WarblerConfigHelper.getConfigFileListValues(moduleDir, config.getIncludeModel().getFileList(), includeFileFilter, CONFIG_INCLUDES_ASSIGNMENT_TEMPLATE);
        result.put("config.includes", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        FileFilter fakeFileFilter = new FileFilter();
        rubyCode = WarblerConfigHelper.getConfigFileListValues(moduleDir, config.getExcludeModel().getFileList(), fakeFileFilter, CONFIG_EXCLUDES_ASSIGNMENT_TEMPLATE);
        result.put("config.excludes", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        rubyCode = WarblerConfigHelper.getConfigFileListValues(moduleDir, config.getWebInfConfigModel().getFileList(), fakeFileFilter, CONFIG_WEBINF_FILES_ASSIGNMENT_TEMPLATE);
        result.put("config.webinf_files", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        rubyCode = WarblerConfigHelper.getConfigWarFileNameValue(config);
        result.put("config.jar_name", (PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)file, (String)rubyCode));
        HashMap<String, PsiElement> hashMap = result;
        if (hashMap == null) {
            WarblerConfigHelper.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    private static RFile createWarblerConfig(@NotNull Module module) throws IOException {
        VirtualFile configDirectory;
        if (module == null) {
            WarblerConfigHelper.$$$reportNull$$$0(39);
        }
        if ((configDirectory = WarblerConfigHelper.getModuleDir(module).findFileByRelativePath("config")) == null) {
            configDirectory = WarblerConfigHelper.getModuleDir(module).createChildDirectory((Object)module, "config");
        }
        VirtualFile finalConfigDirectory = configDirectory;
        VirtualFile warblerConfigFile = WarblerConfigHelper.getVirtualConfigFile(module);
        if (warblerConfigFile == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    finalConfigDirectory.createChildData((Object)module, "warble.rb");
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        if ((warblerConfigFile = WarblerConfigHelper.getVirtualConfigFile(module)) == null) {
            String message = RBundle.message((String)"warbler.error.cant.write.to.config");
            LOG.error(message);
            throw new IOException(message);
        }
        VirtualFile existedWarblerConfigFile = warblerConfigFile;
        File file = new File(existedWarblerConfigFile.getPath());
        String warblerConfigFileContent = String.format(WARBLER_CONFIG_TEMPLATE, module.getName());
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                FileUtil.writeToFile((File)file, (byte[])warblerConfigFileContent.getBytes(StandardCharsets.UTF_8));
                existedWarblerConfigFile.refresh(false, false);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        RFile rFile = WarblerConfigHelper.getConfigFile(module);
        if (rFile == null) {
            WarblerConfigHelper.$$$reportNull$$$0(40);
        }
        return rFile;
    }

    private static /* synthetic */ void lambda$prepareWarblerConfigFile$2(PsiElement existedWarbleConfigFile, Map configAssignments) {
        Map<String, PsiElement> a = WarblerConfigHelper.getConfigAssignments(existedWarbleConfigFile);
        configAssignments.putAll(a);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 13, 15, 25, 28, 33, 35, 38, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper";
                break;
            }
            case 3: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 20: 
            case 24: 
            case 27: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareWarblerConfigFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigAssignments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFeaturesAssignments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirsValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileListValues";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigWarFileNameValue";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewConfigValues";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarblerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readConfig";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareWarblerConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putValueIntoConfigModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigAssignments";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigAssignment";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseWarbleConfig";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualConfigFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFeaturesAssignments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDirsValue";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFileListValues";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getConfigWarFileNameValue";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNewConfigValues";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createWarblerConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 13, 15, 25, 28, 33, 35, 38, 40 -> new IllegalStateException(string);
        };
    }

    private static class FileFilter {
        private FileFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                FileFilter.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper$FileFilter", "accept"));
        }
    }

    private static final class ConfigIncludesFileFilter
    extends FileFilter {
        private final VirtualFile moduleDir;

        private ConfigIncludesFileFilter(@NotNull VirtualFile moduleDir) {
            if (moduleDir == null) {
                ConfigIncludesFileFilter.$$$reportNull$$$0(0);
            }
            this.moduleDir = moduleDir;
        }

        @Override
        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                ConfigIncludesFileFilter.$$$reportNull$$$0(1);
            }
            return !file.isDirectory() || !file.getParent().equals(this.moduleDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper$ConfigIncludesFileFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

