/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.controllers;

import com.intellij.execution.filters.Filter;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtilRt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.jruby.warbler.helpers.WarblerConfigHelper;
import org.jetbrains.plugins.ruby.jruby.warbler.helpers.WarblerValidatorHelper;
import org.jetbrains.plugins.ruby.jruby.warbler.model.WarblerActionModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblemEnum;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog.WarblerDialog;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog.WarblerDialogListener;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;

public class WarblerDialogController {
    private static final Logger LOG = Logger.getInstance(WarblerDialogController.class);
    private final WarblerActionModel model;
    private final WarblerDialog view;

    public WarblerDialogController(final @NotNull WarblerActionModel model, @NotNull WarblerDialog view) {
        if (model == null) {
            WarblerDialogController.$$$reportNull$$$0(0);
        }
        if (view == null) {
            WarblerDialogController.$$$reportNull$$$0(1);
        }
        this.model = model;
        this.view = view;
        model.getConfig().addWarblerConfigChangedListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                model.setConfigProblem(WarblerValidatorHelper.checkConfig(model.getConfig()));
            }
        });
        model.setEnvironmentProblem(WarblerValidatorHelper.checkEnvironment(model.getModule()));
        view.addWarblerDialogListener(new WarblerDialogListener(){

            @Override
            public void fixActionPerformed(@NotNull WarblerEnvironmentProblemEnum warblerEnvironmentProblemEnum) {
                if (warblerEnvironmentProblemEnum == null) {
                    2.$$$reportNull$$$0(0);
                }
                WarblerDialogController.this.fixProblem(warblerEnvironmentProblemEnum);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warblerEnvironmentProblemEnum", "org/jetbrains/plugins/ruby/jruby/warbler/controllers/WarblerDialogController$2", "fixActionPerformed"));
            }
        });
    }

    public void run() {
        if (this.view.showAndGet()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)this.model.getModule()).getSdk();
            assert (sdk != null);
            try {
                WarblerConfigHelper.saveConfig(this.model.getModule(), this.model.getConfig());
                String[] argsArray = this.model.getConfig().isTrace() ? new String[]{"-t"} : ArrayUtilRt.EMPTY_STRING_ARRAY;
                MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(argsArray, null, null, null);
                Filter[] filters = new Filter[]{new RStackTraceFilter(this.model.getModule())};
                FileDocumentManager.getInstance().saveAllDocuments();
                GemsRunner.runGemScriptInConsoleAndRefreshModule(this.model.getModule(), sdk, RBundle.message((String)"warbler.dialog.caption"), null, "warbler", null, "warble", WarblerConfigHelper.getModuleDir(this.model.getModule()).getPath(), provider, new RunContentDescriptorFactory.PinTabsFactory(), filters, null, true, null);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                String errorMessage = RBundle.message((String)"warbler.config.patching.error", (Object[])new Object[]{e.getMessage()});
                Messages.showErrorDialog((Project)this.model.getModule().getProject(), (String)errorMessage, (String)RBundle.message((String)"warbler.dialog.error.title"));
            }
        }
    }

    protected void installGem(@NotNull String gemName) {
        if (gemName == null) {
            WarblerDialogController.$$$reportNull$$$0(2);
        }
        Module module = this.model.getModule();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        RailsUtil.installGemSupport(sdk, module, gemName, null, null, null);
    }

    protected void executeAction(@NotNull String actionId) {
        if (actionId == null) {
            WarblerDialogController.$$$reportNull$$$0(3);
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)this.model.getDataContext());
        ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
    }

    protected void fixProblem(WarblerEnvironmentProblemEnum warblerEnvironmentProblemEnum) {
        if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.WRONG_SDK) {
            this.executeAction("GemRequirements.ShowSettings");
        } else if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.RAILS_NOT_FOUND) {
            this.installGem("rails");
        } else if (warblerEnvironmentProblemEnum == WarblerEnvironmentProblemEnum.WARBLER_NOT_FOUND) {
            this.installGem("warbler");
        }
        this.model.setEnvironmentProblem(WarblerValidatorHelper.checkEnvironment(this.model.getModule()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/controllers/WarblerDialogController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installGem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

