/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.actions;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.jruby.warbler.model.toggle.ToggleFileListModel;

public class ToggleFileListAction
extends ToggleAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance(ToggleFileListAction.class);
    private final Tree tree;
    private final ToggleFileListModel model;

    public ToggleFileListAction(@NotNull Tree tree, @NotNull ToggleFileListModel model, @NotNull @NlsActions.ActionText String text, @NotNull Icon icon) {
        if (tree == null) {
            ToggleFileListAction.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ToggleFileListAction.$$$reportNull$$$0(1);
        }
        if (text == null) {
            ToggleFileListAction.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            ToggleFileListAction.$$$reportNull$$$0(3);
        }
        this.tree = tree;
        this.model = model;
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(icon);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleFileListAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected List<VirtualFile> getSelectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleFileListAction.$$$reportNull$$$0(5);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        TreePath[] selectionPaths = (TreePath[])e.getUpdateSession().compute((Object)this, "getSelectionPaths", ActionUpdateThread.EDT, () -> this.tree.getSelectionPaths());
        if (selectionPaths != null) {
            for (TreePath treePath : selectionPaths) {
                Object pathComponent = treePath.getLastPathComponent();
                if (pathComponent instanceof FileNode) {
                    FileNode fileNode = (FileNode)pathComponent;
                    result.add(fileNode.getFile());
                    continue;
                }
                if (pathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathComponent;
                    Object nodeDescriptor = node.getUserObject();
                    if (!(nodeDescriptor instanceof FileNodeDescriptor)) continue;
                    result.add(((FileNodeDescriptor)nodeDescriptor).getElement().getFile());
                    continue;
                }
                LOG.error("Unexpected node class: " + String.valueOf(pathComponent.getClass()));
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            ToggleFileListAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleFileListAction.$$$reportNull$$$0(7);
        }
        boolean result = false;
        List<VirtualFile> selectedFiles = this.getSelectedFiles(e);
        if (!selectedFiles.isEmpty()) {
            result = this.model.contains(selectedFiles.get(0));
        }
        return result;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        List<VirtualFile> selectedFiles;
        if (e == null) {
            ToggleFileListAction.$$$reportNull$$$0(8);
        }
        if (!(selectedFiles = this.getSelectedFiles(e)).isEmpty()) {
            for (VirtualFile selectedFile : selectedFiles) {
                if (state) {
                    this.model.addFile(selectedFile);
                    continue;
                }
                this.model.removeFile(selectedFile);
            }
            this.tree.repaint();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleFileListAction.$$$reportNull$$$0(9);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        boolean enabled = true;
        List<VirtualFile> selectedFiles = this.getSelectedFiles(e);
        if (selectedFiles.isEmpty()) {
            enabled = false;
        }
        for (VirtualFile file : selectedFiles) {
            if (file != null && !(enabled = file.isDirectory() ? this.model.isAllowDirectory() : this.model.isAllowFile())) break;
        }
        presentation.setEnabled(enabled);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ToggleFileListAction.$$$reportNull$$$0(10);
        }
        if (place == null) {
            ToggleFileListAction.$$$reportNull$$$0(11);
        }
        return new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/jruby/warbler/actions/ToggleFileListAction";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/actions/ToggleFileListAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

