/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;

public final class I18nKeyRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(0);
        }
        return I18nProvider.forElement(element).isTranslationElement(element);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(1);
        }
        return super.substituteElementToRename(element.getNavigationElement(), editor);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        Module module;
        if (element == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        String key = I18nKeyRenameProcessor.getRenamedFullKey(I18nKeyRenameProcessor.getFullKey(element), newName);
        I18nProvider.getAllLocaleEntries(module).stream().map(localeEntry -> localeEntry.getRecord(key)).filter(Objects::nonNull).forEach(record -> conflicts.put(record, Collections.singletonList(RBundle.message((String)"refactoring.rename.rails.i18n.conflict.duplicate.property.key", (Object[])new Object[]{key}))));
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Module module;
        if (element == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(6);
        }
        if (allRenames == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        String key = I18nKeyRenameProcessor.getFullKey(element);
        I18nProvider.getAllLocaleEntries(module).stream().map(localeEntry -> localeEntry.getRecord(key)).filter(Objects::nonNull).map(localeEntry -> localeEntry.getNavigationElement()).forEach(record -> allRenames.put((PsiElement)record, newName));
    }

    @NotNull
    private static String getFullKey(@NotNull PsiElement element) {
        if (element == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(8);
        }
        String string = StringUtil.notNullize((String)I18nProvider.forElement(element).getFullKey(element));
        if (string == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getRenamedFullKey(@NotNull String fullKey, @NotNull String newName) {
        int index;
        if (fullKey == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(11);
        }
        if ((index = fullKey.lastIndexOf(".")) >= 0) {
            String string = fullKey.substring(0, index + 1) + newName;
            if (string == null) {
                I18nKeyRenameProcessor.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = newName;
        if (string == null) {
            I18nKeyRenameProcessor.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/rename/I18nKeyRenameProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/rename/I18nKeyRenameProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKey";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenamedFullKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFullKey";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRenamedFullKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

