/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nTranslateCallReference;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

public final class RubyI18nTranslateReferenceUtil {
    private RubyI18nTranslateReferenceUtil() {
    }

    @NotNull
    public static List<I18nTranslateReference> createTranslateReferences(@NotNull RPossibleCall possibleCall, @NotNull Module module) {
        if (possibleCall == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(1);
        }
        if (possibleCall.getArguments().isEmpty() || !I18nTranslateCallType.isSimpleScopeOption(possibleCall)) {
            List<I18nTranslateReference> list = Collections.emptyList();
            if (list == null) {
                RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiElement keyElement = (PsiElement)possibleCall.getArguments().get(0);
        List<PsiElement> defaultElements = I18nTranslateCallType.getDefaultKeysOptionElements(possibleCall);
        List elements = ContainerUtil.filter((Collection)ContainerUtil.prepend(defaultElements, (Object[])new PsiElement[]{keyElement}), RubyPsiUtil::isSimpleStringOrSymbol);
        if (RailsApp.fromModule(module) != null && !RubyI18nTranslateReferenceUtil.isI18nTranslateCall(possibleCall)) {
            List list = ContainerUtil.map((Collection)elements, element -> new RailsI18nTranslateCallReference(possibleCall, (PsiElement)element, module));
            if (list == null) {
                RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.map((Collection)elements, element -> new I18nTranslateReference(possibleCall, (PsiElement)element, module));
        if (list == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<String> normaliseTranslateKey(@NotNull String key, @NotNull PsiElement context) {
        List<String> normalisedKeys;
        if (key == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(6);
        }
        if (key.startsWith(".") && !(normalisedKeys = RailsI18nTranslateCallReference.LAZY_SCOPE_PROVIDERS.stream().filter(provider -> provider.isAvailable(context)).flatMap(provider -> provider.getValues(context).stream()).map(scope -> scope + key).collect(Collectors.toList())).isEmpty()) {
            List<String> list = normalisedKeys;
            if (list == null) {
                RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<String> list = Collections.singletonList(StringUtil.trimStart((String)key, (String)"."));
        if (list == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean isI18nTranslateCall(@NotNull RPossibleCall possibleCall) {
        RPsiElement receiver;
        if (possibleCall == null) {
            RubyI18nTranslateReferenceUtil.$$$reportNull$$$0(9);
        }
        if ((receiver = possibleCall.getReceiver()) == null) {
            return false;
        }
        return receiver.getText().equals("I18n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/RubyI18nTranslateReferenceUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/RubyI18nTranslateReferenceUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTranslateReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "normaliseTranslateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTranslateReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normaliseTranslateKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isI18nTranslateCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

