/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nLazyScopeProvider;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

final class RailsI18nViewLazyScopeProvider
implements RailsI18nLazyScopeProvider {
    RailsI18nViewLazyScopeProvider() {
    }

    @Override
    @NotNull
    public List<String> getValues(@NotNull PsiElement context) {
        List<VirtualFile> viewsRoots;
        if (context == null) {
            RailsI18nViewLazyScopeProvider.$$$reportNull$$$0(0);
        }
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement(context);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        List<VirtualFile> list = viewsRoots = module != null ? RailsPaths.getInstance(module).findFiles("app/views") : Collections.emptyList();
        assert (file != null);
        StringBuilder sb = new StringBuilder();
        assert (".".length() == 1);
        for (VirtualFile viewsRoot : viewsRoots) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)viewsRoot, (char)".".charAt(0));
            if (relativePath == null) continue;
            sb.append(relativePath).append(".");
            break;
        }
        String fileName = ViewsConventions.getViewOrLayoutNameByFileName(file.getName());
        sb.append(StringUtil.trimStart((String)fileName, (String)"_"));
        List<String> list2 = Collections.singletonList(sb.toString());
        if (list2 == null) {
            RailsI18nViewLazyScopeProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            RailsI18nViewLazyScopeProvider.$$$reportNull$$$0(2);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement(context);
        return module != null && file != null && VfsUtilCore.isUnderFiles((VirtualFile)file, RailsPaths.getInstance(module).findFiles("app/views"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/RailsI18nViewLazyScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/RailsI18nViewLazyScopeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

