/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nControllerLazyScopeProvider;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nLazyScopeProvider;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nMailerLazyScopeProvider;
import org.jetbrains.plugins.ruby.i18n.references.RailsI18nViewLazyScopeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;

public final class RailsI18nTranslateCallReference
extends I18nTranslateReference {
    @NotNull
    static final List<RailsI18nLazyScopeProvider> LAZY_SCOPE_PROVIDERS = List.of(new RailsI18nControllerLazyScopeProvider(), new RailsI18nMailerLazyScopeProvider(), new RailsI18nViewLazyScopeProvider());
    @NotNull
    private final NotNullLazyValue<List<String>> myLazyScopesProvider;

    RailsI18nTranslateCallReference(@NotNull RPossibleCall possibleCall, @NotNull PsiElement element, @NotNull Module module) {
        if (possibleCall == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(2);
        }
        super(possibleCall, element, module);
        this.myLazyScopesProvider = NotNullLazyValue.atomicLazy(this::computeLazyScopes);
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(3);
        }
        if (result == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(4);
        }
        super.addCompletions(parameters, context, result);
        if (this.getLazyScopes().isEmpty()) {
            return;
        }
        I18nDictionary dictionary = this.getDictionary();
        List<String> fullScopes = this.getFullScopes();
        Collection<String> keys = dictionary.getAllKeys();
        String defaultLocale = RubyI18nFoldingLocaleSettings.getInstance(this.getProject()).getLocale();
        HashMap<String, Set> lazyKeyToFullKeys = new HashMap<String, Set>();
        for (String fullScope : fullScopes) {
            keys.stream().filter(key -> key.startsWith(fullScope)).forEach(key -> lazyKeyToFullKeys.merge(key.substring(fullScope.length()), Collections.singleton(key), ContainerUtil::union));
        }
        lazyKeyToFullKeys.forEach((lazyKey, fullKeys) -> {
            HashSet<String> locales = new HashSet<String>();
            ContainerUtil.map((Collection)fullKeys, dictionary::getLocalesByKey).forEach(locales::addAll);
            String type = RailsI18nTranslateCallReference.getLookupTypeFromLocales(defaultLocale, locales);
            if (RubyCompletionProviderUtil.lookupStringShouldBeProcessed(lazyKey, result)) {
                result.addElement(RailsI18nTranslateCallReference.createLookupElement(lazyKey, type));
            }
        });
    }

    @Override
    @NotNull
    public List<String> getFullKeys() {
        if (!this.isLazilyScoped()) {
            List<String> list = super.getFullKeys();
            if (list == null) {
                RailsI18nTranslateCallReference.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = ContainerUtil.map(this.getFullScopes(), scope -> scope + this.getCanonicalText());
        if (list == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isLazilyScoped() {
        return this.getCanonicalText().startsWith(".") && !this.getLazyScopes().isEmpty();
    }

    @NotNull
    private List<String> computeLazyScopes() {
        RPossibleCall element = this.getElement();
        List<String> list = LAZY_SCOPE_PROVIDERS.stream().filter(provider -> provider.isAvailable((PsiElement)element)).flatMap(provider -> provider.getValues((PsiElement)element).stream()).collect(Collectors.toList());
        if (list == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private List<String> getFullScopes() {
        String scope = this.getScope();
        if (scope == null) {
            return this.getLazyScopes();
        }
        List list = ContainerUtil.map(this.getLazyScopes(), lazyScope -> scope + "." + lazyScope);
        if (list == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<String> getLazyScopes() {
        List list = (List)this.myLazyScopesProvider.getValue();
        if (list == null) {
            RailsI18nTranslateCallReference.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/RailsI18nTranslateCallReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/RailsI18nTranslateCallReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLazyScopes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullScopes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

