/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;

public final class RubyI18nSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @NotNull
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        Set<PsiElement> set = Collections.singleton(element);
        if (set == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean handlesElement(PsiElement element) {
        return I18nProvider.forElement(element).isTranslationElement(element);
    }

    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result) {
        if (element == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        if (allElementsToDelete == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete);
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @NotNull
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        Module module;
        if (element == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(8);
            }
            return list;
        }
        I18nDictionary dictionary = I18nProvider.getDictionary(module);
        String key = I18nProvider.forElement(element).getFullKey(element);
        Collection collection = dictionary.getLocaleEntriesByKey(key).stream().map(localeEntry -> localeEntry.getRecord(key)).filter(Objects::nonNull).map(e -> e.getNavigationElement()).filter(record -> !allElementsToDelete.contains(record)).collect(Collectors.toList());
        if (collection == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        if (allElementsToDelete == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        return null;
    }

    public UsageInfo @NotNull [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(13);
        }
        if (usages == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(14);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element) {
        if (element == null) {
            RubyI18nSafeDeleteProcessor.$$$reportNull$$$0(15);
        }
        I18nProvider.forElement(element).createSafeDeleteSupport().prepareForDeletion(element);
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/refactoring/safeDelete/RubyI18nSafeDeleteProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/refactoring/safeDelete/RubyI18nSafeDeleteProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSearch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalElementsToDelete";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareForDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 14 -> new IllegalStateException(string);
        };
    }
}

