/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

public abstract class LocaleEntry {
    @NotNull
    private final String myRelativeFilePath;

    public LocaleEntry(PsiFile psiFile, String localesRootPath) {
        this.myRelativeFilePath = psiFile.getVirtualFile().getPath().substring(localesRootPath.length() + 1);
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        return LocaleEntry.getPresentableName(this.getLocale());
    }

    @NotNull
    public String getRelativeFilePath() {
        String string = this.myRelativeFilePath;
        if (string == null) {
            LocaleEntry.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.getPsiFile());
    }

    @Nullable
    public abstract PsiFile getPsiFile();

    public abstract String getLocale();

    public abstract List<String> getAllKeys();

    public abstract PsiElement getRecord(String var1);

    public abstract UsageInfo createUsageInfo(PsiElement var1);

    public abstract void createI18nRecord(String var1, String var2);

    @NotNull
    @NlsSafe
    public static String getPresentableName(@Nullable String locale) {
        String string = Optional.ofNullable(locale).map(Locale::forLanguageTag).map(Locale::getDisplayName).map(StringUtil::nullize).orElse((String)ObjectUtils.coalesce((Object)locale, (Object)RBundle.message((String)"rails.i18n.presentable.name.default")));
        if (string == null) {
            LocaleEntry.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/locales/LocaleEntry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

