/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;

final class I18nRubyUtil {
    I18nRubyUtil() {
    }

    public static RAssoc createI18nRecord(RAssoc localeHash, String[] key, String text) {
        int i;
        if (localeHash == null) {
            throw new IncorrectOperationException(RBundle.message((String)"annotator.rails.i18n.locale.missing.locale.entry"));
        }
        RPsiElement localeRoot = localeHash.getValue();
        RAssocList record = localeRoot instanceof RAssocList ? (RAssocList)localeRoot : null;
        for (i = 0; i < key.length; ++i) {
            PsiElement valueByName = record.findValueByName(key[i]);
            if (valueByName == null) {
                return I18nRubyUtil.create(record, key, i, text);
            }
            if (!(valueByName instanceof RAssocList) || i >= key.length - 1) break;
            record = (RAssocList)valueByName;
        }
        StringBuilder builder2 = new StringBuilder();
        int top = Math.min(i + 1, key.length);
        for (int j = 0; j < top; ++j) {
            if (!builder2.isEmpty()) {
                builder2.append('.');
            }
            builder2.append(key[j]);
        }
        throw new IncorrectOperationException(RBundle.message((String)"new.name.conflicts.with", (Object[])new Object[]{builder2.toString()}));
    }

    private static RAssoc create(RAssocList record, String[] key, int i, String text) {
        int j;
        StringBuilder builder2 = new StringBuilder("{");
        for (j = i; j < key.length; ++j) {
            builder2.append(":").append(key[j]).append(" => ");
            if (j < key.length - 1) {
                builder2.append("{\n");
                continue;
            }
            builder2.append(text);
        }
        for (j = i; j < key.length; ++j) {
            builder2.append("\n}");
        }
        RAssocList assocList = (RAssocList)RubyElementFactoryCore.createElementFromText((PsiElement)record, (String)builder2.toString());
        RAssoc assoc = (RAssoc)assocList.getAssocElements().get(0);
        return record.addAssoc(assoc);
    }
}

