/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection.quickfixes;

import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;

final class RubyI18nPropertyValuesEditor {
    @NotNull
    private static final ColumnInfo TRANSLATION_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<MyPropertyValue, String>(RBundle.message((String)"dialog.rails.i18n.create.property.translation")){

        @NotNull
        public String valueOf(MyPropertyValue propertyValue) {
            String string = propertyValue.getTranslation();
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getPreferredStringValue() {
            String string = RBundle.message((String)"dialog.rails.i18n.create.property.translation.example");
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void setValue(MyPropertyValue propertyValue, String translation) {
            propertyValue.setTranslation(translation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "valueOf";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredStringValue";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    @NotNull
    private final List<String> myLocales;
    @NotNull
    private final TableView<MyPropertyValue> myTable;
    @NotNull
    private final ListTableModel<MyPropertyValue> myTableModel;
    @NotNull
    private final ToolbarDecorator myToolbarDecorator;
    @NotNull
    private String myDefaultTranslation;

    RubyI18nPropertyValuesEditor(@NotNull Collection<String> locales, @Nullable String defaultTranslation) {
        if (locales == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(0);
        }
        this.myLocales = ContainerUtil.sorted(locales);
        this.myDefaultTranslation = StringUtil.notNullize((String)defaultTranslation);
        this.myTableModel = new ListTableModel(new ColumnInfo[]{RubyI18nPropertyValuesEditor.createLocaleColumnInfo(), TRANSLATION_COLUMN_INFO});
        this.myTable = new TableView(this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.getEmptyText().setText(RBundle.message((String)"dialog.rails.i18n.create.property.no.translations"));
        this.myTable.setEnableAntialiasing(true);
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)150));
        this.myTable.setVisibleRowCount(7);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RubyI18nPropertyValuesEditor.this.myTable.isEditing()) {
                    TableUtil.stopEditing(RubyI18nPropertyValuesEditor.this.myTable);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }, KeyStroke.getKeyStroke(9, 0), 1);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RubyI18nPropertyValuesEditor.this.myTable.isEditing()) {
                    TableUtil.stopEditing(RubyI18nPropertyValuesEditor.this.myTable);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            }
        }, KeyStroke.getKeyStroke(9, 64), 1);
        this.myToolbarDecorator = ToolbarDecorator.createDecorator(this.myTable).disableUpDownActions().setAddAction(button -> {
            BaseListPopupStep<String> popup = new BaseListPopupStep<String>(RBundle.message((String)"dialog.rails.i18n.create.property.select.locale"), this.getAvailableLocales()){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> RubyI18nPropertyValuesEditor.this.addRow(selectedValue));
                }
            };
            RelativePoint point = (RelativePoint)ObjectUtils.coalesce((Object)button.getPreferredPopupPoint(), (Object)RelativePoint.getNorthEastOf((JComponent)button.getContextComponent()));
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)popup).show(point);
        }).setAddActionUpdater(button -> !this.getAvailableLocales().isEmpty()).setRemoveAction(button -> {
            String translation = (String)ObjectUtils.doIfNotNull((Object)((MyPropertyValue)ContainerUtil.getFirstItem((List)this.myTableModel.getItems())), MyPropertyValue::getTranslation);
            if (TableUtil.doRemoveSelectedItems(this.myTable, this.myTableModel, null) && this.myTableModel.getItems().isEmpty()) {
                this.myDefaultTranslation = StringUtil.notNullize((String)translation);
            }
        }).setRemoveActionUpdater(button -> !this.myTable.getSelectedObjects().isEmpty());
    }

    public void addRow(@Nullable String locale) {
        this.addRow(this.createElement(locale));
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myToolbarDecorator.createPanel();
        if (jPanel == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public List<MyPropertyValue> getPropertyValues() {
        List list = this.myTableModel.getItems();
        if (list == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public JComponent getTable() {
        TableView<MyPropertyValue> tableView = this.myTable;
        if (tableView == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(3);
        }
        return tableView;
    }

    private void addRow(@NotNull MyPropertyValue propertyValue) {
        if (propertyValue == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(4);
        }
        TableUtil.stopEditing(this.myTable);
        this.myTableModel.addRow((Object)propertyValue);
        int index = this.myTableModel.getRowCount() - 1;
        this.myTable.changeSelection(index, 1, false, false);
        if (propertyValue.getTranslation().isEmpty()) {
            TableUtil.editCellAt(this.myTable, (int)index, (int)1);
        }
    }

    @NotNull
    private MyPropertyValue createElement(@Nullable String locale) {
        String translation = this.myTableModel.getRowCount() == 0 ? this.myDefaultTranslation : "";
        List<String> availableLocales = this.getAvailableLocales();
        if (availableLocales.contains(locale)) {
            assert (locale != null);
            return new MyPropertyValue(locale, translation);
        }
        if (!availableLocales.isEmpty()) {
            return new MyPropertyValue(availableLocales.get(0), translation);
        }
        return new MyPropertyValue(this.myLocales.get(0), translation);
    }

    @NotNull
    private List<String> getAddedLocales() {
        List list = ContainerUtil.map((Collection)this.myTableModel.getItems(), MyPropertyValue::getLocale);
        if (list == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(5);
        }
        return list;
    }

    private @Unmodifiable @NotNull List<String> getAvailableLocales() {
        List<String> addedLocales = this.getAddedLocales();
        List list = ContainerUtil.filter(this.myLocales, locale -> !addedLocales.contains(locale));
        if (list == null) {
            RubyI18nPropertyValuesEditor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static ColumnInfo createLocaleColumnInfo() {
        String name = RBundle.message((String)"dialog.rails.i18n.create.property.locale");
        return new ColumnInfo<MyPropertyValue, String>(name){

            @NotNull
            public String valueOf(MyPropertyValue propertyValue) {
                String string = propertyValue.getLocale();
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getPreferredStringValue() {
                String string = RBundle.message((String)"dialog.rails.i18n.create.property.locale.example");
                if (string == null) {
                    5.$$$reportNull$$$0(1);
                }
                return string;
            }

            public int getAdditionalWidth() {
                return 60;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreferredStringValue";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedLocales";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableLocales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    static final class MyPropertyValue {
        @NotNull
        private final String myLocale;
        @NotNull
        private String myTranslation;

        private MyPropertyValue(@NotNull String locale, @NotNull String translation) {
            if (locale == null) {
                MyPropertyValue.$$$reportNull$$$0(0);
            }
            if (translation == null) {
                MyPropertyValue.$$$reportNull$$$0(1);
            }
            this.myLocale = locale;
            this.myTranslation = translation;
        }

        @NotNull
        public String getLocale() {
            String string = this.myLocale;
            if (string == null) {
                MyPropertyValue.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getTranslation() {
            String string = this.myTranslation.trim();
            if (string == null) {
                MyPropertyValue.$$$reportNull$$$0(3);
            }
            return string;
        }

        private void setTranslation(@NotNull String translation) {
            if (translation == null) {
                MyPropertyValue.$$$reportNull$$$0(4);
            }
            this.myTranslation = translation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locale";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "translation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor$MyPropertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/RubyI18nPropertyValuesEditor$MyPropertyValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocale";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTranslation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTranslation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

