/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyDialog;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class I18nCreatePropertyQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.rails.i18n.create.property");
        if (string == null) {
            I18nCreatePropertyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Map localeTranslations;
        String selectedKey;
        PsiElement element;
        RCall call;
        if (project == null) {
            I18nCreatePropertyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            I18nCreatePropertyQuickFix.$$$reportNull$$$0(2);
        }
        if ((call = RubyPsiUtil.getCoveringRCall(element = descriptor.getPsiElement())) == null) {
            return;
        }
        I18nTranslateReference reference = Arrays.stream(call.getReferences()).map(ref -> (I18nTranslateReference)ObjectUtils.tryCast((Object)ref, I18nTranslateReference.class)).filter(Objects::nonNull).filter(ref -> ref.getReferenceContent().equals(element)).findFirst().orElse(null);
        if (reference == null) {
            return;
        }
        I18nDictionary dictionary = reference.getDictionary();
        ArrayList<LocaleEntry> localeEntries = new ArrayList<LocaleEntry>(dictionary.getAllLocaleEntries());
        for (ResolveResult result : reference.multiResolve(false)) {
            String resolvedLocale = ((I18nResolveResult)result).getLocaleEntry().getLocale();
            localeEntries.removeIf(entry -> entry.getLocale().equals(resolvedLocale));
        }
        if (localeEntries.isEmpty()) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Map<String, LocaleEntry> presentationToLocaleEntries = I18nCreatePropertyDialog.createPresentationToLocaleEntries(localeEntries);
            I18nCreatePropertyDialog dialog = new I18nCreatePropertyDialog(project, dictionary, presentationToLocaleEntries, reference.getFullKeys(), null, null);
            if (!dialog.showAndGet()) {
                return;
            }
            selectedKey = dialog.getPropertyKey();
            localeTranslations = ContainerUtil.map2Map(dialog.getLocaleTranslations().entrySet(), entry -> new Pair((Object)((LocaleEntry)presentationToLocaleEntries.get(entry.getKey())), (Object)((String)entry.getValue())));
        } else {
            selectedKey = (String)ContainerUtil.getFirstItem(reference.getFullKeys());
            localeTranslations = Collections.singletonMap((LocaleEntry)ContainerUtil.getFirstItem(localeEntries), "test");
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RBundle.message((String)"inspection.rails.i18n.create.property"), null, () -> localeTranslations.forEach((localeEntry, translation) -> localeEntry.createI18nRecord(selectedKey, (String)translation)), (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            I18nCreatePropertyQuickFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            I18nCreatePropertyQuickFix.$$$reportNull$$$0(4);
        }
        return new IntentionPreviewInfo.Html(RBundle.message((String)"inspection.rails.i18n.create.property.preview"));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

