/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyQuickFix;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class I18nKeyInspectionVisitor
extends RubyInspectionVisitor {
    public I18nKeyInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            I18nKeyInspectionVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            I18nKeyInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (!(rCall.getCallType() instanceof I18nTranslateCallType)) {
            return;
        }
        List arguments = rCall.getArguments();
        if (arguments.isEmpty()) {
            this.registerProblem((PsiElement)rCall, RBundle.message((String)"inspection.rails.i18n.translate.call.wrong.arguments"));
            return;
        }
        I18nDictionary dictionary = I18nDictionary.forElement((PsiElement)rCall);
        if (dictionary == null) {
            return;
        }
        Collection<LocaleEntry> entries = dictionary.getAllLocaleEntries();
        for (PsiReference reference : rCall.getReferences()) {
            I18nTranslateReference translateReference = (I18nTranslateReference)ObjectUtils.tryCast((Object)reference, I18nTranslateReference.class);
            if (translateReference == null) continue;
            String key = translateReference.getCanonicalText();
            ResolveResult[] results = translateReference.multiResolve(false);
            if (results.length == 0) {
                if (entries.isEmpty()) {
                    this.registerProblem(translateReference.getReferenceContent(), RBundle.message((String)"inspection.rails.i18n.key.not.found", (Object[])new Object[]{key}));
                    continue;
                }
                this.registerProblem(translateReference.getReferenceContent(), RBundle.message((String)"inspection.rails.i18n.key.not.found", (Object[])new Object[]{key}), new I18nCreatePropertyQuickFix());
                continue;
            }
            HashSet locales = new HashSet();
            translateReference.getFullKeys().forEach(fullKey -> locales.addAll(dictionary.getLocalesByKey((String)fullKey)));
            if (dictionary.getAllLocales().size() <= locales.size()) continue;
            this.registerProblem(translateReference.getReferenceContent(), RBundle.message((String)"inspection.rails.i18n.key.not.defined", (Object[])new Object[]{key}), ProblemHighlightType.WEAK_WARNING, new I18nCreatePropertyQuickFix());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/I18nKeyInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

