/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.config.I18nFoldersChooserPanel;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;

public class I18nConfigurable
implements Configurable {
    private final Module myModule;
    private I18nFoldersChooserPanel myI18nFoldersChooserPanel;
    private List<String> myI18nFolders;

    public I18nConfigurable(Module module) {
        this.myModule = module;
    }

    public String getDisplayName() {
        return RBundle.message((String)"module.settings.dialog.i18n.folders.tab.title");
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myI18nFolders = new ArrayList<String>(RubyModuleSettings.getInstance(this.myModule).getI18nFolders());
        this.myI18nFoldersChooserPanel = new I18nFoldersChooserPanel(this.myI18nFolders, this.myModule.getProject());
        return this.myI18nFoldersChooserPanel.getContentPane();
    }

    public boolean isModified() {
        return this.myI18nFoldersChooserPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myI18nFoldersChooserPanel.apply();
        RubyModuleSettings.getInstance(this.myModule).setI18nFolders(this.myI18nFolders);
    }

    public void reset() {
        this.myI18nFoldersChooserPanel.reset();
    }
}

