/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.gem.actions.QuickInstallGemDialog;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class GemProjectUtil {
    public static final String LIB = "lib";

    private GemProjectUtil() {
    }

    public static void installBundler(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            GemProjectUtil.$$$reportNull$$$0(0);
        }
        Project project = RModuleUtil.getInstance().getProject(module);
        HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
        TreeSet<GemInfo> bundlerGems = new TreeSet<GemInfo>(Collections.reverseOrder(new GemComparator()));
        Runnable queryGemVersions = () -> {
            List<GemInfo> queriedGemInfos = GemRunner.query(module, sdk, null, () -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                return indicator != null && indicator.isCanceled();
            }, "bundler");
            bundlerGems.addAll(queriedGemInfos);
        };
        boolean isSuccessful = ProgressManager.getInstance().runProcessWithProgressSynchronously(queryGemVersions, RBundle.message((String)"gem.download.bundler.gem"), true, project);
        if (!isSuccessful) {
            return;
        }
        if (bundlerGems.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)RBundle.message((String)"gem.download.bundler.error"), (String)RBundle.message((String)"gems.gem.installing.failed"));
            return;
        }
        List versions = ContainerUtil.map(bundlerGems, gemInfo -> gemInfo.getVersion());
        GemInfo bundler = (GemInfo)ContainerUtil.getFirstItem(bundlerGems);
        QuickInstallGemDialog dialog = new QuickInstallGemDialog(project, bundler, versions);
        if (dialog.showAndGet()) {
            GemDependency dependency = GemDependency.create("bundler", dialog.getVersion());
            if (dependency != null) {
                GemInstallCommandOptions options = new GemInstallCommandOptions().withIgnoreDependencies(!dialog.installDependencies()).withNoDocument(!dialog.generateDocs());
                GemInstallProcessOptions processOptions = new GemInstallProcessOptions(errors).withUpdatingInstalledGems().withAsynchronousGemSync();
                GemInstallUtil.installGemsInBackground(sdk, module, Collections.singleton(dependency), options, processOptions);
            }
            GemUiUtil.showInstallErrors(project, errors);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/ruby/gem/util/GemProjectUtil", "installBundler"));
    }
}

