/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;

public abstract class GemDependencyResolver {
    @NotNull
    protected final Set<GemInfo> myGems;
    @NotNull
    protected final Set<GemInfo> mySdkGems;
    @NotNull
    private final Set<GemDependency> myAdditionalRequirements;
    protected final Set<GemDependency> myRequirements;
    protected Set<GemInfo> myResolveResult;
    protected boolean isResolved;

    public GemDependencyResolver(@NotNull Collection<? extends GemInfo> sdkGems, @NotNull @NotNull Set<@NotNull GemDependency> additionalRequirements) {
        if (sdkGems == null) {
            GemDependencyResolver.$$$reportNull$$$0(0);
        }
        if (additionalRequirements == null) {
            GemDependencyResolver.$$$reportNull$$$0(1);
        }
        this.myGems = new HashSet<GemInfo>();
        this.mySdkGems = new HashSet<GemInfo>();
        this.myAdditionalRequirements = new HashSet<GemDependency>();
        this.myRequirements = new HashSet<GemDependency>();
        this.myAdditionalRequirements.addAll(additionalRequirements);
        this.mySdkGems.addAll(sdkGems);
        this.mySdkGems.addAll(GemManager.buildGemsFromPathRequirements(additionalRequirements));
    }

    @NotNull
    public Set<GemInfo> resolveDependencies() {
        this.update();
        Set<GemInfo> set = this.myResolveResult == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myResolveResult);
        if (set == null) {
            GemDependencyResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void update() {
        if (!this.isResolved) {
            this.gatherRequirements();
            this.doResolve();
        }
    }

    protected abstract void doResolve();

    protected static List<GemDependency> asRequirements(GemInfo gem) {
        return Arrays.asList(gem.getDependencies());
    }

    private void gatherRequirements() {
        this.myRequirements.clear();
        for (GemInfo gem : this.myGems) {
            this.myRequirements.addAll(GemDependencyResolver.asRequirements(gem));
        }
        this.myRequirements.addAll(this.myAdditionalRequirements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkGems";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRequirements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/GemDependencyResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/GemDependencyResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

