/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;

public class DefaultGemDependencyResolver
extends GemDependencyResolver {
    private static final Logger LOG = Logger.getInstance(DefaultGemDependencyResolver.class);

    public DefaultGemDependencyResolver(@NotNull Collection<GemInfo> rootGems, @NotNull @NotNull Set<@NotNull GemDependency> additionalRequirements) {
        if (rootGems == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(0);
        }
        if (additionalRequirements == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(1);
        }
        super(rootGems, additionalRequirements);
    }

    @Override
    protected void doResolve() {
        HashMap<String, GemInfo> requiredGems = new HashMap<String, GemInfo>();
        HashSet<GemInfo> result = new HashSet<GemInfo>();
        LinkedList<GemDependency> queue = new LinkedList<GemDependency>(DefaultGemDependencyResolver.mergeRequirements(this.myRequirements));
        while (!queue.isEmpty()) {
            GemInfo gem;
            GemDependency requirement = (GemDependency)queue.poll();
            if (ContainerUtil.exists(result, requirement::isSatisfied) || (gem = DefaultGemDependencyResolver.findGemByDependency(this.mySdkGems, requirement, result)) == null) continue;
            result.add(gem);
            GemInfo oldGem = requiredGems.put(gem.getName(), gem);
            if (oldGem != null && !gem.equals(oldGem)) {
                String msg = "Two different versions of gem is required (" + String.valueOf(oldGem) + ", " + String.valueOf(gem) + ") because of " + String.valueOf(requirement);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.debug(msg);
                } else {
                    LOG.warn(msg);
                }
            }
            queue.addAll(DefaultGemDependencyResolver.asRequirements(gem));
        }
        this.myResolveResult = result;
        this.isResolved = true;
    }

    private static Collection<GemDependency> mergeRequirements(Set<GemDependency> requirements) {
        MultiMap result = MultiMap.createSet();
        for (GemDependency requirement : requirements) {
            String name = requirement.getName();
            Collection deps = result.get((Object)name);
            boolean shouldAdd = true;
            if (!deps.isEmpty()) {
                for (GemDependency dep : deps.toArray(new GemDependency[0])) {
                    if (dep.canEat(requirement)) {
                        shouldAdd = false;
                        continue;
                    }
                    if (!requirement.canEat(dep)) continue;
                    deps.remove(dep);
                }
            }
            if (!shouldAdd) continue;
            result.putValue((Object)name, (Object)requirement);
        }
        return result.values();
    }

    @Nullable
    private static GemInfo findGemByDependency(Collection<GemInfo> sdkGems, GemDependency dependency, Set<GemInfo> addedGems) {
        GemInfo maxGem = RubyGemSearchUtil.findGem(addedGems, dependency::isSatisfied);
        return maxGem != null ? maxGem : RubyGemSearchUtil.findGem(sdkGems, dependency::isSatisfied);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootGems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "additionalRequirements";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/gem/util/DefaultGemDependencyResolver";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

