/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigService;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemEnvironment;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class BundlerUtil {
    public static final String GEMS = "gems";
    public static final String BUNDLER = "bundler";
    public static final String BUNDLE = "bundle";
    public static final String GEMFILE = "Gemfile";
    public static final String BUNDLE_FOLDER = ".bundle";
    public static final String BUNDLER_FOLDER = ".bundler";
    public static final String GEMS_RB = "gems.rb";
    private static final String GEMS_LOCKED = "gems.locked";
    private static final String[] GEMFILE_NAMES = new String[]{"Gemfile", "gems.rb"};
    public static final String RBUNDLER_SETUP = "-rbundler/setup";
    public static final String BUNDLER_HTTP_PROXY_ENV_VAR = "HTTP_PROXY";
    private static final Logger LOG = Logger.getInstance(BundlerUtil.class);
    public static final String LOCK_EXT = ".lock";
    @Deprecated
    private static final String GEMFILE_LOCK = "Gemfile.lock";
    private static final String RVM_BUNDLER_GEM_ROOT_SUFFIX = "/bundler/gems";
    private static final String SEPARATOR = "/";
    private static final String GROUPING = "group";

    private BundlerUtil() {
    }

    public static void addBundlerBinPaths(Module module, List<String> binaryScriptsLookupFolders) {
        if (module == null || module.isDisposed()) {
            return;
        }
        BundlerUtil.addBinIfExists(BundlerUtil.getBundlerGemsDirFromConfig(module), binaryScriptsLookupFolders);
        for (VirtualFile root : RModuleUtil.getContentRoots(module)) {
            BundlerUtil.addBinIfExists(root, binaryScriptsLookupFolders);
        }
    }

    @RequiresWriteLock
    public static int addGemToGemfile(@NotNull RFile gemfile, @NotNull String name, @NotNull String group, @Nullable String additionalOptions) {
        if (gemfile == null) {
            BundlerUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BundlerUtil.$$$reportNull$$$0(1);
        }
        if (group == null) {
            BundlerUtil.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertWriteAccess();
        RCompoundStatement statement = gemfile.getCompoundStatement().getStatements().stream().mapMulti(StreamUtil.select(RBlockCall.class, (Class[])new Class[0])).filter(call -> {
            if (!RubyPsiUtil.isCallWithCommand((PsiElement)call, GROUPING)) {
                return false;
            }
            return ContainerUtil.or((Iterable)call.getArguments(), argument -> group.equals(RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)argument)));
        }).map(call -> call.getBlock().getCompoundStatement()).findFirst().orElse(gemfile.getCompoundStatement());
        PsiElement anchor = statement.getStatements().stream().mapMulti(StreamUtil.select(RCall.class, (Class[])new Class[0])).filter(call -> RubyPsiUtil.isCallWithCommand((PsiElement)call, "gem")).filter(call -> {
            String other = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()));
            if (other == null) {
                return false;
            }
            return name.compareTo(other) < 0;
        }).findFirst().orElse(null);
        String groupOption = gemfile.getCompoundStatement() == statement ? String.format("group: '%s'", group) : null;
        String options = (String)(groupOption != null ? ", " + groupOption : "") + (String)(additionalOptions != null ? ", " + additionalOptions : "");
        RExpression element = RubyElementFactoryCore.createExpressionFromText((PsiElement)gemfile, (String)String.format("gem '%s'%s", name, options).trim());
        if (anchor != null) {
            return statement.addBefore((PsiElement)element, anchor).getTextOffset();
        }
        return statement.add((PsiElement)element).getTextOffset();
    }

    public static void openGemFileInEditor(@NotNull Project project, @NotNull String rootPath) {
        if (project == null) {
            BundlerUtil.$$$reportNull$$$0(3);
        }
        if (rootPath == null) {
            BundlerUtil.$$$reportNull$$$0(4);
        }
        GeneratorsUtil.openFileInEditor(project, new File(rootPath, GEMFILE).exists() ? GEMFILE : GEMS_RB, rootPath);
    }

    private static void addBinIfExists(@Nullable VirtualFile parentDir, @NotNull List<String> collector) {
        if (collector == null) {
            BundlerUtil.$$$reportNull$$$0(5);
        }
        if (parentDir == null) {
            return;
        }
        VirtualFile bin = parentDir.findChild("bin");
        if (bin != null) {
            collector.add(bin.getPath());
        }
    }

    public static boolean installBundler(@Nullable Module module, @Nullable Sdk sdk) {
        if (sdk == null && (sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null) {
            return false;
        }
        HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
        GemInstallUtil.installGemsInBackground(sdk, module, GemDependency.anyAsList(BUNDLER), new GemInstallCommandOptions().withNoDocument(), new GemInstallProcessOptions(errors).withUpdatingInstalledGems().withAsynchronousGemSync());
        if (!errors.isEmpty()) {
            GemUiUtil.showInstallErrors(module, errors);
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean hasGemfile(@Nullable Module module) {
        return BundlerUtil.getGemfile(module) != null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RFile getGemfilePsiFile(@Nullable Module module) {
        return (RFile)ReadAction.compute(() -> {
            if (module == null || module.isDisposed()) {
                return null;
            }
            VirtualFile gemfile = BundlerUtil.getGemfile(module);
            if (gemfile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(gemfile);
            return psiFile instanceof RFile ? (RFile)psiFile : null;
        });
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile getGemfile(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            LOG.debug("RMInspectionToolLaunch is activated. Try to find Gemfile for inspection tool.");
            return BundlerUtil.getGemfileForInspectionTool();
        }
        LOG.debug("Try to find bundle config for module " + module.getName());
        BundleConfig bundleConfig = BundleConfigServiceImpl.getInstance(module.getProject()).getConfig(module);
        if (bundleConfig != null) {
            LOG.debug("Bundle config exists. Try to find custom Gemfile.");
            VirtualFile customGemFile = bundleConfig.getBundleGemfileVirtualFile();
            if (customGemFile != null) {
                LOG.debug("Custom Gemfile found. Custom Gemfile file path: " + customGemFile.getPath());
                return customGemFile;
            }
        }
        LOG.debug("Try to find regular Gemfile in module " + module.getName());
        return RModuleUtil.findFileInModuleRoot(module, false, true, GEMFILE_NAMES);
    }

    @Nullable
    public static VirtualFile getGemfile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            BundlerUtil.$$$reportNull$$$0(6);
        }
        if (root == null) {
            BundlerUtil.$$$reportNull$$$0(7);
        }
        if (!root.isValid() || !root.isDirectory()) {
            return null;
        }
        for (String gemfileName : GEMFILE_NAMES) {
            VirtualFile gemFile = root.findChild(gemfileName);
            if (gemFile == null || ProjectFileIndex.getInstance((Project)project).isExcluded(gemFile)) continue;
            return gemFile;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile getGemfileLock(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (VirtualFile)ReadAction.nonBlocking(() -> BundlerUtil.getGemfileLock(module, false)).expireWhen(() -> module.isDisposed()).executeSynchronously();
    }

    @Nullable
    public static VirtualFile getGemfileLockWithRefresh(@Nullable Module module) {
        return BundlerUtil.getGemfileLock(module, true);
    }

    @Nullable
    private static VirtualFile getGemfileLock(@Nullable Module module, boolean refreshVFS) {
        if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            return BundlerUtil.getGemfileLockForInspectionTool();
        }
        VirtualFile gemfile = BundlerUtil.getGemfile(module);
        if (gemfile == null) {
            return null;
        }
        return RModuleUtil.findFileInModuleRoot(module, refreshVFS, true, BundlerUtil.getLockFileName(gemfile));
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> getGemfileLockWithRoot(@NotNull Module module) {
        VirtualFile gemfile;
        if (module == null) {
            BundlerUtil.$$$reportNull$$$0(8);
        }
        if ((gemfile = BundlerUtil.getGemfile(module)) == null) {
            return null;
        }
        Ref ref = Ref.create();
        RModuleUtil.processFilesInModuleRoot(module, false, true, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(file, root) -> {
            ProgressManager.checkCanceled();
            ref.set((Object)new Pair(file, root));
            return false;
        }), BundlerUtil.getLockFileName(gemfile));
        return (Pair)ref.get();
    }

    @NotNull
    private static String getLockFileName(@NotNull VirtualFile gemfile) {
        if (gemfile == null) {
            BundlerUtil.$$$reportNull$$$0(9);
        }
        Object object = GEMS_RB.equalsIgnoreCase(gemfile.getName()) ? GEMS_LOCKED : gemfile.getName() + LOCK_EXT;
        if (object == null) {
            BundlerUtil.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Nullable
    private static VirtualFile getGemfileLockForInspectionTool() {
        VirtualFile gemfile = BundlerUtil.getGemfileForInspectionTool();
        if (gemfile == null || !gemfile.isValid()) {
            return null;
        }
        VirtualFile gemfileRoot = gemfile.getParent();
        return gemfileRoot == null || !gemfileRoot.isValid() ? null : gemfileRoot.findChild(BundlerUtil.getLockFileName(gemfile));
    }

    public static boolean isGemfile(@Nullable PsiFileSystemItem psiFileSystemItem) {
        return psiFileSystemItem != null && BundlerUtil.isGemfile(psiFileSystemItem.getProject(), psiFileSystemItem.getVirtualFile());
    }

    @Deprecated
    @Contract(value="null -> false")
    public static boolean isGemfile(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null || virtualFile.isDirectory()) {
            return false;
        }
        if (BundlerUtil.isGemfileName(virtualFile.getName())) {
            return true;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!BundleConfigService.getInstance((Project)project).isGemFile(virtualFile)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean isGemfile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            BundlerUtil.$$$reportNull$$$0(11);
        }
        return BundlerUtil.isGemfile(virtualFile) && !ProjectFileIndex.getInstance((Project)project).isExcluded(virtualFile);
    }

    public static boolean isGemfileName(@Nullable String fileName) {
        return GEMFILE.equalsIgnoreCase(fileName) || GEMS_RB.equalsIgnoreCase(fileName);
    }

    public static boolean isGemfileLockName(@Nullable String fileName) {
        return GEMFILE_LOCK.equalsIgnoreCase(fileName) || GEMS_LOCKED.equalsIgnoreCase(fileName);
    }

    public static void addBundlerPaths(@NotNull Sdk sdk, @NotNull Set<String> result) {
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(12);
        }
        if (result == null) {
            BundlerUtil.$$$reportNull$$$0(13);
        }
        for (String s : ArrayUtilRt.toStringArray(result)) {
            result.add(s.replaceAll("/gems$", RVM_BUNDLER_GEM_ROOT_SUFFIX));
        }
        String home = SystemProperties.getUserHome();
        VirtualFile homeDir = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)home));
        if (homeDir == null) {
            return;
        }
        VirtualFile bundleDir = homeDir.findChild(BUNDLER_FOLDER);
        if (bundleDir == null) {
            bundleDir = homeDir.findChild(BUNDLE_FOLDER);
        }
        if (bundleDir == null) {
            return;
        }
        VirtualFile gemsDir = bundleDir.findChild(BundlerUtil.getSdkTypeStr(sdk));
        if (gemsDir == null || !gemsDir.isDirectory()) {
            return;
        }
        StringBuilder path = new StringBuilder(gemsDir.getUrl());
        path.append(SEPARATOR).append(BundlerUtil.getGemSdkVersion(sdk));
        result.add(String.valueOf(path) + "/gems");
        path.append(SEPARATOR).append(BUNDLER);
        path.append(SEPARATOR).append(GEMS);
        result.add(path.toString());
    }

    @NotNull
    public static String getGemSdkVersion(@NotNull Sdk sdk) {
        String rubyVersion;
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(14);
        }
        if ((rubyVersion = RbConfig.notNullFrom(sdk).getRubyVersion()) == null) {
            rubyVersion = "unknown.ruby.version";
            LOG.warn("Failed to obtain Ruby version for: " + String.valueOf(sdk) + ". Falling back to: " + rubyVersion);
        }
        String string = rubyVersion;
        if (string == null) {
            BundlerUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getSdkTypeStr(@Nullable Sdk sdk) {
        return JRubySdkUtil.isJRubySDK(sdk) ? "jruby" : "ruby";
    }

    @Nullable
    public static VirtualFile getBundlerGemsDirFromConfig(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (VirtualFile)ReadAction.nonBlocking(() -> {
            Project project = module.getProject();
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            VirtualFile dir = BundlerUtil.doGetBundlerGemsDir(sdk, BundleConfigServiceImpl.getInstance(project).getConfig(module));
            if (RubyRemoteInterpreterManager.isRemoteSdk(sdk) || dir != null) {
                return dir;
            }
            return BundlerUtil.doGetBundlerGemsDir(sdk, BundleConfigServiceImpl.getInstance(project).getUserConfig(module));
        }).executeSynchronously();
    }

    @Nullable
    private static VirtualFile doGetBundlerGemsDir(@Nullable Sdk sdk, @Nullable BundleConfig config) {
        VirtualFile bundlePath = (VirtualFile)ObjectUtils.doIfNotNull((Object)config, BundleConfig::getBundlePathVirtualFile);
        if (bundlePath == null) {
            return null;
        }
        VirtualFile gemFolder = BundlerUtil.findGemFolderForSdk(sdk, bundlePath.getPath());
        if (gemFolder == null) {
            LOG.warn("Bundler gem folder for SDK '" + String.valueOf(sdk) + "' is not found at: " + bundlePath.getPath());
        }
        return gemFolder;
    }

    @Nullable
    public static GemInfo getBundlerGem(@Nullable Sdk sdk, @Nullable Module module, boolean execution) {
        GemInfo gemInfo;
        if (execution) {
            GemDependency dep = GemDependency.create(BUNDLER, ">= 0.9");
            assert (dep != null);
            gemInfo = module != null ? RubyProjectGemSearchService.Companion.findGem(module, dep) : null;
            gemInfo = gemInfo == null ? RubyGemSearchUtil.findGem(module, sdk, dep) : gemInfo;
        } else {
            gemInfo = module != null ? RubyProjectGemSearchService.Companion.findGem(module, BUNDLER) : null;
            gemInfo = gemInfo == null ? RubyGemSearchUtil.findGem(module, sdk, BUNDLER) : gemInfo;
        }
        return gemInfo;
    }

    public static void patchBundleExecCommandLine(@NotNull Sdk sdk, @Nullable Module module, @NotNull GeneralCommandLine cmdLine, @Nullable RunnerSettings runnerSettings) {
        String bundle;
        String rubyOpt;
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(16);
        }
        if (cmdLine == null) {
            BundlerUtil.$$$reportNull$$$0(17);
        }
        if ((rubyOpt = (String)cmdLine.getEnvironment().get("RUBYOPT")) != null) {
            String newRubyOpt = rubyOpt.replace(RBUNDLER_SETUP, "");
            if (newRubyOpt.isEmpty()) {
                cmdLine.getEnvironment().remove("RUBYOPT");
            } else {
                cmdLine.withEnvironment("RUBYOPT", newRubyOpt);
            }
        }
        if ((bundle = RbenvGemsetManager.getShimsCommandPath(BUNDLE)) == null) {
            bundle = BundlerUtil.getBundlerScriptPath(sdk, module);
        }
        if (bundle != null && BundlerUtil.shouldAddBundleExec(cmdLine)) {
            String oldExePath = cmdLine.getExePath();
            cmdLine.withExePath(RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(bundle));
            ParametersList parametersList = cmdLine.getParametersList();
            parametersList.addAt(0, "exec");
            int lastSeparator = oldExePath.lastIndexOf(Platform.current().fileSeparator);
            String command = lastSeparator == -1 ? oldExePath : oldExePath.substring(lastSeparator + 1);
            parametersList.addAt(1, command);
        }
    }

    @Nullable
    public static String getBundlerScriptPath(@Nullable Sdk sdk, @Nullable Module module) {
        String bundlerPath = RubyGemExecutionContext.getScriptPath(sdk, module, BUNDLER, BUNDLE);
        if (sdk == null && module != null) {
            sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        }
        return sdk == null || bundlerPath == null ? bundlerPath : RubySdkUtil.convertToRemote(sdk, module, bundlerPath);
    }

    private static void patchCommandLine(@Nullable Sdk sdk, @Nullable Module module, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, boolean alternativeSdk) {
        RubySdkSystemAccessor accessor;
        VirtualFile bundlerFile;
        Map env;
        if (cmdLine == null) {
            BundlerUtil.$$$reportNull$$$0(18);
        }
        if (runnerId == null) {
            BundlerUtil.$$$reportNull$$$0(19);
        }
        if ((env = cmdLine.getEnvironment()).isEmpty()) {
            return;
        }
        GemInfo bundlerGem = BundlerUtil.getBundlerGem(sdk, alternativeSdk ? null : module, true);
        VirtualFile bundlerLib = bundlerGem != null ? bundlerGem.getLibFolder() : null;
        VirtualFile virtualFile = bundlerFile = bundlerGem != null ? bundlerGem.getFile() : null;
        assert (bundlerFile != null && bundlerFile.isValid()) : "[ Bundler: " + String.valueOf(bundlerGem) + "; File: " + String.valueOf(bundlerFile) + "; Lib: " + String.valueOf(bundlerLib) + "; ]";
        RubyRunner runner = BundlerUtil.getRunner(sdk, module, cmdLine);
        if (sdk != null) {
            RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
            accessor = data.getSdkSystemAccessor();
        } else {
            accessor = LocalRubySdkSystemAccessor.getInstance();
        }
        PathMappingSettings mappingSettings = runner.addDefaultMappings(null);
        env.put("BUNDLE_BIN_PATH", mappingSettings.convertToRemote(bundlerFile.getPath() + "/bin"));
        VirtualFile bundleDir = BundlerUtil.getBundlerGemsDirFromConfig(module);
        if (bundleDir == null) {
            bundleDir = BundlerUtil.getDefaultBundleDir(sdk);
        }
        if (bundleDir != null) {
            String path = FileUtil.toSystemDependentName((String)bundleDir.getPath()) + File.separator + "bin";
            String envName = OSUtil.getPathEnvVariableName();
            String newPath = OSUtil.prependToPathEnvVariable((String)env.get(envName), path);
            env.put(envName, newPath);
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        assert (gemFile != null);
        env.put("BUNDLE_GEMFILE", mappingSettings.convertToRemote(gemFile.getPath()));
        String rubyLib = (String)env.get("RUBYLIB");
        if (bundlerLib != null) {
            rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(bundlerLib.getPath()));
            env.put("RUBYLIB", rubyLib);
        }
        Object bundlerExecCommand = "";
        if (RubyAbstractCommandLineState.isInRubyDebugMode(runnerId) && sdk != null) {
            try {
                DebugGemHelper debugGemHelper = RubyAbstractCommandLineState.selectDebugGemHelper(sdk, module, RubyDebugMode.NORMAL_MODE);
                if (debugGemHelper.needsDebugPreLoader()) {
                    String gemsPath = RubyUtil.getScriptFullPath("rb/gems");
                    assert (gemsPath != null);
                    rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(gemsPath));
                    env.put("RUBYLIB", rubyLib);
                    bundlerExecCommand = (String)bundlerExecCommand + "-rdebug_preloader.rb ";
                }
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        bundlerExecCommand = (String)bundlerExecCommand + RBUNDLER_SETUP;
        String rubyOpt = (String)env.get("RUBYOPT");
        if (!StringUtil.isEmpty((String)rubyOpt)) {
            bundlerExecCommand = (String)bundlerExecCommand + " " + rubyOpt;
        }
        env.put("RUBYOPT", bundlerExecCommand);
    }

    public static void addBundlerEnvironment(@NotNull Map<String, String> env, @NotNull Sdk sdk, @Nullable Module module, @Nullable VirtualFile gemFile) {
        if (env == null) {
            BundlerUtil.$$$reportNull$$$0(20);
        }
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(21);
        }
        if (gemFile == null) {
            return;
        }
        RubyRunner runner = RunnerUtil.getRunner(sdk, module);
        env.put("BUNDLE_GEMFILE", runner.addDefaultMappings(null).convertToRemote(gemFile.getPath()));
    }

    @NotNull
    private static RubyRunner getRunner(Sdk sdk, Module module, GeneralCommandLine cmdLine) {
        if (cmdLine instanceof RubyCommandLine) {
            RubyRunner rubyRunner = ((RubyCommandLine)cmdLine).getRunner();
            if (rubyRunner == null) {
                BundlerUtil.$$$reportNull$$$0(22);
            }
            return rubyRunner;
        }
        if (sdk != null) {
            RubySdkAdditionalData data = RubySdkUtil.getRubySdkAdditionalData(sdk);
            RubyRunner rubyRunner = data.getRunner(module);
            if (rubyRunner == null) {
                BundlerUtil.$$$reportNull$$$0(23);
            }
            return rubyRunner;
        }
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module);
        if (rubyLocalRunner == null) {
            BundlerUtil.$$$reportNull$$$0(24);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public static List<String> getIgnoredGroupsFromConfig(@Nullable Module module) {
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BundlerUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        Project project = module.getProject();
        BundleConfig moduleConfig = BundleConfigServiceImpl.getInstance(project).getConfig(module);
        List<String> groups = BundlerUtil.doGetGroups(moduleConfig);
        List<String> list = groups.isEmpty() ? BundlerUtil.doGetGroups(BundleConfigServiceImpl.getInstance(project).getUserConfig(module)) : groups;
        if (list == null) {
            BundlerUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static List<String> doGetGroups(@Nullable BundleConfig config) {
        List list = (List)ObjectUtils.notNull((Object)((List)ObjectUtils.doIfNotNull((Object)config, BundleConfig::getBundleWithout)), Collections.emptyList());
        if (list == null) {
            BundlerUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    public static String addRVMBundleUrl(@NotNull Sdk sdk) {
        String mainPath;
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(28);
        }
        if ((mainPath = RVMSupportUtil.determineMainGemRootPath(sdk)) == null) {
            return null;
        }
        return VirtualFileUtil.constructLocalUrl(mainPath) + RVM_BUNDLER_GEM_ROOT_SUFFIX;
    }

    public static boolean isFakeRVMBundlerGemRootUrl(@NotNull String gemsRootUrl) {
        if (gemsRootUrl == null) {
            BundlerUtil.$$$reportNull$$$0(29);
        }
        return gemsRootUrl.endsWith(RVM_BUNDLER_GEM_ROOT_SUFFIX);
    }

    @Nullable
    public static VirtualFile getDefaultBundleDir(@Nullable Sdk sdk) {
        String path = SystemProperties.getUserHome() + SEPARATOR;
        VirtualFile bundlePath = BundlerUtil.findGemFolderForSdk(sdk, path + BUNDLER_FOLDER);
        if (bundlePath == null) {
            bundlePath = BundlerUtil.findGemFolderForSdk(sdk, path + BUNDLE_FOLDER);
        }
        return bundlePath;
    }

    @Nullable
    private static VirtualFile findGemFolderForSdk(@Nullable Sdk sdk, @NotNull String bundlePath) {
        if (bundlePath == null) {
            BundlerUtil.$$$reportNull$$$0(30);
        }
        if (sdk == null) {
            return null;
        }
        String path = bundlePath + SEPARATOR + BundlerUtil.getSdkTypeStr(sdk) + SEPARATOR + BundlerUtil.getGemSdkVersion(sdk);
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
    }

    public static boolean isBundlerRuntimeEmulationEnabled(@NotNull Module module) {
        GemInfo bundlerGem;
        if (module == null) {
            BundlerUtil.$$$reportNull$$$0(31);
        }
        if ((bundlerGem = RubyProjectGemSearchService.Companion.findGem(module, BUNDLER)) == null) {
            LOG.debug("Can't find bundler gem in module " + module.getName() + " in project " + module.getProject().getName() + "! Bundler runtime emulation disabled.");
            return false;
        }
        if (!bundlerGem.isValid()) {
            LOG.debug("Bundler gem is not valid in the module " + module.getName() + " in project " + module.getProject().getName() + "! Bundler runtime emulation disabled.");
            return false;
        }
        if (!BundlerUtil.hasGemfile(module)) {
            LOG.debug("Can't find Gemfile in the module " + module.getName() + " in project " + module.getProject().getName() + "! Bundler runtime emulation disabled.");
            return false;
        }
        if (BundlerUtil.getGemfileLock(module) == null) {
            LOG.debug("Can't find Gemfile.lock in the module " + module.getName() + " in project " + module.getProject().getName() + "! Bundler runtime emulation disabled.");
            return false;
        }
        LOG.debug("All conditions for bundler usage are satisfied. Bundler runtime emulation enabled.");
        return true;
    }

    @Nullable
    private static VirtualFile getGemfileForInspectionTool() {
        String gemFilePath = RMInspectionToolLaunchSettings.getInstance().getGemFilePath();
        VirtualFile gemFile = LocalFileSystem.getInstance().findFileByPath(gemFilePath);
        LOG.debug("Gemfile file path is " + gemFilePath + " according RMInspectionToolLaunchSettings. Gemfile is " + String.valueOf(gemFile));
        return gemFile;
    }

    public static boolean isGemMentioned(@NotNull RFile environmentConfigFile, @NotNull Sdk sdk, @NotNull String gemName) {
        if (environmentConfigFile == null) {
            BundlerUtil.$$$reportNull$$$0(32);
        }
        if (sdk == null) {
            BundlerUtil.$$$reportNull$$$0(33);
        }
        if (gemName == null) {
            BundlerUtil.$$$reportNull$$$0(34);
        }
        GemDetector detector = GemRequirementsChangeWatcher.getDetector((PsiFile)environmentConfigFile);
        assert (detector != null);
        Set<GemDependency> deps = detector.detect(environmentConfigFile.getProject(), sdk, environmentConfigFile.getVirtualFile());
        for (GemDependency dep : deps) {
            if (!dep.getName().equals(gemName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<GemEnvironment> getGemEnvironments(Module module) {
        HashSet<GemEnvironment> environments = new HashSet<GemEnvironment>();
        RFile gemFile = BundlerUtil.getGemfilePsiFile(module);
        Collection calls = PsiTreeUtil.findChildrenOfType((PsiElement)gemFile, RCall.class);
        if (!calls.isEmpty()) {
            for (RCall call : calls) {
                PsiElement doBlock;
                RPsiElement envSymbol;
                String command = call.getCommand();
                if (!GROUPING.equals(command) || (envSymbol = (RPsiElement)call.getArguments().get(0)) == null) continue;
                String environment = envSymbol.getName();
                ArrayList<String> gems = new ArrayList<String>();
                if (environment != null && (doBlock = call.getParent()) instanceof RDoBlockCall) {
                    RPsiElement loopBody = ((RDoBlockCall)doBlock).getLoopBody();
                    Collection gemCalls = PsiTreeUtil.findChildrenOfType((PsiElement)loopBody, RCall.class);
                    for (RCall gemCall : gemCalls) {
                        List arguments;
                        RPsiElement gem;
                        String gemName;
                        if (!GemCallTypeProvider.GEM_CALL.equals((Object)gemCall.getCallType()) || (gemName = (gem = (RPsiElement)(arguments = gemCall.getArguments()).get(0)) instanceof RStringLiteral ? ((RStringLiteral)gem).getContent() : gem.getName()) == null) continue;
                        gems.add(gemName);
                    }
                }
                environments.add(new GemEnvironment(environment, gems));
            }
        }
        HashSet<GemEnvironment> hashSet = environments;
        if (hashSet == null) {
            BundlerUtil.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    public static boolean isBundlerDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && (BUNDLE_FOLDER.equals(dir.getName()) || BUNDLER_FOLDER.equals(dir.getName()));
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(@Nullable Sdk sdk, @Nullable Module module) {
        return BundlerUtil.getBundlerPreprocessor(sdk, module, "RubyProgramRunner", false);
    }

    private static boolean isWindowsContext(@Nullable Sdk sdk, @Nullable Module module) {
        RubySdkSystemAccessor sdkSystemAccessor = RubySdkSystemAccessor.from(RubySdkUtil.getEffectiveSdk(sdk, module));
        return sdkSystemAccessor != null ? sdkSystemAccessor.isWindows() : SystemInfo.isWindows;
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(@Nullable Sdk sdk, @Nullable Module module, @NotNull String runnerId, boolean useAlternativeSdk) {
        if (runnerId == null) {
            BundlerUtil.$$$reportNull$$$0(36);
        }
        return BundlerUtil.getBundlerPreprocessor(sdk, module, runnerId, null, useAlternativeSdk);
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(final @Nullable Sdk sdk, final @Nullable Module module, final @NotNull String runnerId, final @Nullable RunnerSettings runnerSettings, final boolean useAlternativeSdk) {
        if (runnerId == null) {
            BundlerUtil.$$$reportNull$$$0(37);
        }
        return new CmdlinePreprocessor(){

            @Override
            public void preprocess(@NotNull GeneralCommandLine cmdline) {
                String effectiveSdkInterpreterPath;
                Sdk effectiveSdk;
                if (cmdline == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    LOG.debug("Module is null");
                    return;
                }
                if (!BundlerUtil.isBundlerRuntimeEmulationEnabled(module)) {
                    LOG.debug("Bundler emulation is disabled for module: ", new Object[]{module});
                    return;
                }
                Sdk sdk2 = effectiveSdk = sdk != null ? sdk : RModuleUtil.getInstance().findRubySdkForModule(module);
                if (effectiveSdk == null) {
                    LOG.debug("Effective sdk is null for: ", new Object[]{module, "; command: ", cmdline});
                }
                String string = effectiveSdkInterpreterPath = effectiveSdk == null ? null : RubySdkAdditionalData.getInterpreterPathFor(effectiveSdk);
                if (effectiveSdkInterpreterPath == null) {
                    LOG.debug("Effective sdk path is null for ", new Object[]{sdk, "; module: ", module, "; command: ", cmdline});
                }
                if (Registry.is((String)"ruby.force.explicit.bundle.exec", (boolean)true) && effectiveSdkInterpreterPath != null) {
                    String originalExecutable = cmdline.getExePath();
                    String bundlerScriptPath = BundlerUtil.getBundlerScriptPath(sdk, module);
                    if (bundlerScriptPath == null) {
                        LOG.warn("Could not find bundler script for the " + String.valueOf(sdk) + "; " + String.valueOf(module));
                        return;
                    }
                    cmdline.setExePath(RubyVersionManagerHandler.notNullFrom(effectiveSdk).getAdjustedGemScriptPathForExecution(effectiveSdkInterpreterPath));
                    ParametersList parametersList = cmdline.getParametersList();
                    if (BundlerUtil.shouldAddBundleExec(cmdline)) {
                        parametersList.addAt(0, "-x");
                        parametersList.addAt(1, bundlerScriptPath);
                        parametersList.addAt(2, "exec");
                        parametersList.addAt(3, originalExecutable);
                    }
                } else {
                    ReadAction.run(() -> {
                        BundlerUtil.patchCommandLine(sdk, module, cmdline, runnerId, useAlternativeSdk);
                        if (RbenvGemsetManager.isRbenvSdk(sdk) && !RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
                            BundlerUtil.patchBundleExecCommandLine(sdk, module, cmdline, runnerSettings);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdline", "org/jetbrains/plugins/ruby/gem/util/BundlerUtil$1", "preprocess"));
            }
        };
    }

    @TestOnly
    public static void waitForPromises() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    @Nullable
    public static String getLockFilePath(@NotNull Module module) {
        VirtualFile lockFile;
        if (module == null) {
            BundlerUtil.$$$reportNull$$$0(38);
        }
        if ((lockFile = BundlerUtil.getGemfileLock(module)) != null) {
            return lockFile.getPath();
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile != null) {
            return new File(gemFile.getParent().getPath(), BundlerUtil.getLockFileName(gemFile)).getAbsolutePath();
        }
        return null;
    }

    private static boolean shouldAddBundleExec(@NotNull GeneralCommandLine cmdLine) {
        RubyCommandLine rubyCommandLine;
        if (cmdLine == null) {
            BundlerUtil.$$$reportNull$$$0(39);
        }
        return cmdLine instanceof RubyCommandLine && (rubyCommandLine = (RubyCommandLine)cmdLine).isAddBundleExec();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 15, 22, 23, 24, 25, 26, 27, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUPING;
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: 
            case 18: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 19: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRootUrl";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentConfigFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLockFileName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemSdkVersion";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroupsFromConfig";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetGroups";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemEnvironments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addGemToGemfile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openGemFileInEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBinIfExists";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGemfile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGemfileLockWithRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLockFileName";
                break;
            }
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGemfile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addBundlerPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGemSdkVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "patchBundleExecCommandLine";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addBundlerEnvironment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addRVMBundleUrl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFakeRVMBundlerGemRootUrl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findGemFolderForSdk";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isBundlerRuntimeEmulationEnabled";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isGemMentioned";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBundlerPreprocessor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLockFilePath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddBundleExec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 15, 22, 23, 24, 25, 26, 27, 35 -> new IllegalStateException(string);
        };
    }
}

