/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.SimpleTree;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;

class ShowGemPathAction
extends AnAction
implements DumbAware {
    @NotNull
    private final SimpleTree myTree;

    private ShowGemPathAction(@NotNull SimpleTree tree) {
        if (tree == null) {
            ShowGemPathAction.$$$reportNull$$$0(0);
        }
        super(() -> RBundle.message((String)"ruby.ide.sdk.configurable.show.gem.path.title"), AllIcons.Actions.MenuOpen);
        this.myTree = tree;
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ctrl P"}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            ShowGemPathAction.$$$reportNull$$$0(1);
        }
        if ((file = this.getGemFileFolder()) == null) {
            return;
        }
        String path = file.getCanonicalPath();
        if (path == null) {
            return;
        }
        if (file.isDirectory()) {
            RevealFileAction.openDirectory((File)new File(path));
        } else {
            RevealFileAction.openFile((File)new File(path));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowGemPathAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowGemPathAction.$$$reportNull$$$0(3);
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(this.getGemFileFolder() != null);
    }

    @Nullable
    private VirtualFile getGemFileFolder() {
        GemInfo gemInfo = RubySdkGemsConfigurableBase.getSelectedNodeGemInfo(this.myTree);
        if (gemInfo == null) {
            return null;
        }
        return gemInfo.getFile();
    }

    static AnAction actionButton(@NotNull SimpleTree tree) {
        if (tree == null) {
            ShowGemPathAction.$$$reportNull$$$0(4);
        }
        return new ShowGemPathAction(tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/ShowGemPathAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/ShowGemPathAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

