/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class SdkComparator
implements Comparator<Sdk> {
    public static final SdkComparator SDK_COMPARATOR = new SdkComparator();

    private SdkComparator() {
    }

    @Override
    public int compare(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        return SdkComparator.compareSdks(sdk1, sdk2);
    }

    public static int compareSdks(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        if (sdk1 == null && sdk2 == null) {
            return 0;
        }
        if (sdk1 == null) {
            return -1;
        }
        if (sdk2 == null) {
            return 1;
        }
        int namesComparison = -VersionComparatorUtil.compare((String)sdk1.getName(), (String)sdk2.getName());
        if (!RubySdkUtil.isRubySDK(sdk1) && !RubySdkUtil.isRubySDK(sdk2)) {
            return namesComparison;
        }
        if (!RubySdkUtil.isRubySDK(sdk1)) {
            return -1;
        }
        if (!RubySdkUtil.isRubySDK(sdk2)) {
            return 1;
        }
        boolean isRemoteSdk1 = RubyRemoteInterpreterManager.isRemoteSdk(sdk1);
        boolean isRemoteSdk2 = RubyRemoteInterpreterManager.isRemoteSdk(sdk2);
        if (isRemoteSdk1 && isRemoteSdk2) {
            return namesComparison;
        }
        if (isRemoteSdk1) {
            return -1;
        }
        if (isRemoteSdk2) {
            return 1;
        }
        Predicate<Sdk> isJRuby = JRubySdkUtil::isJRubySDK;
        Function<Sdk, String> getRbenvGemset = RbenvGemsetManager::getRbenvGemset;
        Function<Sdk, String> getRVMGemset = RVMSupportUtil::getGemsetName;
        Predicate<Sdk> isLocalRbenv = RbenvGemsetManager::isLocalRbenvSdk;
        Predicate<Sdk> isRVM = RVMSupportUtil::isRVMInterpreter;
        Integer comparing = SdkComparator.compareVersionManagerSdks(sdk1, sdk2, getRbenvGemset, isLocalRbenv, isJRuby, namesComparison);
        if (comparing != null) {
            return comparing;
        }
        comparing = SdkComparator.compareVersionManagerSdks(sdk1, sdk2, getRVMGemset, isRVM, isJRuby, namesComparison);
        if (comparing != null) {
            return comparing;
        }
        return namesComparison;
    }

    @Nullable
    private static Integer compareVersionManagerSdks(@NotNull Sdk sdk1, @NotNull Sdk sdk2, @NotNull Function<? super Sdk, String> getGemset, @NotNull Predicate<? super Sdk> isVersioned, @NotNull Predicate<? super Sdk> isJRuby, int namesComparison) {
        if (sdk1 == null) {
            SdkComparator.$$$reportNull$$$0(0);
        }
        if (sdk2 == null) {
            SdkComparator.$$$reportNull$$$0(1);
        }
        if (getGemset == null) {
            SdkComparator.$$$reportNull$$$0(2);
        }
        if (isVersioned == null) {
            SdkComparator.$$$reportNull$$$0(3);
        }
        if (isJRuby == null) {
            SdkComparator.$$$reportNull$$$0(4);
        }
        boolean isVersionedSdk1 = isVersioned.test((Sdk)sdk1);
        boolean isVersionedSdk2 = isVersioned.test((Sdk)sdk2);
        if (isVersionedSdk1 && isVersionedSdk2) {
            boolean jRubySDK1 = isJRuby.test((Sdk)sdk1);
            boolean jRubySDK2 = isJRuby.test((Sdk)sdk2);
            if (jRubySDK1 && jRubySDK2) {
                return SdkComparator.compareGemsets(sdk1, sdk2, getGemset, namesComparison);
            }
            if (jRubySDK1) {
                return 1;
            }
            if (jRubySDK2) {
                return -1;
            }
            return SdkComparator.compareGemsets(sdk1, sdk2, getGemset, namesComparison);
        }
        if (isVersionedSdk1) {
            return 1;
        }
        if (isVersionedSdk2) {
            return -1;
        }
        return null;
    }

    private static Integer compareGemsets(@NotNull Sdk sdk1, @NotNull Sdk sdk2, @NotNull Function<? super Sdk, String> getGemset, int namesComparison) {
        if (sdk1 == null) {
            SdkComparator.$$$reportNull$$$0(5);
        }
        if (sdk2 == null) {
            SdkComparator.$$$reportNull$$$0(6);
        }
        if (getGemset == null) {
            SdkComparator.$$$reportNull$$$0(7);
        }
        String gemset1 = getGemset.apply((Sdk)sdk1);
        String gemset2 = getGemset.apply((Sdk)sdk2);
        if (StringUtil.equals((CharSequence)sdk1.getHomePath(), (CharSequence)sdk2.getHomePath())) {
            if (gemset1 != null && gemset2 != null) {
                return StringUtil.compare((String)gemset1, (String)gemset2, (boolean)true);
            }
            if (gemset1 != null) {
                return 1;
            }
            if (gemset2 != null) {
                return -1;
            }
            return null;
        }
        return namesComparison;
    }

    public static List<Sdk> sortSdks(@NotNull Collection<? extends Sdk> sdks) {
        if (sdks == null) {
            SdkComparator.$$$reportNull$$$0(8);
        }
        return sdks.stream().sorted(SDK_COMPARATOR).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk1";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk2";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getGemset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isVersioned";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isJRuby";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/SdkComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersionManagerSdks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "compareGemsets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "sortSdks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

