/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RubySdkGemsetsSettings", storages={@Storage(value="gemmanager.xml", roamingType=RoamingType.DISABLED)})
public class RubySdkGemsetsSettings
implements PersistentStateComponent<State> {
    private MultiMap<String, String> myDefaultProjectSdkGemsetsSettings = new MultiMap();
    private final Map<String, MultiMap<String, String>> myModuleSdkGemsetsSettings = new HashMap<String, MultiMap<String, String>>();
    private boolean myShowSdkPathFlag = false;

    public static RubySdkGemsetsSettings getInstance() {
        return (RubySdkGemsetsSettings)ApplicationManager.getApplication().getService(RubySdkGemsetsSettings.class);
    }

    @NotNull
    public MultiMap<String, String> getOrCreateModuleSdkGemsetsMap(@NotNull Module module) {
        MultiMap map;
        if (module == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(0);
        }
        MultiMap multiMap = (map = this.myModuleSdkGemsetsSettings.get(module.getName())) == null ? new MultiMap() : map;
        if (multiMap == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    public void putModuleSdkGemsetsMap(@NotNull Module module, @NotNull MultiMap<String, String> value) {
        if (module == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(2);
        }
        if (value == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(3);
        }
        this.myModuleSdkGemsetsSettings.put(module.getName(), value);
    }

    @NotNull
    public MultiMap<String, String> getOrCreateDefaultProjectSdkGemsetsMap() {
        MultiMap<String, String> multiMap = this.myDefaultProjectSdkGemsetsSettings;
        if (multiMap == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    public void setDefaultProjectSdkGemsetsMap(@NotNull MultiMap<String, String> map) {
        if (map == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(5);
        }
        this.myDefaultProjectSdkGemsetsSettings = map;
    }

    public boolean getShowSdkPathFlag() {
        return this.myShowSdkPathFlag;
    }

    public void setShowSdkPathFlag(boolean showSdkPathFlag) {
        this.myShowSdkPathFlag = showSdkPathFlag;
    }

    @Nullable
    public State getState() {
        HashMap<String, List<String>> sdkToGemsetsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> moduleToSdksMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, MultiMap<String, String>> entry : this.myModuleSdkGemsetsSettings.entrySet()) {
            MultiMap<String, String> sdkToGemsets = entry.getValue();
            moduleToSdksMap.put(entry.getKey(), Arrays.asList(ArrayUtilRt.toStringArray((Collection)sdkToGemsets.keySet())));
            this.getSdkToGemsetsState(sdkToGemsetsMap, sdkToGemsets);
        }
        HashMap<String, List<String>> defaultProjectSdkToGemsetsMap = new HashMap<String, List<String>>();
        this.getSdkToGemsetsState(defaultProjectSdkToGemsetsMap, this.myDefaultProjectSdkGemsetsSettings);
        return new State(moduleToSdksMap, sdkToGemsetsMap, defaultProjectSdkToGemsetsMap, this.myShowSdkPathFlag);
    }

    protected void getSdkToGemsetsState(HashMap<String, List<String>> sdkToGemsetsMap, MultiMap<String, String> sdkToGemsets) {
        for (Map.Entry sdkGemsetsEntries : sdkToGemsets.entrySet()) {
            sdkToGemsetsMap.put((String)sdkGemsetsEntries.getKey(), Arrays.asList(ArrayUtilRt.toStringArray((Collection)((Collection)sdkGemsetsEntries.getValue()))));
        }
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(6);
        }
        this.myModuleSdkGemsetsSettings.clear();
        for (Map.Entry<String, List<String>> entry : state.myModuleToSdkMap.entrySet()) {
            this.myModuleSdkGemsetsSettings.put(entry.getKey(), this.getSdkToGemsetsMap((Collection<String>)entry.getValue(), state.mySdkToGemsetsMap));
        }
        this.myDefaultProjectSdkGemsetsSettings = this.getSdkToGemsetsMap(state.myDefaultSdkToGemsetsMap.keySet(), state.myDefaultSdkToGemsetsMap);
        this.myShowSdkPathFlag = state.myShowSdkPathFlag;
    }

    @NotNull
    protected MultiMap<String, String> getSdkToGemsetsMap(Collection<String> sdks, HashMap<String, List<String>> sdkToGemsets) {
        MultiMap sdkToGemsetsMap = new MultiMap();
        for (String sdk : sdks) {
            sdkToGemsetsMap.put((Object)sdk, (Collection)sdkToGemsets.get(sdk));
        }
        MultiMap multiMap = sdkToGemsetsMap;
        if (multiMap == null) {
            RubySdkGemsetsSettings.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsetsSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsetsSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleSdkGemsetsMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefaultProjectSdkGemsetsMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkToGemsetsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleSdkGemsetsMap";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putModuleSdkGemsetsMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProjectSdkGemsetsMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7 -> new IllegalStateException(string);
        };
    }

    public static class State {
        @Tag(value="moduleSdks")
        public HashMap<String, List<String>> myModuleToSdkMap;
        @Tag(value="sdkGemsets")
        public HashMap<String, List<String>> mySdkToGemsetsMap;
        @Tag(value="defaultProjectSdkGemsets")
        public HashMap<String, List<String>> myDefaultSdkToGemsetsMap;
        @Tag(value="showSdkPath")
        public boolean myShowSdkPathFlag;

        public State() {
            this(new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), false);
        }

        public State(@NotNull HashMap<String, List<String>> moduleToSdkMap, @NotNull HashMap<String, List<String>> sdkToGemsetsMap, @NotNull HashMap<String, List<String>> defaultSdkToGemsetsMap, boolean showSdkPathFlag) {
            if (moduleToSdkMap == null) {
                State.$$$reportNull$$$0(0);
            }
            if (sdkToGemsetsMap == null) {
                State.$$$reportNull$$$0(1);
            }
            if (defaultSdkToGemsetsMap == null) {
                State.$$$reportNull$$$0(2);
            }
            this.myModuleToSdkMap = moduleToSdkMap;
            this.mySdkToGemsetsMap = sdkToGemsetsMap;
            this.myDefaultSdkToGemsetsMap = defaultSdkToGemsetsMap;
            this.myShowSdkPathFlag = showSdkPathFlag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleToSdkMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdkToGemsetsMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultSdkToGemsetsMap";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsetsSettings$State";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

