/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.ui.BaseSdkCommand;
import org.jetbrains.plugins.ruby.gem.ui.EditSdkDialog;
import org.jetbrains.plugins.ruby.gem.ui.GemsTreeSpeedSearch;
import org.jetbrains.plugins.ruby.gem.ui.RadioButtonNode;
import org.jetbrains.plugins.ruby.gem.ui.RadioButtonTreeHelper;
import org.jetbrains.plugins.ruby.gem.ui.ReloadGemsAction;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.gem.ui.ShowDescriptionAction;
import org.jetbrains.plugins.ruby.gem.ui.ShowGemPathAction;
import org.jetbrains.plugins.ruby.gem.ui.commands.ChangeLanguageLevelCommand;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransferListener;
import org.jetbrains.plugins.ruby.remote.RubySdkCustomActionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurableUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkPatcher;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.GemsetSupporter;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;

public abstract class RubySdkGemsConfigurableBase
implements Configurable,
Disposable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(RubySdkGemsConfigurableBase.class);
    private static final int MAX_SOURCES_STRING_LENGTH = 30;
    private static final String SDK_SOURCE_TEXT = "default";
    private static final String RBENV_DEFAULT_GEMSET = "default";
    private static final String RVM_DEFAULT_GEMSET = "default";
    private static final String RVM_GLOBAL_GEMSET = "global";
    private static final PairFunction<Sdk, Sdk, Boolean> RUBY_SDKS_EQUAL = (sdk1, sdk2) -> RubySdkGemsConfigurableBase.equalSdks(sdk1, sdk2);
    private static final PairFunction<Sdk, Sdk, Boolean> NEW_RVM_GEMSET_SDKS_EQUAL = (sdk1, sdk2) -> RVMSupportUtil.isNewRVMGemsetSdk(sdk1) || RVMSupportUtil.isNewRVMGemsetSdk(sdk2) ? StringUtil.equals((CharSequence)sdk1.getHomePath(), (CharSequence)sdk2.getHomePath()) && StringUtil.equals((CharSequence)RVMSupportUtil.getGemsetName(sdk1), (CharSequence)RVMSupportUtil.getGemsetName(sdk2)) : RubySdkGemsConfigurableBase.equalSdks(sdk1, sdk2);
    private static final Convertor<TreePath, String> TO_STRING_CONVERTOR = object -> {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
        return node.toString();
    };
    private CheckboxTreeBase mySdkTree;
    private final JPanel myRootPanel = new JPanel(new BorderLayout());
    private final Stack<BaseSdkCommand> myCommandStack = new Stack();
    private StructureTreeModel<SimpleTreeStructure.Impl> myTreeModel;
    private LoadingDecorator myLoadingDecorator;
    private HyperlinkLabel myMessagePane;
    private final EventDispatcher<RadiobuttonTreeListener> myRadioEventDispatcher = EventDispatcher.create(RadiobuttonTreeListener.class);
    protected MultiMap<String, String> mySdkGemsetsMap;
    private JPanel mySdkListPanel;
    private CommonActionsPanel myActionsPanel;
    private MyRootNode myRoot;
    private RadioButtonTreeHelper mySdkRadioButtonTreeHelper;
    private TreeNode mySelectedGemsetNode;
    private SdkNode mySelectedSdkNode;
    private SdkNode myCurrentCheckedSdkNode;
    private Future myPendingRefresh;
    private TreeSpeedSearch mySdkTreeSearch;
    protected Collection<NewRVMGemsetNode> myNewRVMGemsetNodes = ContainerUtil.createConcurrentList();
    @NotNull
    private MessageBusConnection myConnect;
    @Nullable
    private Sdk mySdkToIgnore;
    protected boolean myIsDisposed;

    protected void init() {
        this.initSdkTree();
        this.initGemsTree();
        this.createCentralPanel();
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.mySdkTree, true);
        Disposer.register((Disposable)RubyPluginUtil.getUnloadAwareDisposable(this.getProject()), (Disposable)this);
        this.myConnect = this.getProject().getMessageBus().connect((Disposable)this);
        this.addNewRVMGemsetListener();
        this.addSdkListener();
        this.addWorkspaceModelListener();
    }

    @Nullable
    private static String getGemsetName(@NotNull Sdk sdk) {
        RubySdkAdditionalData sdkAdditionalData;
        RubyVersionManagerSdkData versionManagerSdkData;
        SdkAdditionalData sdkAdditionalData2;
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(0);
        }
        if ((sdkAdditionalData2 = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData && (versionManagerSdkData = (sdkAdditionalData = (RubySdkAdditionalData)sdkAdditionalData2).getVersionManagerSdkAdditionalData()) instanceof GemsetSupporter) {
            return ((GemsetSupporter)((Object)versionManagerSdkData)).getGemsetName();
        }
        return null;
    }

    protected void addSdkListener() {
        this.myConnect.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkAdded(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubySdkGemsConfigurableBase.this.removeNewRVMGemsetNode(jdk);
                RubySdkGemsConfigurableBase.this.refreshPreserveState(NEW_RVM_GEMSET_SDKS_EQUAL);
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    RubySdkGemsConfigurableBase.this.mySdkToIgnore = jdk;
                    RubySdkGemsConfigurableBase.this.refreshPreserveState();
                }
                finally {
                    RubySdkGemsConfigurableBase.this.mySdkToIgnore = null;
                }
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (previousName == null) {
                    1.$$$reportNull$$$0(3);
                }
                RubySdkGemsConfigurableBase.this.refreshPreserveState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jdk";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousName";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkNameChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myConnect.subscribe(RubyRemoteInterpreterManager.RUBY_REMOTE_SDK_TRANSFER_LISTENER_TOPIC, (Object)new RubyRemoteSdkTransferListener(){

            @Override
            public void downloadStarted(@NotNull Sdk sdk) {
                if (sdk == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (RubySdkGemsConfigurableBase.this.mySelectedSdkNode != null && RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk.equals(sdk)) {
                    RubySdkGemsConfigurableBase.this.myLoadingDecorator.startLoading(false);
                }
            }

            @Override
            public void downloadComplete(@NotNull Sdk sdk) {
                if (sdk == null) {
                    2.$$$reportNull$$$0(1);
                }
                RubySdkGemsConfigurableBase.this.refreshGemsAndRebuildGemsTree(sdk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sdk";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "downloadStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "downloadComplete";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void addWorkspaceModelListener() {
        this.myConnect.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!event.getChanges(LibraryEntity.class).isEmpty()) {
                    RubySdkGemsConfigurableBase.this.updateGems();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$3", "changed"));
            }
        });
    }

    protected void removeNewRVMGemsetNode(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(1);
        }
        NewRVMGemsetNode newRVMGemsetNode = (NewRVMGemsetNode)ContainerUtil.find(this.myNewRVMGemsetNodes, oldSdk -> (Boolean)NEW_RVM_GEMSET_SDKS_EQUAL.fun((Object)sdk, (Object)oldSdk.getSdk()));
        RVMSupportUtil.unmarkNewRVMGemsetSdk(sdk);
        if (newRVMGemsetNode != null) {
            this.myNewRVMGemsetNodes.remove(newRVMGemsetNode);
        }
    }

    protected void refreshPreserveState() {
        this.refreshPreserveState(RUBY_SDKS_EQUAL);
    }

    private void refreshPreserveState(@NotNull PairFunction<Sdk, Sdk, Boolean> compareSdks) {
        if (compareSdks == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(2);
        }
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)this.mySdkTree);
        ArrayList selectedNodes = new ArrayList(TreeUtil.collectSelectedObjectsOfType((JTree)this.mySdkTree, Sdk.class));
        this.reloadTree();
        TreeUtil.restoreExpandedPaths((JTree)this.mySdkTree, (List)expandedPaths);
        TreeUtil.traverse((TreeNode)((Object)this.myRoot), node -> {
            if (node instanceof DefaultMutableTreeNode) {
                if (this.mySelectedGemsetNode == null && node instanceof GemsetNode) {
                    return true;
                }
                Object newSdk = ((DefaultMutableTreeNode)node).getUserObject();
                if (!(newSdk instanceof Sdk)) {
                    return true;
                }
                if (ContainerUtil.find((Iterable)selectedNodes, oldSdk -> (Boolean)compareSdks.fun((Object)((Sdk)newSdk), oldSdk)) != null) {
                    TreeUtil.selectInTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)node), (boolean)true, (JTree)this.mySdkTree, (boolean)true);
                    return false;
                }
            }
            return true;
        });
    }

    private void addNewRVMGemsetListener() {
        this.myConnect.subscribe(RVMSupportUtil.RVM_GEMSET_ADDED_TOPIC, (Object)new RVMSupportUtil.RVMGemsetListener(){

            @Override
            public void onNewRVMGemsetAdded(@NotNull Sdk newRVMGemsetSdk) {
                String gemset;
                if (newRVMGemsetSdk == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((gemset = RVMSupportUtil.getGemsetName(newRVMGemsetSdk)) == null) {
                    LOG.error("RVM gemset of sdk " + newRVMGemsetSdk.getName() + " must not be null.");
                    return;
                }
                RubySdkGemsConfigurableBase.this.myNewRVMGemsetNodes.add(new NewRVMGemsetNode(newRVMGemsetSdk, gemset, false));
                RubySdkGemsConfigurableBase.this.refreshPreserveState();
                RubySdkGemsConfigurableBase.this.selectRVMGemsetInTree(newRVMGemsetSdk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRVMGemsetSdk", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$4", "onNewRVMGemsetAdded"));
            }
        });
    }

    @NotNull
    protected abstract Project getProject();

    private void createCentralPanel() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f);
        splitter.setSplitterProportionKey("ruby.sdk.configurable.top.splitter");
        splitter.setFirstComponent((JComponent)this.mySdkListPanel);
        splitter.setSecondComponent(this.myLoadingDecorator.getComponent());
        this.myRootPanel.add((Component)splitter, "Center");
    }

    private void initGemsTree() {
        SimpleTree gemsTree = new SimpleTree(){

            protected void configureUiHelper(TreeUIHelper helper) {
            }
        };
        gemsTree.setRootVisible(false);
        SimpleTreeStructure.Impl treeStructure = new SimpleTreeStructure.Impl((SimpleNode)new RootNode());
        this.myTreeModel = new StructureTreeModel((AbstractTreeStructure)treeStructure, null, Invoker.forBackgroundThreadWithoutReadAction((Disposable)this), (Disposable)this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myTreeModel, (Disposable)this);
        gemsTree.setModel((TreeModel)asyncTreeModel);
        gemsTree.setCellRenderer((TreeCellRenderer)((Object)new RubyGemsTreeCellRenderer(GemsTreeSpeedSearch.installOn((JTree)gemsTree))));
        gemsTree.getSelectionModel().setSelectionMode(1);
        JPanel gemsTreePanel = ToolbarDecorator.createDecorator((JTree)gemsTree).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder(IdeBorderFactory.createBorder((int)14)).addExtraAction(ShowGemPathAction.actionButton(gemsTree)).addExtraAction(ShowDescriptionAction.actionButton(gemsTree, WebBrowserManager.getInstance().getFirstActiveBrowser())).addExtraAction(ReloadGemsAction.actionButton(this.mySdkTree)).createPanel();
        this.myLoadingDecorator = new LoadingDecorator((JComponent)gemsTreePanel, (Disposable)this, 50);
        this.myLoadingDecorator.setLoadingText(RBundle.message((String)"ruby.ide.sdk.init.gem.tree.updating.text"));
    }

    private JPopupMenu createSdkCellContextPopupMenu(@NotNull Sdk selectedSdk) {
        if (selectedSdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(3);
        }
        JBPopupMenu menu = new JBPopupMenu();
        JBMenuItem editMenuItem = new JBMenuItem(RBundle.message((String)"ruby.ide.sdk.edit.menu.label"));
        menu.add((JMenuItem)editMenuItem);
        editMenuItem.addActionListener(e -> this.editSdk(selectedSdk));
        if (RVMSupportUtil.isRVMInterpreter(selectedSdk)) {
            JBMenuItem menuItem = new JBMenuItem(RBundle.message((String)"ruby.ide.sdk.configurable.new.rvm.gemset"));
            menu.add((JMenuItem)menuItem);
            menuItem.addActionListener(e -> RubySdkConfigurableUtil.onCreateNewRvmGemsetItemClicked(RubySdkGemsConfigurableBase.getAllRubySdkTypes(), this.getAllRubySdks().toArray(new Sdk[0]), this.getProject(), selectedSdk, (NullableConsumer<? super Sdk>)((NullableConsumer)this::onSdkCreatedCallback)));
        }
        return menu;
    }

    private void initSdkTree() {
        this.mySdkGemsetsMap = this.getSettingsMap();
        this.myRoot = new MyRootNode();
        RubySdkTreeCellRendererBase cellRenderer = new RubySdkTreeCellRendererBase();
        this.mySdkRadioButtonTreeHelper = new RadioButtonTreeHelper(this.myRadioEventDispatcher);
        this.mySdkTree = new CheckboxTreeBase(cellRenderer, this.myRoot){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                TreeNode sdkNode = node.getParent();
                if (!(sdkNode instanceof SdkNode)) {
                    return;
                }
                if (!((SdkNode)sdkNode).isChecked()) {
                    RubySdkGemsConfigurableBase.this.mySdkRadioButtonTreeHelper.setNodeState((Tree)RubySdkGemsConfigurableBase.this.mySdkTree, (SdkNode)sdkNode, true);
                }
                if (node instanceof RbenvGemsetNode) {
                    RubySdkGemsConfigurableBase.saveGemsetsState(node.isChecked(), ((RbenvGemsetNode)node).myGemset, RubySdkGemsConfigurableBase.this.mySdkGemsetsMap, ((SdkNode)sdkNode).mySdk);
                } else if (node instanceof RVMGlobalGemsetNode) {
                    RubySdkGemsConfigurableBase.saveGemsetsState(node.isChecked(), RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET, RubySdkGemsConfigurableBase.this.mySdkGemsetsMap, ((SdkNode)sdkNode).mySdk);
                }
            }
        };
        this.mySdkTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath location;
                Sdk selectedSdk;
                if (SwingUtilities.isRightMouseButton(e) && (selectedSdk = RubySdkGemsConfigurableBase.getSdkByPath(location = RubySdkGemsConfigurableBase.this.mySdkTree.getClosestPathForLocation(e.getX(), e.getY()))) != null) {
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)RubySdkGemsConfigurableBase.this.createSdkCellContextPopupMenu(selectedSdk));
                }
            }
        });
        this.mySdkTreeSearch = TreeSpeedSearch.installOn((JTree)this.mySdkTree, (boolean)true, TO_STRING_CONVERTOR);
        this.myRadioEventDispatcher.addListener((EventListener)new RadiobuttonTreeListener(){

            @Override
            public void mouseDoubleClicked(@NotNull TreeNode node) {
                if (node == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (node instanceof RadioButtonNode) {
                    TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                    if (RubySdkGemsConfigurableBase.this.mySdkTree.isExpanded(path)) {
                        RubySdkGemsConfigurableBase.this.mySdkTree.collapsePath(path);
                    } else {
                        RubySdkGemsConfigurableBase.this.mySdkTree.expandPath(path);
                    }
                }
            }

            @Override
            public void nodeStateChanged(@NotNull TreeNode node) {
                if (node == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (node instanceof SdkNode) {
                    RubySdkGemsConfigurableBase.saveCheckedSdk(RubySdkGemsConfigurableBase.this.mySdkGemsetsMap, ((SdkNode)node).isChecked(), ((SdkNode)node).mySdk);
                    RubySdkGemsConfigurableBase.this.checkErrors();
                    if (!((SdkNode)node).isChecked()) {
                        return;
                    }
                    RubySdkGemsConfigurableBase.this.myCurrentCheckedSdkNode = (SdkNode)node;
                    Enumeration children = RubySdkGemsConfigurableBase.this.myRoot.children();
                    while (children.hasMoreElements()) {
                        TreeNode child = (TreeNode)children.nextElement();
                        if (!(child instanceof SdkNode)) {
                            return;
                        }
                        SdkNode otherSdkNode = (SdkNode)child;
                        if (child == node || !otherSdkNode.isChecked()) continue;
                        RubySdkGemsConfigurableBase.this.mySdkRadioButtonTreeHelper.setNodeState((Tree)RubySdkGemsConfigurableBase.this.mySdkTree, otherSdkNode, false);
                    }
                    return;
                }
                if (node instanceof RVMGemsetNode) {
                    TreeNode sdkNode = node.getParent();
                    if (!(sdkNode instanceof SdkNode)) {
                        return;
                    }
                    RubySdkGemsConfigurableBase.saveGemsetsState(((RVMGemsetNode)node).isChecked(), ((RVMGemsetNode)node).myGemset, RubySdkGemsConfigurableBase.this.mySdkGemsetsMap, ((SdkNode)sdkNode).mySdk);
                    if (!((SdkNode)sdkNode).isChecked()) {
                        RubySdkGemsConfigurableBase.this.mySdkRadioButtonTreeHelper.setNodeState((Tree)RubySdkGemsConfigurableBase.this.mySdkTree, (SdkNode)sdkNode, true);
                    }
                    if (!((RVMGemsetNode)node).isChecked()) {
                        return;
                    }
                    Enumeration<? extends TreeNode> children = sdkNode.children();
                    while (children.hasMoreElements()) {
                        TreeNode child = children.nextElement();
                        if (!(child instanceof RVMGemsetNode)) continue;
                        RVMGemsetNode otherRVMGemsetNode = (RVMGemsetNode)child;
                        if (child == node || !otherRVMGemsetNode.isChecked()) continue;
                        RubySdkGemsConfigurableBase.this.mySdkRadioButtonTreeHelper.setNodeState((Tree)RubySdkGemsConfigurableBase.this.mySdkTree, otherRVMGemsetNode, !otherRVMGemsetNode.isChecked());
                    }
                }
            }

            @Override
            public void beforeNodeStateChanged(@NotNull TreeNode node) {
                if (node == null) {
                    8.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseDoubleClicked";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "nodeStateChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeNodeStateChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.mySdkRadioButtonTreeHelper.initTree((Tree)this.mySdkTree, (JComponent)this.mySdkTree, cellRenderer);
        this.mySdkTree.getSelectionModel().setSelectionMode(1);
        this.mySdkTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.isAddedPath()) {
                    RubySdkGemsConfigurableBase.this.mySelectedSdkNode = 9.getSdkByPathNode(e.getPath());
                    RubySdkGemsConfigurableBase.this.mySelectedGemsetNode = 9.getSelectedGemsetNode(e.getPath());
                    RubySdkGemsConfigurableBase.this.updateGems();
                }
            }

            @Nullable
            private static DefaultMutableTreeNode getSelectedGemsetNode(@NotNull TreePath path) {
                DefaultMutableTreeNode selectedNode;
                if (path == null) {
                    9.$$$reportNull$$$0(0);
                }
                return !((selectedNode = RubySdkGemsConfigurableBase.extractNode(path)) instanceof SdkNode) ? selectedNode : null;
            }

            @Nullable
            private static SdkNode getSdkByPathNode(@NotNull TreePath path) {
                DefaultMutableTreeNode selectedNode;
                if (path == null) {
                    9.$$$reportNull$$$0(1);
                }
                if ((selectedNode = RubySdkGemsConfigurableBase.extractNode(path)) == null) {
                    return null;
                }
                if (selectedNode instanceof SdkNode) {
                    return (SdkNode)selectedNode;
                }
                if (selectedNode.getParent() instanceof SdkNode) {
                    return (SdkNode)selectedNode.getParent();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "path";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSelectedGemsetNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSdkByPathNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ToolbarDecorator sdksToolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.mySdkTree).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder(IdeBorderFactory.createBorder((int)11)).disableUpDownActions().setAddAction((AnActionButtonRunnable)new AddSdkActionButtonRunnable()).setRemoveAction((AnActionButtonRunnable)new RemoveSdkActionButtonRunnable()).setRemoveActionUpdater((AnActionButtonUpdater)new RemoveSdkActionButtonUpdater()).setEditAction((AnActionButtonRunnable)new MyEditSdkActionButtonRunnable()).setEditActionUpdater((AnActionButtonUpdater)new MyEditSdkActionButtonUpdater()).addExtraAction((AnAction)new MyExpandAllAction((JTree)this.mySdkTree)).addExtraAction((AnAction)new MyCollapseAllAction((JTree)this.mySdkTree)).addExtraAction((AnAction)new ChooseLanguageLevelAction()).addExtraAction((AnAction)new MyShowSdkPathAction());
        this.addSdkCustomAction(sdksToolbarDecorator, this.mySdkTree);
        this.mySdkListPanel = sdksToolbarDecorator.createPanel();
        this.myActionsPanel = sdksToolbarDecorator.getActionsPanel();
        SwingUtilities.invokeLater(() -> {
            if (this.mySelectedSdkNode == null) {
                TreeUtil.promiseSelectFirst((JTree)this.mySdkTree);
            }
            this.updateGems();
        });
    }

    private void updateGems() {
        TreeNode node;
        TreeNode treeNode = node = this.mySelectedGemsetNode == null ? this.mySelectedSdkNode : this.mySelectedGemsetNode;
        if (node instanceof SdkNode) {
            this.updateGems(((SdkNode)node).mySdk);
        } else if (node instanceof RbenvGemsetNode) {
            TreeNode sdkNode = node.getParent();
            if (!(sdkNode instanceof SdkNode)) {
                return;
            }
            if (RubySdkGemsConfigurableBase.isDefaultRbenvGemset(node)) {
                this.updateGems(((SdkNode)sdkNode).mySdk);
            } else {
                Sdk gemsetSdk = RbenvGemsetManager.getGemsetSdk(((SdkNode)sdkNode).mySdk, ((RbenvGemsetNode)((Object)node)).myGemset);
                if (gemsetSdk != null) {
                    this.updateGems(gemsetSdk);
                }
            }
        } else if (node instanceof GemsetNode) {
            Sdk sdk = ((GemsetNode)((Object)node)).getSdk();
            this.updateGems(sdk);
        }
    }

    private void processSdkNodes(@NotNull Consumer<SdkNode> sdkNodeProcessor) {
        if (sdkNodeProcessor == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(4);
        }
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            Object e = children.nextElement();
            if (!(e instanceof SdkNode)) continue;
            SdkNode sdkNode = (SdkNode)e;
            sdkNodeProcessor.consume((Object)sdkNode);
        }
    }

    @Nullable
    private SdkNode findSdkToSelect(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            Object e = children.nextElement();
            if (!(e instanceof SdkNode)) continue;
            SdkNode sdkNode = (SdkNode)e;
            if (!RubySdkGemsConfigurableBase.equalSdks(sdkNode.mySdk, sdk) && !RubySdkGemsConfigurableBase.equalSdks(sdkNode.mySdk, this.findRootRVMSdk(sdk))) continue;
            return sdkNode;
        }
        return null;
    }

    @Nullable
    private static RVMGlobalGemsetNode findRVMSdkGlobalGemset(@NotNull SdkNode sdkNode) {
        if (sdkNode == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(5);
        }
        Enumeration<TreeNode> children = sdkNode.children();
        while (children.hasMoreElements()) {
            TreeNode treeNode = children.nextElement();
            if (!(treeNode instanceof RVMGlobalGemsetNode)) continue;
            RVMGlobalGemsetNode gemsetNode = (RVMGlobalGemsetNode)((Object)treeNode);
            return gemsetNode;
        }
        return null;
    }

    @Nullable
    private static RVMGemsetNode getCheckedRVMGemsetNode(@NotNull TreeNode sdkNode) {
        if (sdkNode == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(6);
        }
        Enumeration<? extends TreeNode> children = sdkNode.children();
        while (children.hasMoreElements()) {
            RVMGemsetNode gemsetNode;
            TreeNode treeNode = children.nextElement();
            if (!(treeNode instanceof RVMGemsetNode) || !(gemsetNode = (RVMGemsetNode)treeNode).isChecked()) continue;
            return gemsetNode;
        }
        return null;
    }

    private static void saveCheckedSdk(@NotNull MultiMap<String, String> map, boolean nodeChecked, @NotNull Sdk sdk) {
        if (map == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(8);
        }
        String homePath = sdk.getHomePath();
        if (nodeChecked && !map.containsKey((Object)homePath)) {
            map.put((Object)homePath, (Collection)new SmartList());
        }
    }

    private static boolean isDefaultRbenvGemset(@NotNull TreeNode node) {
        if (node == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(9);
        }
        return node instanceof RbenvGemsetNode && "default".equals(((RbenvGemsetNode)((Object)node)).myGemset);
    }

    private void addSdkCustomAction(@NotNull ToolbarDecorator sdksToolbarDecorator, @NotNull CheckboxTreeBase sdkTree) {
        RubySdkCustomActionProvider actionProvider;
        if (sdksToolbarDecorator == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(10);
        }
        if (sdkTree == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(11);
        }
        if ((actionProvider = RubySdkCustomActionProvider.getInstance()) != null) {
            sdksToolbarDecorator.addExtraAction(actionProvider.createAction(this.getProject(), (Tree)sdkTree, this));
        }
    }

    protected abstract MultiMap<String, String> getSettingsMap();

    abstract void saveSettingsMap(@NotNull MultiMap<String, String> var1);

    @Nullable
    public static Sdk getSdkByPath(@NotNull TreePath path) {
        DefaultMutableTreeNode selectedNode;
        if (path == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(12);
        }
        if ((selectedNode = RubySdkGemsConfigurableBase.extractNode(path)) instanceof SdkNode) {
            return ((SdkNode)selectedNode).mySdk;
        }
        return null;
    }

    private void selectSdkInTree(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(13);
        }
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            Object e = children.nextElement();
            if (!(e instanceof SdkNode)) continue;
            SdkNode sdkNode = (SdkNode)e;
            if (!RubySdkGemsConfigurableBase.equalSdks(sdkNode.mySdk, sdk)) continue;
            TreeUtil.selectInTree((DefaultMutableTreeNode)sdkNode, (boolean)true, (JTree)this.mySdkTree, (boolean)true);
            this.mySdkTree.scrollPathToVisible(this.mySdkTree.getSelectionPath());
            break;
        }
    }

    private void initTreeState() {
        Sdk sdk = this.getSdk();
        TreeUtil.traverse((TreeNode)((Object)this.myRoot), node -> {
            if (node instanceof SdkNode && RubySdkGemsConfigurableBase.equalSdks(((SdkNode)node).mySdk, sdk)) {
                this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RadioButtonNode)node, true);
            } else if (node instanceof RVMGemsetNode) {
                Collection rvmGemsets;
                Sdk rootRVMSdk;
                if ("default".equals(((RVMGemsetNode)node).myGemset) && (rootRVMSdk = this.findRootRVMSdk(((RVMGemsetNode)node).mySdk)) != null && ((rvmGemsets = this.mySdkGemsetsMap.get((Object)rootRVMSdk.getHomePath())).isEmpty() || rvmGemsets.size() == 1 && rvmGemsets.contains(RVM_GLOBAL_GEMSET))) {
                    this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RVMGemsetNode)node, true);
                }
                if (!RubySdkGemsConfigurableBase.equalSdks(((GemsetNode)node).getSdk(), sdk)) {
                    return true;
                }
                this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RadioButtonNode)node, true);
                TreeNode sdkNode = ((RVMGemsetNode)node).getParent();
                if (!(sdkNode instanceof SdkNode)) {
                    return true;
                }
                this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (SdkNode)sdkNode, true);
                RVMGlobalGemsetNode globalGemset = RubySdkGemsConfigurableBase.findRVMSdkGlobalGemset((SdkNode)sdkNode);
                if (globalGemset != null) {
                    this.mySdkTree.setNodeState((CheckedTreeNode)globalGemset, !RVMSupportUtil.isGlobalGempathIgnored(sdk));
                }
            } else if (node instanceof RVMGlobalGemsetNode) {
                Sdk rootRVMSdk = this.findRootRVMSdk(((RVMGlobalGemsetNode)node).mySdk);
                if (rootRVMSdk != null && this.mySdkGemsetsMap.get((Object)rootRVMSdk.getHomePath()).isEmpty()) {
                    this.mySdkTree.setNodeState((CheckedTreeNode)((RVMGlobalGemsetNode)node), true);
                }
                if (!RubySdkGemsConfigurableBase.equalSdks(((RVMGlobalGemsetNode)node).mySdk, sdk)) {
                    return true;
                }
                TreeNode sdkNode = ((RVMGlobalGemsetNode)node).getParent();
                if (!(sdkNode instanceof SdkNode)) {
                    return true;
                }
                this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RadioButtonNode)sdkNode, true);
            } else if (node instanceof RbenvGemsetNode) {
                TreeNode sdkNode = ((RbenvGemsetNode)node).getParent();
                if (!(sdkNode instanceof SdkNode) || sdk == null) {
                    return true;
                }
                String rbenvGemset = RbenvGemsetManager.getRbenvGemset(sdk);
                Sdk rootRbenvSdk = RbenvGemsetManager.findRootRbenvSdk(this.getAllRubySdks(), sdk);
                if (((RbenvGemsetNode)node).myGemset.equals(rbenvGemset) && RubySdkGemsConfigurableBase.equalSdks(((SdkNode)sdkNode).mySdk, rootRbenvSdk)) {
                    this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RadioButtonNode)sdkNode, true);
                    this.mySdkTree.setNodeState((CheckedTreeNode)((RbenvGemsetNode)node), true);
                }
            }
            return true;
        });
        if (sdk == null) {
            this.processSdkNodes((Consumer<SdkNode>)((Consumer)sdkNode -> this.mySdkRadioButtonTreeHelper.setNodeState((Tree)this.mySdkTree, (RadioButtonNode)sdkNode, false)));
            this.checkErrors();
        }
    }

    private static void turnRVMGlobal(Sdk sdk, boolean ignore) {
        RVMSupportUtil.updateSdk(sdk, ignore);
    }

    private void selectAndExpandSdkNode() {
        TreePath path = this.expandPersistedSdkNode();
        if (path == null) {
            return;
        }
        TreeUtil.showRowCentered((JTree)this.mySdkTree, (int)(this.mySdkTree.getRowForPath(path) - 1), (boolean)false);
        this.mySdkTree.setSelectionPath(path);
    }

    @Nullable
    private TreePath expandPersistedSdkNode() {
        SdkNode node = this.findSdkToSelect(this.getSdk());
        if (node == null) {
            return null;
        }
        TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
        this.mySdkTree.expandPath(path);
        return path;
    }

    @Nullable
    static GemInfo getSelectedNodeGemInfo(@NotNull SimpleTree tree) {
        SimpleNode selectedNode;
        if (tree == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(14);
        }
        if ((selectedNode = tree.getSelectedNode()) == null) {
            return null;
        }
        Object selectedGem = selectedNode.getElement();
        if (!(selectedGem instanceof RenderedNode) || ((RenderedNode)((Object)selectedGem)).getChildCount() != 0) {
            return null;
        }
        GemInfo gemInfo = ((RenderedNode)((Object)selectedGem)).getGem();
        if (gemInfo == null) {
            return null;
        }
        return gemInfo;
    }

    @Nullable
    private SdkNode getCheckedSdkNode() {
        Enumeration children = this.myRoot.children();
        while (children.hasMoreElements()) {
            SdkNode sdkNode;
            Object e = children.nextElement();
            if (!(e instanceof SdkNode) || !(sdkNode = (SdkNode)e).isChecked()) continue;
            return sdkNode;
        }
        return null;
    }

    @Nullable
    Sdk getCheckedSdk() {
        SdkNode checkedSdkNode = this.getCheckedSdkNode();
        if (checkedSdkNode == null) {
            return null;
        }
        RVMGemsetNode checkedRVMGemsetNode = RubySdkGemsConfigurableBase.getCheckedRVMGemsetNode(checkedSdkNode);
        if (checkedRVMGemsetNode != null) {
            return checkedRVMGemsetNode.getSdk();
        }
        return checkedSdkNode.mySdk;
    }

    @Nullable
    protected abstract Sdk getSdk();

    private void updateGems(Sdk sdk) {
        if (RVMSupportUtil.isNewRVMGemsetSdk(sdk)) {
            return;
        }
        if (RubyRemoteInterpreterManager.isDownloading(sdk)) {
            this.myLoadingDecorator.startLoading(false);
            return;
        }
        Application application = ApplicationManager.getApplication();
        Runnable runnable = () -> {
            this.myLoadingDecorator.startLoading(false);
            if (RubySdkUtil.isRubySDK(sdk)) {
                if (this.myPendingRefresh != null) {
                    this.myPendingRefresh.cancel(false);
                }
                this.myPendingRefresh = RubySdkPatcher.prepareGemRootsAndRefreshOnPooledThread(sdk, () -> this.refreshGemsAndRebuildGemsTree(sdk));
            } else {
                this.refreshGemsAndRebuildGemsTree(sdk);
            }
        };
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable, ModalityState.stateForComponent((Component)this.myRootPanel));
        }
    }

    private void refreshGemsAndRebuildGemsTree(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(15);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.stateForComponent((Component)this.myRootPanel));
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            RubySdkGemLibraryManager.getInstance().refresh(false);
            ApplicationManager.getApplication().invokeLater(() -> this.rebuildGemsTree(sdk));
        }, (ProgressIndicator)indicator));
    }

    private void rebuildGemsTree(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(16);
        }
        this.myTreeModel.invalidateAsync();
        if (this.isSelectedSdk(sdk)) {
            this.myLoadingDecorator.stopLoading();
        }
    }

    private boolean isSelectedSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(17);
        }
        return this.mySelectedSdkNode != null && this.mySelectedSdkNode.mySdk.equals(sdk) || this.mySelectedGemsetNode != null && ((GemsetNode)((Object)this.mySelectedGemsetNode)).getSdk().equals(sdk);
    }

    @Nullable
    @Nls
    private String getNoSdkSelectedError() {
        return this.getCheckedSdk() == null ? this.getErrorMessage() : null;
    }

    @NotNull
    @Nls
    protected abstract String getErrorMessage();

    private void hideError() {
        if (this.myMessagePane != null) {
            this.myRootPanel.remove((Component)this.myMessagePane);
            this.myRootPanel.revalidate();
        }
    }

    protected void showError(@NotNull @Nls String msg) {
        if (msg == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(18);
        }
        if (this.getRubySdks().isEmpty()) {
            if (this.myMessagePane == null) {
                this.myMessagePane = new HyperlinkLabel();
                @NonNls String format = "%s <hyperlink>%s</hyperlink>.";
                this.myMessagePane.setTextWithHyperlink(String.format("%s <hyperlink>%s</hyperlink>.", RBundle.message((String)"ruby.ide.sdk.configurable.no.sdk.found"), RBundle.message((String)"ruby.ide.sdk.configurable.no.sdk.found.topic")));
                this.myMessagePane.setIconAtRight(false);
                this.myMessagePane.addHyperlinkListener(e -> HelpManager.getInstance().invokeHelp(RubySdkGemsConfigurableBase.getSetupHelpTopic()));
            }
        } else {
            if (this.myMessagePane == null) {
                this.myMessagePane = new HyperlinkLabel();
            }
            this.myMessagePane.setText(msg);
        }
        this.myMessagePane.setIcon(AllIcons.General.BalloonError);
        this.myRootPanel.add("South", (Component)this.myMessagePane);
        this.myRootPanel.revalidate();
    }

    public String getDisplayName() {
        return RBundle.message((String)"ruby.ide.sdk.configurable.name");
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.ruby.gems";
    }

    @NonNls
    @NotNull
    private static String getSetupHelpTopic() {
        return "SetupRubyEnvironment";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(19);
        }
        return jPanel;
    }

    public boolean isModified() {
        return !RubySdkGemsConfigurableBase.equalSdks(this.getCheckedSdk(), this.getSdk()) || !this.myCommandStack.isEmpty();
    }

    private static boolean equalSdks(@Nullable Sdk sdk1, @Nullable Sdk sdk2) {
        return RubySdkUtil.equalSdks(sdk1, sdk2);
    }

    public final void apply() throws ConfigurationException {
        if (!this.myNewRVMGemsetNodes.isEmpty()) {
            this.createRVMGemsetsPhysically((NullableConsumer<Sdk>)((NullableConsumer)sdk -> {
                try {
                    this.doApply();
                }
                catch (ConfigurationException e) {
                    LOG.warn("Cannot apply settings; " + e.getMessage());
                }
            }));
            return;
        }
        this.doApply();
    }

    protected void doApply() throws ConfigurationException {
        String errors = this.checkErrors();
        if (errors != null) {
            throw new ConfigurationException(RBundle.message((String)"ruby.ide.sdk.configurable.errors.text", (Object[])new Object[]{errors}));
        }
        this.updateRVMSdkGlobalPath();
        this.myCommandStack.clear();
        LanguageLevel oldLanguageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.getSdk());
        LanguageLevel newLanguageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.getCheckedSdk());
        RubyLanguageLevelPusher.pushLanguageLevelIfNeeded(oldLanguageLevel, newLanguageLevel, this.getProject());
    }

    private void createRVMGemsetsPhysically(@NotNull NullableConsumer<Sdk> postAction) {
        if (postAction == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(20);
        }
        MultiMap rootRVMSdkToNewGemsets = new MultiMap();
        for (NewRVMGemsetNode node : this.myNewRVMGemsetNodes) {
            Sdk rootRVMSdk = this.findRootRVMSdk(node.getSdk());
            rootRVMSdkToNewGemsets.putValue((Object)rootRVMSdk, (Object)node.getGemset());
        }
        RvmSdkRefresher.createRVMGemsets(this.getProject(), (MultiMap<Sdk, String>)rootRVMSdkToNewGemsets, postAction);
    }

    private void updateRVMSdkGlobalPath() {
        RVMGemsetNode checkedRVMGemsetNode;
        SdkNode checkedSdkNode;
        Sdk oldSdk = this.getSdk();
        if (RVMSupportUtil.isRVMInterpreter(oldSdk)) {
            RubySdkGemsConfigurableBase.turnRVMGlobal(oldSdk, false);
        }
        if ((checkedSdkNode = this.getCheckedSdkNode()) != null && (checkedRVMGemsetNode = RubySdkGemsConfigurableBase.getCheckedRVMGemsetNode(checkedSdkNode)) != null) {
            RVMGlobalGemsetNode rvmGlobalGemset = RubySdkGemsConfigurableBase.findRVMSdkGlobalGemset(checkedSdkNode);
            RubySdkGemsConfigurableBase.turnRVMGlobal(checkedRVMGemsetNode.getSdk(), rvmGlobalGemset == null || !rvmGlobalGemset.isChecked());
        }
    }

    public void reset() {
        this.undoAll();
        this.mySdkGemsetsMap = this.getSettingsMap();
        this.initTreeState();
        this.saveSettingsMap((MultiMap<String, String>)this.mySdkGemsetsMap.copy());
        this.refreshToInitState();
        this.checkErrors();
    }

    protected void refreshToInitState() {
        this.refreshSdksTree();
        this.selectAndExpandSdkNode();
    }

    private void undoAll() {
        while (!this.myCommandStack.isEmpty()) {
            ((BaseSdkCommand)this.myCommandStack.pop()).undo();
        }
    }

    private void refreshSdksTree() {
        this.reloadTree();
        this.initTreeState();
    }

    private void reloadTree() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myRoot.rebuildChildren();
            ((DefaultTreeModel)this.mySdkTree.getModel()).reload((TreeNode)((Object)this.myRoot));
        }
    }

    private void removeSdks() {
        Sdk sdk = this.mySelectedSdkNode.mySdk;
        if (RbenvGemsetManager.isLocalRbenvSdk(sdk) && RbenvGemsetManager.isRootRbenvSdk(sdk)) {
            RbenvGemsetManager.getGemsetsSdk(sdk).forEach(this::removeSdkFromTree);
        }
        this.removeSdkFromTree(sdk);
    }

    private void removeSdkFromTree(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(21);
        }
        this.myCommandStack.push((Object)new RemoveSdkCommand(sdk));
        this.removeSdkInner(sdk);
    }

    private void removeSdkInner(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(22);
        }
        int selectedIndex = this.mySdkTree.getMaxSelectionRow();
        this.removeSdk(sdk);
        this.refreshToInitState();
        int count = this.mySdkTree.getRowCount();
        if (count > 0 && selectedIndex >= count) {
            selectedIndex = count - 1;
        }
        this.selectAndScroll(selectedIndex);
        this.mySdkGemsetsMap.remove((Object)sdk.getHomePath());
        this.checkErrors();
    }

    protected void removeSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(23);
        }
        SdkConfigurationUtil.removeSdk((Sdk)sdk);
    }

    private void selectAndScroll(int selectedIndex) {
        TreeUtil.selectRow((JTree)this.mySdkTree, (int)selectedIndex);
    }

    public void disposeUIResources() {
        this.undoAll();
        this.myIsDisposed = true;
    }

    public void dispose() {
    }

    private List<List<GemInfo>> getGemsWithVersions() {
        Iterable<GemInfo> sdkGems = ContainerUtil.emptyList();
        if (this.mySelectedGemsetNode instanceof RbenvGemsetNode) {
            TreeNode sdkNode = this.mySelectedGemsetNode.getParent();
            if (!(sdkNode instanceof SdkNode)) {
                return ContainerUtil.emptyList();
            }
            sdkGems = RubySdkGemsConfigurableBase.isDefaultRbenvGemset(this.mySelectedGemsetNode) ? GemManager.getInstance().getRbenvSdkWithGemsetsGems(((SdkNode)sdkNode).mySdk, ContainerUtil.emptyList()) : GemManager.getInstance().getRbenvGemsetGems(RbenvGemsetManager.getGemsetSdk(((SdkNode)sdkNode).mySdk, ((RbenvGemsetNode)((Object)this.mySelectedGemsetNode)).myGemset));
        } else if (this.mySelectedSdkNode != null && RbenvGemsetManager.isLocalRbenvSdk(this.mySelectedSdkNode.mySdk)) {
            sdkGems = GemManager.getInstance().getRbenvSdkWithGemsetsGems(this.mySelectedSdkNode.mySdk, this.mySdkGemsetsMap.get((Object)this.mySelectedSdkNode.mySdk.getHomePath()));
        } else if (this.mySelectedGemsetNode instanceof RVMGemsetNode) {
            sdkGems = RubySdkGemsConfigurableBase.getIgnoreGlobalRVMGemsetGems(((RVMGemsetNode)this.mySelectedGemsetNode).getSdk());
        } else if (this.mySelectedGemsetNode instanceof RVMGlobalGemsetNode) {
            sdkGems = GemManager.getInstance().getAllGems(((RVMGlobalGemsetNode)((Object)this.mySelectedGemsetNode)).getSdk());
        } else if (this.mySelectedSdkNode != null && this.mySelectedSdkNode.isLocalRVMNode()) {
            RVMGemsetNode checkedRVMGemsetNode = RubySdkGemsConfigurableBase.getCheckedRVMGemsetNode(this.mySelectedSdkNode);
            sdkGems = RubySdkGemsConfigurableBase.getIgnoreGlobalRVMGemsetGems(checkedRVMGemsetNode != null ? checkedRVMGemsetNode.getSdk() : this.mySelectedSdkNode.mySdk);
            RVMGlobalGemsetNode rvmGlobalGemset = RubySdkGemsConfigurableBase.findRVMSdkGlobalGemset(this.mySelectedSdkNode);
            if (rvmGlobalGemset != null && rvmGlobalGemset.isChecked()) {
                sdkGems = ContainerUtil.concat(sdkGems, GemManager.getInstance().getAllGems(rvmGlobalGemset.getSdk()));
            }
        } else if (this.mySelectedSdkNode != null) {
            sdkGems = GemManager.getInstance().getAllGems(this.mySelectedSdkNode.mySdk);
        }
        ArrayList<List<GemInfo>> allGemsWithVersions = new ArrayList<List<GemInfo>>();
        HashSet<String> uniqueGemNames = new HashSet<String>();
        for (GemInfo gem : sdkGems) {
            String name = gem.getName();
            uniqueGemNames.add(name);
        }
        for (String name : uniqueGemNames) {
            ArrayList<GemInfo> gemWithVersions = new ArrayList<GemInfo>();
            for (GemInfo gem : sdkGems) {
                if (!name.equals(gem.getName())) continue;
                gemWithVersions.add(gem);
            }
            allGemsWithVersions.add(gemWithVersions);
        }
        return allGemsWithVersions;
    }

    private static @Unmodifiable @NotNull Collection<? extends GemInfo> getIgnoreGlobalRVMGemsetGems(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(24);
        }
        Collection<GemInfo> gems = GemManager.getInstance().getAllGems(sdk);
        if (RVMSupportUtil.isGlobalGempathIgnored(sdk)) {
            Collection<GemInfo> collection = gems;
            if (collection == null) {
                RubySdkGemsConfigurableBase.$$$reportNull$$$0(25);
            }
            return collection;
        }
        Sdk rvmGlobalSdk = RVMSupportUtil.findRVMGemsetSdk(sdk, RVM_GLOBAL_GEMSET);
        Collection<GemInfo> rvmGlobalGemsetGems = GemManager.getInstance().getAllGems(rvmGlobalSdk);
        List list = ContainerUtil.filter(gems, gem -> !rvmGlobalGemsetGems.contains(gem));
        if (list == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private <T> List<T> filterMatchedElements(@NotNull String pattern, @NotNull List<T> elements, @NotNull Function<T, String> toStringFunction) {
        if (pattern == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(27);
        }
        if (elements == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(28);
        }
        if (toStringFunction == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(29);
        }
        TreeSpeedSearch search = this.mySdkTree == null ? null : (TreeSpeedSearch)SpeedSearchSupply.getSupply((JComponent)this.mySdkTree, (boolean)true);
        List list = ContainerUtil.filter(elements, t -> search == null || search.getComparator().matchingFragments(pattern, (String)toStringFunction.fun(t)) != null);
        if (list == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    private Sdk findRootRVMSdk(@NotNull Sdk rvmSdk) {
        if (rvmSdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(31);
        }
        return RVMSupportUtil.findRootRVMSdk(rvmSdk, this.getRubySdks());
    }

    @NotNull
    private Collection<Sdk> getRubySdks() {
        List list = ContainerUtil.filter(this.getAllRubySdks(), sdk -> !sdk.equals(this.mySdkToIgnore) && !RbenvGemsetManager.isGemsetSdk(sdk) && (RVMSupportUtil.getGemsetName(sdk) == null || RubyRemoteInterpreterManager.isRemoteSdk(sdk)));
        if (list == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public static @NotNull RubySdkType @NotNull [] getAllRubySdkTypes() {
        RubySdkType[] rubySdkTypeArray = new RubySdkType[]{RubySdkType.getInstance(), JRubySdkType.getInstance()};
        if (rubySdkTypeArray == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(33);
        }
        return rubySdkTypeArray;
    }

    @NotNull
    protected Collection<Sdk> getAllRubySdks() {
        Collection collection = Arrays.stream(RubySdkGemsConfigurableBase.getAllRubySdkTypes()).flatMap(it -> ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)it).stream()).collect(Collectors.toList());
        if (collection == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @Nullable
    private static DefaultMutableTreeNode extractNode(@Nullable Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            object = path.getLastPathComponent();
        }
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            FilteringTreeStructure.FilteringNode node = (FilteringTreeStructure.FilteringNode)object;
            object = node.getDelegate();
        }
        if (object instanceof RbenvGemsetNode) {
            return (RbenvGemsetNode)object;
        }
        if (object instanceof RVMGemsetNode) {
            return (RVMGemsetNode)object;
        }
        if (object instanceof RVMGlobalGemsetNode) {
            return (RVMGlobalGemsetNode)object;
        }
        if (object instanceof SdkNode) {
            return (SdkNode)object;
        }
        return null;
    }

    private void onSdkCreatedCallback(@Nullable Sdk sdk) {
        Object @NotNull [] existingSdks = this.getAllRubySdks().toArray(new Sdk[0]);
        if (sdk == null) {
            return;
        }
        if (ContainerUtil.exists((Object[])existingSdks, existingSdk -> RubySdkGemsConfigurableBase.isEqualSdks(sdk, existingSdk))) {
            Messages.showWarningDialog((Project)this.getProject(), (String)RBundle.message((String)"ruby.ide.sdk.configurable.create.sdk.existing", (Object[])new Object[]{sdk.getHomePath()}), (String)RBundle.message((String)"ruby.ide.sdk.configurable.create.sdk.existing.title"));
            return;
        }
        if (RVMSupportUtil.isNewRVMGemsetSdk(sdk)) {
            this.myCommandStack.push((Object)new AddRVMGemsetCommand(sdk));
            this.addSdkInPlugin(sdk);
            return;
        }
        this.myCommandStack.push((Object)new AddSdkCommand(sdk));
        this.addSdk(sdk);
        this.refreshPreserveState();
        this.selectSdkInTree(sdk);
        this.mySdkGemsetsMap.put((Object)sdk.getHomePath(), (Collection)ContainerUtil.emptyList());
    }

    private static boolean isEqualSdks(@NotNull Sdk sdk1, @NotNull Sdk sdk2) {
        if (sdk1 == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(35);
        }
        if (sdk2 == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(36);
        }
        return StringUtil.equals((CharSequence)sdk1.getHomePath(), (CharSequence)sdk2.getHomePath()) && RubySdkUtil.getRubySdkAdditionalData(sdk1).equals((Object)RubySdkUtil.getRubySdkAdditionalData(sdk2));
    }

    private void selectRVMGemsetInTree(@NotNull Sdk rvmGemsetSdk) {
        if (rvmGemsetSdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(37);
        }
        TreeUtil.traverse((TreeNode)((Object)this.myRoot), node -> {
            if (node instanceof RVMGemsetNode && RubySdkGemsConfigurableBase.equalSdks(((RVMGemsetNode)node).mySdk, rvmGemsetSdk)) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)((RVMGemsetNode)node), (boolean)true, (JTree)this.mySdkTree, (boolean)true);
                this.mySdkTree.scrollPathToVisible(this.mySdkTree.getSelectionPath());
                return false;
            }
            return true;
        });
    }

    protected void addSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(38);
        }
        SdkConfigurationUtil.addSdk((Sdk)sdk);
    }

    protected void addSdkInPlugin(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(39);
        }
    }

    @Nullable
    private String checkErrors() {
        String message = this.getNoSdkSelectedError();
        if (message != null) {
            this.showError(message);
            return message;
        }
        this.hideError();
        return null;
    }

    private static void saveGemsetsState(boolean checked, @NotNull String gemset, @NotNull MultiMap<String, String> map, @NotNull Sdk sdk) {
        if (gemset == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(40);
        }
        if (map == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(41);
        }
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(42);
        }
        String sdkPath = sdk.getHomePath();
        if (checked) {
            TreeSet<String> gemsets = new TreeSet<String>(map.get((Object)sdkPath));
            gemsets.add(gemset);
            map.put((Object)sdkPath, (Collection)new SmartList((Object[])ArrayUtilRt.toStringArray(gemsets)));
        } else {
            map.remove((Object)sdkPath, (Object)gemset);
        }
    }

    private void suggestAndAddSdk(@NotNull NullableConsumer<Sdk> onSdkCreatedCallBack, @NotNull RelativePoint point, Sdk @NotNull [] existingSdks) {
        if (onSdkCreatedCallBack == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(43);
        }
        if (point == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(44);
        }
        if (existingSdks == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(45);
        }
        Sdk selectedSdk = this.mySelectedSdkNode == null ? null : this.mySelectedSdkNode.mySdk;
        RubySdkConfigurableUtil.suggestAndAddSdk(this.getProject(), existingSdks, point, onSdkCreatedCallBack, this.getPreferableRVMSdk(selectedSdk), RubySdkGemsConfigurableBase.getAllRubySdkTypes());
    }

    @Nullable
    protected Sdk getPreferableRVMSdk(@Nullable Sdk selectedSdk) {
        return selectedSdk;
    }

    private void editSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(46);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        EditSdkDialog editSdkDialog = new EditSdkDialog(this.getProject(), sdkModificator, (Function1<? super String, String>)((Function1)s -> {
            if (sdk.getName().isBlank()) {
                return RBundle.message((String)"ruby.ide.sdk.edit.dialog.sdk.blank.error");
            }
            if (this.isDuplicateSdkName((String)s, sdk)) {
                return RBundle.message((String)"ruby.ide.sdk.edit.dialog.sdk.not.unique.error");
            }
            return null;
        }));
        if (editSdkDialog.showAndGet()) {
            String editedSdkName = editSdkDialog.getSdkName();
            String oldSdkName = sdkModificator.getName();
            if (!oldSdkName.equals(editedSdkName)) {
                sdkModificator.setName(editedSdkName);
                WriteAction.run(() -> ((SdkModificator)sdkModificator).commitChanges());
                this.refreshPreserveState();
                this.myCommandStack.add((Object)new MyEditSdkActionCommand(sdk, oldSdkName));
            }
        }
    }

    private boolean isDuplicateSdkName(@NotNull String s, @NotNull Sdk sdk) {
        if (s == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(47);
        }
        if (sdk == null) {
            RubySdkGemsConfigurableBase.$$$reportNull$$$0(48);
        }
        for (Sdk existingSdk : this.getAllRubySdks()) {
            if (existingSdk == sdk || !existingSdk.getName().equals(s)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 25, 26, 30, 32, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareSdks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkNodeProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkNode";
                break;
            }
            case 7: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksToolbarDecorator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTree";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAction";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toStringFunction";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSdk";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk1";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk2";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemsetSdk";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkCreatedCallBack";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreGlobalRVMGemsetGems";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMatchedElements";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdks";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRubySdkTypes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRubySdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeNewRVMGemsetNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshPreserveState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSdkCellContextPopupMenu";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processSdkNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRVMSdkGlobalGemset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCheckedRVMGemsetNode";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveCheckedSdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultRbenvGemset";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSdkCustomAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSdkByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectSdkInTree";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodeGemInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refreshGemsAndRebuildGemsTree";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rebuildGemsTree";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedSdk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsetsPhysically";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeSdkFromTree";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeSdkInner";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeSdk";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreGlobalRVMGemsetGems";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filterMatchedElements";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findRootRVMSdk";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEqualSdks";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "selectRVMGemsetInTree";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addSdkInPlugin";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "saveGemsetsState";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "suggestAndAddSdk";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "editSdk";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicateSdkName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 25, 26, 30, 32, 33, 34 -> new IllegalStateException(string);
        };
    }

    static interface RadiobuttonTreeListener
    extends EventListener {
        public void mouseDoubleClicked(@NotNull TreeNode var1);

        public void nodeStateChanged(@NotNull TreeNode var1);

        public void beforeNodeStateChanged(@NotNull TreeNode var1);
    }

    static final class NewRVMGemsetNode
    extends RVMGemsetNode {
        NewRVMGemsetNode(@NotNull Sdk sdk, @NotNull String gemset, boolean checked) {
            if (sdk == null) {
                NewRVMGemsetNode.$$$reportNull$$$0(0);
            }
            if (gemset == null) {
                NewRVMGemsetNode.$$$reportNull$$$0(1);
            }
            super(sdk, gemset, checked);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gemset";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$NewRVMGemsetNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyRootNode
    extends CheckedTreeNode {
        MyRootNode() {
            this.rebuildChildren();
        }

        public void rebuildChildren(@NotNull String pattern) {
            if (pattern == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            this.removeAllChildren();
            this.addChildren(pattern);
        }

        public void rebuildChildren() {
            this.rebuildChildren("");
        }

        protected void addChildren(@NotNull String pattern) {
            if (pattern == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            for (DefaultMutableTreeNode node : this.buildChildren(pattern)) {
                this.add(node);
            }
        }

        private DefaultMutableTreeNode @NotNull [] buildChildren(@NotNull String pattern) {
            if (pattern == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            Collection<Sdk> sdks = RubySdkGemsConfigurableBase.this.getRubySdks();
            List filteredSdks = RubySdkGemsConfigurableBase.this.filterMatchedElements(pattern, ContainerUtil.map(sdks, sdk -> new SdkNode(pattern, (Sdk)sdk, this.shouldCheckSdk((Sdk)sdk))), sdkNode -> sdkNode.mySdk.getName());
            List filteredGemsets = ContainerUtil.map(sdks, sdk -> new SdkNode(pattern, (Sdk)sdk, this.shouldCheckSdk((Sdk)sdk)));
            List notEmptySdkNodes = StringUtil.isEmpty((String)pattern) ? filteredGemsets : ContainerUtil.filter((Collection)filteredGemsets, sdkNode -> sdkNode.getChildCount() > 0);
            TreeSet<SdkNode> set1 = new TreeSet<SdkNode>(filteredSdks);
            TreeSet set2 = new TreeSet(notEmptySdkNodes);
            set1.addAll(set2);
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = set1.toArray(new SdkNode[0]);
            if (defaultMutableTreeNodeArray == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return defaultMutableTreeNodeArray;
        }

        private boolean shouldCheckSdk(@Nullable Sdk sdk) {
            return RubySdkGemsConfigurableBase.equalSdks(RubySdkGemsConfigurableBase.this.myCurrentCheckedSdkNode != null ? RubySdkGemsConfigurableBase.this.myCurrentCheckedSdkNode.mySdk : null, sdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyRootNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rebuildChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildChildren";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    class RootNode
    extends RenderedNode {
        RootNode() {
            super(null, false);
        }

        public SimpleNode @NotNull [] getChildren() {
            ArrayList<GemNode> nodes = new ArrayList<GemNode>();
            List<List<GemInfo>> gemLists = RubySdkGemsConfigurableBase.this.getGemsWithVersions();
            if (!gemLists.isEmpty()) {
                gemLists.sort(Comparator.comparing(o -> ((GemInfo)o.get(0)).getName()));
                for (List<GemInfo> list : gemLists) {
                    nodes.add(new GemNode(list));
                }
            }
            SimpleNode[] simpleNodeArray = nodes.toArray(NO_CHILDREN);
            if (simpleNodeArray == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            return simpleNodeArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RootNode", "getChildren"));
        }
    }

    private class RubyGemsTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final GemsTreeSpeedSearch mySpeedSearch;

        RubyGemsTreeCellRenderer(GemsTreeSpeedSearch speedSearch) {
            if (speedSearch == null) {
                RubyGemsTreeCellRenderer.$$$reportNull$$$0(0);
            }
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                RubyGemsTreeCellRenderer.$$$reportNull$$$0(1);
            }
            if (!(value instanceof DefaultMutableTreeNode)) {
                this.append(value.toString());
                return;
            }
            Object object = ((DefaultMutableTreeNode)value).getUserObject();
            if (object instanceof String) {
                this.append((String)object);
            } else if (object instanceof RenderedNode) {
                RenderedNode gemNode = (RenderedNode)((Object)object);
                String name = gemNode.getGemName();
                if (name == null) {
                    return;
                }
                String filter = this.mySpeedSearch.getEnteredPrefix();
                SearchUtil.appendFragments((String)filter, (String)name, (int)0, null, null, (SimpleColoredComponent)this);
                Object sourceText = "";
                Sdk sdk = RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk;
                if (gemNode.getGemVersion() != null) {
                    String versionSourceText = "";
                    GemInfo gemInfo = gemNode.getGem();
                    if (RubySdkGemsConfigurableBase.equalSdks(gemInfo.getSdk(), sdk)) {
                        String gemset = RbenvGemsetManager.fetchGemGemset(gemInfo);
                        versionSourceText = gemset != null ? gemset : "";
                    }
                    sourceText = gemNode.getGemVersion() + " " + versionSourceText;
                } else if (gemNode instanceof GemNode) {
                    SimpleNode[] versionNodes = gemNode.getChildren();
                    HashSet<String> sources = new HashSet<String>();
                    for (SimpleNode versionNode : versionNodes) {
                        GemInfo gemInfo;
                        if (!(versionNode instanceof VersionNode) || !RubySdkGemsConfigurableBase.equalSdks((gemInfo = ((VersionNode)versionNode).getGem()).getSdk(), sdk)) continue;
                        String gemset = RbenvGemsetManager.fetchGemGemset(gemInfo);
                        sources.add(gemset != null ? gemset : "default");
                    }
                    sourceText = "";
                    if (sources.contains("default")) {
                        sources.remove("default");
                        if (!sources.isEmpty()) {
                            sourceText = "default";
                        }
                    }
                    sourceText = (String)sourceText + sources.stream().filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
                    sourceText = StringUtil.shortenTextWithEllipsis((String)sourceText, (int)30, (int)0);
                }
                SearchUtil.appendFragments((String)filter, (String)(" " + (String)sourceText), (int)0, (Color)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor(), null, (SimpleColoredComponent)this);
            } else {
                this.append(object == null ? "null" : StringUtil.notNullize((String)object.toString()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RubyGemsTreeCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class RubySdkTreeCellRendererBase
    extends CheckboxTreeBase.CheckboxTreeCellRendererBase {
        private static final int ICON_TEXT_GAP = 12;
        public JBRadioButton myRadioButton;

        public RubySdkTreeCellRendererBase() {
            this.setBackground(null);
            this.myRadioButton = new JBRadioButton();
            this.myRadioButton.setOpaque(false);
            this.myRadioButton.setEnabled(true);
            this.myRadioButton.setSelected(false);
            this.myRadioButton.setBorder(BorderFactory.createEmptyBorder());
            ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
            textRenderer.setTextAlign(2);
            this.remove((Component)this.myCheckbox);
            this.remove((Component)textRenderer);
            this.setLayout((LayoutManager)new HorizontalLayout(0));
            this.add((Component)this.myRadioButton);
            this.add((Component)this.myCheckbox);
            this.add((Component)textRenderer);
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = RubySdkGemsConfigurableBase.extractNode(value);
            ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
            textRenderer.setIconTextGap(12);
            StringBuilder sourceText = new StringBuilder();
            Object optionText = "";
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (node instanceof RbenvGemsetNode) {
                this.myCheckbox.setVisible(true);
                this.myRadioButton.setVisible(false);
                String gemsetName = ((RbenvGemsetNode)((Object)node)).myGemset;
                TreeNode parent = node.getParent();
                if (!(parent instanceof SdkNode)) {
                    return;
                }
                Sdk sdk = ((SdkNode)parent).mySdk;
                if (gemsetName != null && !RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
                    sourceText.append(gemsetName);
                }
            } else if (node instanceof RVMGemsetNode) {
                this.myCheckbox.setVisible(false);
                this.myRadioButton.setVisible(true);
                this.myRadioButton.setSelected(((RVMGemsetNode)node).isChecked());
                Object gemsetName = ((RVMGemsetNode)node).myGemset;
                if (node instanceof NewRVMGemsetNode) {
                    gemsetName = (String)gemsetName + "*";
                }
                sourceText.append((String)gemsetName);
            } else if (node instanceof RVMGlobalGemsetNode) {
                this.myCheckbox.setVisible(true);
                this.myRadioButton.setVisible(false);
                this.myCheckbox.setSelected(((RVMGlobalGemsetNode)((Object)node)).isChecked());
                sourceText.append(RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET);
            } else if (node instanceof SdkNode) {
                String credentialId;
                String architecture;
                RbConfig rbConfig;
                this.myCheckbox.setVisible(false);
                this.myRadioButton.setVisible(true);
                this.myRadioButton.setSelected(((SdkNode)node).isChecked());
                Sdk sdk = ((SdkNode)node).mySdk;
                sourceText.append(sdk.getName());
                if (SystemInfo.isWindows && RubySdkUtil.isMRISdk(sdk) && RubySdkType.getInstance().isLocalSdk(sdk) && (rbConfig = RbConfig.from(sdk)) != null && StringUtil.isNotEmpty((String)(architecture = rbConfig.getArchitecture()))) {
                    optionText = " [" + architecture + "]";
                }
                if (StringUtil.isNotEmpty((String)(credentialId = RubySdkAdditionalData.notNullFrom(sdk).getConnectionCredentialId()))) {
                    optionText = " (" + credentialId + ")";
                }
                if (RubySdkUtil.canChangeLanguageLevel(sdk)) {
                    optionText = " [" + RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk).getShortName() + "]";
                }
                if (RubySdkGemsetsSettings.getInstance().getShowSdkPathFlag()) {
                    optionText = (String)optionText + " " + sdk.getHomePath();
                }
            }
            if (RubySdkGemsConfigurableBase.this.mySdkTreeSearch != null) {
                SearchUtil.appendFragments((String)RubySdkGemsConfigurableBase.this.mySdkTreeSearch.getEnteredPrefix(), (String)sourceText.toString(), (int)attributes.getStyle(), (Color)attributes.getFgColor(), (Color)attributes.getBgColor(), (SimpleColoredComponent)this.getTextRenderer());
                SearchUtil.appendFragments((String)RubySdkGemsConfigurableBase.this.mySdkTreeSearch.getEnteredPrefix(), (String)optionText, (int)SimpleTextAttributes.GRAYED_ATTRIBUTES.getStyle(), (Color)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor(), (Color)SimpleTextAttributes.GRAYED_ATTRIBUTES.getBgColor(), (SimpleColoredComponent)this.getTextRenderer());
            }
        }
    }

    private class AddSdkActionButtonRunnable
    implements AnActionButtonRunnable {
        private AddSdkActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            Sdk[] existingSdks = RubySdkGemsConfigurableBase.this.getAllRubySdks().toArray(new Sdk[0]);
            RelativePoint point = button.getPreferredPopupPoint();
            assert (point != null);
            RubySdkGemsConfigurableBase.this.suggestAndAddSdk((NullableConsumer<Sdk>)((NullableConsumer)RubySdkGemsConfigurableBase.this::onSdkCreatedCallback), point, existingSdks);
        }
    }

    private class RemoveSdkActionButtonRunnable
    implements AnActionButtonRunnable {
        private RemoveSdkActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            RubySdkGemsConfigurableBase.this.removeSdks();
        }
    }

    private final class RemoveSdkActionButtonUpdater
    implements AnActionButtonUpdater {
        private RemoveSdkActionButtonUpdater() {
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveSdkActionButtonUpdater.$$$reportNull$$$0(0);
            }
            return RubySdkGemsConfigurableBase.this.mySelectedSdkNode != null && (RubyRemoteInterpreterManager.isRemoteSdk(RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk) || !RbenvGemsetManager.isRbenvSdk(RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk) && !RVMSupportUtil.isRVMInterpreter(RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RemoveSdkActionButtonUpdater", "isEnabled"));
        }
    }

    private class MyEditSdkActionButtonRunnable
    implements AnActionButtonRunnable {
        private MyEditSdkActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            RubySdkGemsConfigurableBase.this.editSdk(RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk);
        }
    }

    private class MyEditSdkActionButtonUpdater
    implements AnActionButtonUpdater {
        private MyEditSdkActionButtonUpdater() {
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditSdkActionButtonUpdater.$$$reportNull$$$0(0);
            }
            return RubySdkGemsConfigurableBase.this.mySelectedSdkNode != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyEditSdkActionButtonUpdater", "isEnabled"));
        }
    }

    private static class MyExpandAllAction
    extends ExpandAllAction {
        MyExpandAllAction(JTree tree) {
            super(tree);
            this.setShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyExpandAllAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyExpandAllAction.$$$reportNull$$$0(1);
            }
            if (SystemInfo.isWindows) {
                e.getPresentation().setEnabled(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyExpandAllAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyExpandAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyCollapseAllAction
    extends CollapseAllAction {
        MyCollapseAllAction(JTree tree) {
            super(tree);
            this.setShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyCollapseAllAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCollapseAllAction.$$$reportNull$$$0(1);
            }
            if (SystemInfo.isWindows) {
                e.getPresentation().setEnabled(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyCollapseAllAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyCollapseAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ChooseLanguageLevelAction
    extends AnAction {
        ChooseLanguageLevelAction() {
            super(RBundle.message((String)"ruby.ide.sdk.configurable.select.language.level.action.text"));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseLanguageLevelAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(RubySdkUtil.canChangeLanguageLevel(this.getSelectedSdk()));
            LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.getSelectedSdk());
            presentation.setIcon(RubyLanguageLevelPusher.getOrCreateLanguageLevelIcon(languageLevel));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ChooseLanguageLevelAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RelativePoint preferredPopupPoint;
            if (e == null) {
                ChooseLanguageLevelAction.$$$reportNull$$$0(2);
            }
            if ((preferredPopupPoint = RubySdkGemsConfigurableBase.this.myActionsPanel.getPreferredPopupPoint((AnAction)this)) == null) {
                LOG.warn("Unable to find preferred popup point for " + String.valueOf(((Object)((Object)this)).getClass()));
                preferredPopupPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
            }
            this.showLanguageLevelPopup(preferredPopupPoint);
        }

        private void showLanguageLevelPopup(@NotNull RelativePoint point) {
            if (point == null) {
                ChooseLanguageLevelAction.$$$reportNull$$$0(3);
            }
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LanguageLevelPopupStep(RBundle.message((String)"ruby.ide.sdk.configurable.select.language.level.title"), RubySdkUtil.getSupportedLanguageLevels(this.getSelectedSdk())));
            popup.show(point);
        }

        @Nullable
        private Sdk getSelectedSdk() {
            return RubySdkGemsConfigurableBase.this.mySelectedSdkNode != null ? RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$ChooseLanguageLevelAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$ChooseLanguageLevelAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "showLanguageLevelPopup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class MyShowSdkPathAction
    extends ToggleAction {
        private MyShowSdkPathAction() {
            super(() -> RBundle.message((String)"ruby.ide.sdk.show.path.label"), AllIcons.General.InspectionsEye);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShowSdkPathAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSdkPathAction.$$$reportNull$$$0(1);
            }
            return RubySdkGemsetsSettings.getInstance().getShowSdkPathFlag();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowSdkPathAction.$$$reportNull$$$0(2);
            }
            RubySdkGemsetsSettings.getInstance().setShowSdkPathFlag(state);
            RubySdkGemsConfigurableBase.this.refreshPreserveState();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyShowSdkPathAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyShowSdkPathAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    final class SdkNode
    extends RadioButtonNode
    implements Comparable<SdkNode> {
        @NotNull
        private final Sdk mySdk;

        public boolean equals(Object obj) {
            if (!(obj instanceof SdkNode)) {
                return false;
            }
            return RubySdkGemsConfigurableBase.equalSdks(this.mySdk, ((SdkNode)obj).mySdk);
        }

        public int hashCode() {
            return this.mySdk.hashCode();
        }

        SdkNode(@NotNull String pattern, Sdk sdk, boolean checked) {
            if (pattern == null) {
                SdkNode.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                SdkNode.$$$reportNull$$$0(1);
            }
            this.mySdk = sdk;
            this.setChecked(checked);
            this.setUserObject(sdk);
            if (RbenvGemsetManager.isLocalRbenvSdk(sdk)) {
                this.getRbenvGemsetNodes(pattern).forEach(this::add);
            }
            if (this.isLocalRVMNode() && RVMSupportUtil.getGemsetName(this.mySdk) == null) {
                this.getRVMGemsetNodes(pattern).forEach(this::add);
            }
        }

        private boolean isLocalRVMNode() {
            return RVMSupportUtil.isRVMInterpreter(this.mySdk) && !RubyRemoteInterpreterManager.isRemoteSdk(this.mySdk);
        }

        @Override
        public String toString() {
            return this.mySdk.getName();
        }

        @NotNull
        public Sdk getSdk() {
            Sdk sdk = this.mySdk;
            if (sdk == null) {
                SdkNode.$$$reportNull$$$0(2);
            }
            return sdk;
        }

        @NotNull
        Collection<DefaultMutableTreeNode> getRVMGemsetNodes(@NotNull String pattern) {
            if (pattern == null) {
                SdkNode.$$$reportNull$$$0(3);
            }
            TreeMap<String, Sdk> sdksMap = this.getGemsets(this.mySdk);
            for (NewRVMGemsetNode newRVMGemsetNode : RubySdkGemsConfigurableBase.this.myNewRVMGemsetNodes) {
                Sdk newRVMGemsetNodeSdk = newRVMGemsetNode.getSdk();
                if (!StringUtil.equals((CharSequence)newRVMGemsetNodeSdk.getHomePath(), (CharSequence)this.mySdk.getHomePath())) continue;
                sdksMap.put(newRVMGemsetNode.getGemset(), newRVMGemsetNodeSdk);
            }
            ArrayList<DefaultMutableTreeNode> children = new ArrayList<GemsetNode>();
            if (sdksMap.containsKey(RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET)) {
                RVMGlobalGemsetNode globalGemsetNode = new RVMGlobalGemsetNode(sdksMap.get(RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET), this.shouldCheckGemset(RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET));
                children.add((DefaultMutableTreeNode)((Object)globalGemsetNode));
                sdksMap.remove(RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET);
            }
            RVMGemsetNode defaultGemsetNode = new RVMGemsetNode(this.mySdk, "default", this.shouldCheckGemset("default"));
            children.add(defaultGemsetNode);
            children.addAll(ContainerUtil.map(sdksMap.keySet(), gemset -> {
                Sdk sdk = (Sdk)sdksMap.get(gemset);
                return RVMSupportUtil.isNewRVMGemsetSdk(sdk) ? new NewRVMGemsetNode(sdk, (String)gemset, false) : new RVMGemsetNode(sdk, (String)gemset, this.shouldCheckGemset((String)gemset));
            }));
            ArrayList<DefaultMutableTreeNode> arrayList = children = RubySdkGemsConfigurableBase.this.filterMatchedElements(pattern, children, node -> ((GemsetNode)((Object)node)).getGemset());
            if (arrayList == null) {
                SdkNode.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        private TreeMap<String, Sdk> getGemsets(@NotNull Sdk sdk) {
            if (sdk == null) {
                SdkNode.$$$reportNull$$$0(5);
            }
            ArrayList<Sdk> gemsetSdks = new ArrayList<Sdk>();
            for (Sdk s2 : RubySdkGemsConfigurableBase.this.getAllRubySdks()) {
                if (!StringUtil.equals((CharSequence)s2.getHomePath(), (CharSequence)sdk.getHomePath()) || RubySdkGemsConfigurableBase.getGemsetName(s2) == null) continue;
                gemsetSdks.add(s2);
            }
            TreeMap treeMap = gemsetSdks.stream().collect(Collectors.toMap(RubySdkGemsConfigurableBase::getGemsetName, s -> s, (a, b) -> b, TreeMap::new));
            if (treeMap == null) {
                SdkNode.$$$reportNull$$$0(6);
            }
            return treeMap;
        }

        private boolean shouldCheckGemset(@NotNull String gemset) {
            if (gemset == null) {
                SdkNode.$$$reportNull$$$0(7);
            }
            return RubySdkGemsConfigurableBase.this.mySdkGemsetsMap.get((Object)this.mySdk.getHomePath()).contains(gemset);
        }

        @NotNull
        Collection<DefaultMutableTreeNode> getRbenvGemsetNodes(@NotNull String pattern) {
            if (pattern == null) {
                SdkNode.$$$reportNull$$$0(8);
            }
            TreeMap<String, Sdk> sdksMap = this.getGemsets(this.mySdk);
            List gemsets = RbenvGemsetManager.getRbenvGemsetNames(this.mySdk).stream().sorted().collect(Collectors.toCollection(ArrayList::new));
            gemsets.add(0, "default");
            gemsets = RubySdkGemsConfigurableBase.this.filterMatchedElements(pattern, gemsets, gemset -> gemset);
            ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
            for (String gemset2 : gemsets) {
                Sdk gemsetSdk = sdksMap.get(gemset2);
                if ("default".equals(gemset2)) {
                    gemsetSdk = this.mySdk;
                }
                if (gemsetSdk == null) continue;
                boolean checked = this.shouldCheckGemset(gemset2) || "default".equals(gemset2);
                boolean enabled = !"default".equals(gemset2);
                result.add((DefaultMutableTreeNode)((Object)new RbenvGemsetNode(gemsetSdk, gemset2, checked, enabled)));
            }
            ArrayList<DefaultMutableTreeNode> arrayList = result;
            if (arrayList == null) {
                SdkNode.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @Override
        public int compareTo(SdkNode sdkNode) {
            if (sdkNode == null) {
                return -1;
            }
            return SdkComparator.compareSdks(this.mySdk, sdkNode.mySdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$SdkNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$SdkNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRVMGemsetNodes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsets";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRbenvGemsetNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRVMGemsetNodes";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getGemsets";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldCheckGemset";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRbenvGemsetNodes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    static class RbenvGemsetNode
    extends CheckedTreeNode
    implements GemsetNode {
        private final String myGemset;
        @NotNull
        private final Sdk mySdk;

        RbenvGemsetNode(@NotNull Sdk sdk, @NotNull String gemset, boolean checked, boolean enabled) {
            if (sdk == null) {
                RbenvGemsetNode.$$$reportNull$$$0(0);
            }
            if (gemset == null) {
                RbenvGemsetNode.$$$reportNull$$$0(1);
            }
            this.mySdk = sdk;
            this.setChecked(checked);
            this.setEnabled(enabled);
            this.myGemset = gemset;
            this.setUserObject(this.myGemset);
        }

        public String toString() {
            return this.myGemset;
        }

        @Override
        @NotNull
        public Sdk getSdk() {
            Sdk sdk = this.mySdk;
            if (sdk == null) {
                RbenvGemsetNode.$$$reportNull$$$0(2);
            }
            return sdk;
        }

        @Override
        @NotNull
        public String getGemset() {
            String string = this.myGemset;
            if (string == null) {
                RbenvGemsetNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemset";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RbenvGemsetNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RbenvGemsetNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static interface GemsetNode {
        @NotNull
        public Sdk getSdk();

        @NotNull
        public String getGemset();
    }

    static class RVMGlobalGemsetNode
    extends CheckedTreeNode
    implements GemsetNode {
        @NotNull
        private final Sdk mySdk;

        RVMGlobalGemsetNode(@NotNull Sdk sdk, boolean checked) {
            if (sdk == null) {
                RVMGlobalGemsetNode.$$$reportNull$$$0(0);
            }
            this.mySdk = sdk;
            this.setChecked(checked);
            this.setUserObject(sdk);
        }

        @Override
        @NotNull
        public Sdk getSdk() {
            Sdk sdk = this.mySdk;
            if (sdk == null) {
                RVMGlobalGemsetNode.$$$reportNull$$$0(1);
            }
            return sdk;
        }

        @Override
        @NotNull
        public String getGemset() {
            return RubySdkGemsConfigurableBase.RVM_GLOBAL_GEMSET;
        }

        public String toString() {
            return this.getGemset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RVMGlobalGemsetNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RVMGlobalGemsetNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class RVMGemsetNode
    extends RadioButtonNode
    implements GemsetNode {
        @NotNull
        private final Sdk mySdk;
        @NotNull
        public final String myGemset;

        RVMGemsetNode(@NotNull Sdk sdk, @NotNull String gemset, boolean checked) {
            if (sdk == null) {
                RVMGemsetNode.$$$reportNull$$$0(0);
            }
            if (gemset == null) {
                RVMGemsetNode.$$$reportNull$$$0(1);
            }
            this.mySdk = sdk;
            this.myGemset = gemset;
            this.setChecked(checked);
            this.setUserObject(sdk);
        }

        @Override
        @NotNull
        public Sdk getSdk() {
            Sdk sdk = this.mySdk;
            if (sdk == null) {
                RVMGemsetNode.$$$reportNull$$$0(2);
            }
            return sdk;
        }

        @Override
        @NotNull
        public String getGemset() {
            String string = this.myGemset;
            if (string == null) {
                RVMGemsetNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.getGemset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemset";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RVMGemsetNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RVMGemsetNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static abstract class RenderedNode
    extends SimpleNode {
        private final String myGemName;
        private final String myGemVersion;
        private final GemInfo myGem;

        RenderedNode(GemInfo gem, boolean multipleVersions) {
            this.myGem = gem;
            this.myGemName = gem == null ? null : gem.getName();
            this.myGemVersion = gem == null || multipleVersions ? null : gem.getVersion();
        }

        protected String getGemName() {
            return this.myGemName;
        }

        protected String getGemVersion() {
            return this.myGemVersion;
        }

        protected GemInfo getGem() {
            return this.myGem;
        }

        public Object @NotNull [] getEqualityObjects() {
            Object[] objectArray = new Object[1];
            Object object = objectArray[0] = this.myGem != null ? this.myGem.getUrl() : null;
            if (objectArray == null) {
                RenderedNode.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$RenderedNode", "getEqualityObjects"));
        }
    }

    public class RemoveSdkCommand
    extends BaseSdkCommand {
        private final Sdk mySdkToRestore;

        public RemoveSdkCommand(Sdk sdk) {
            super(sdk);
            Sdk sdkToRestore = null;
            try {
                sdkToRestore = sdk.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
            this.mySdkToRestore = sdkToRestore;
        }

        @Override
        public void undo() {
            if (this.mySdkToRestore != null) {
                RubySdkGemsConfigurableBase.this.addSdk(this.mySdkToRestore);
            }
        }
    }

    public class AddRVMGemsetCommand
    extends BaseSdkCommand {
        public AddRVMGemsetCommand(Sdk sdk) {
            super(sdk);
        }

        @Override
        public void undo() {
            RubySdkGemsConfigurableBase.this.removeNewRVMGemsetNode(this.mySdk);
        }
    }

    public class AddSdkCommand
    extends BaseSdkCommand {
        public AddSdkCommand(Sdk sdk) {
            super(sdk);
        }

        @Override
        public void undo() {
            RubySdkGemsConfigurableBase.this.removeSdkInner(this.mySdk);
        }
    }

    private class MyEditSdkActionCommand
    extends BaseSdkCommand {
        private final String myOldSdkName;

        private MyEditSdkActionCommand(@NotNull Sdk sdk, String oldSdkName) {
            if (sdk == null) {
                MyEditSdkActionCommand.$$$reportNull$$$0(0);
            }
            if (oldSdkName == null) {
                MyEditSdkActionCommand.$$$reportNull$$$0(1);
            }
            super(sdk);
            this.myOldSdkName = oldSdkName;
        }

        @Override
        public void undo() {
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            sdkModificator.setName(this.myOldSdkName);
            WriteAction.run(() -> ((SdkModificator)sdkModificator).commitChanges());
            RubySdkGemsConfigurableBase.this.refreshPreserveState();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldSdkName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$MyEditSdkActionCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class LanguageLevelPopupStep
    extends BaseListPopupStep<LanguageLevel> {
        LanguageLevelPopupStep(String title, LanguageLevel[] levels) {
            super(title, (Object[])levels);
        }

        @NotNull
        public String getTextFor(LanguageLevel value) {
            return value != null ? value.getShortName() : "";
        }

        public PopupStep<?> onChosen(LanguageLevel selectedValue, boolean finalChoice) {
            return this.doFinalStep(() -> {
                Sdk selectedSdk = RubySdkGemsConfigurableBase.this.mySelectedSdkNode.mySdk;
                LanguageLevel oldLanguageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)selectedSdk);
                if (oldLanguageLevel != selectedValue && selectedValue != null) {
                    this.mergeLanguageLevelCommands(selectedSdk, oldLanguageLevel, selectedValue);
                    RubySdkAdditionalDataBase.modify((Sdk)selectedSdk, data -> data.setLanguageLevel(selectedValue));
                    RubySdkGemsConfigurableBase.this.mySdkTree.repaint();
                }
            });
        }

        private void mergeLanguageLevelCommands(@NotNull Sdk selectedSdk, @NotNull LanguageLevel oldLanguageLevel, @NotNull LanguageLevel newLanguageLevel) {
            ChangeLanguageLevelCommand newLanguageLevelCommand;
            int languageLevelCount;
            if (selectedSdk == null) {
                LanguageLevelPopupStep.$$$reportNull$$$0(0);
            }
            if (oldLanguageLevel == null) {
                LanguageLevelPopupStep.$$$reportNull$$$0(1);
            }
            if (newLanguageLevel == null) {
                LanguageLevelPopupStep.$$$reportNull$$$0(2);
            }
            if ((languageLevelCount = RubySdkGemsConfigurableBase.this.myCommandStack.search((Object)(newLanguageLevelCommand = new ChangeLanguageLevelCommand(selectedSdk, newLanguageLevel)))) == -1) {
                RubySdkGemsConfigurableBase.this.myCommandStack.push((Object)new ChangeLanguageLevelCommand(selectedSdk, oldLanguageLevel));
            } else {
                int i = RubySdkGemsConfigurableBase.this.myCommandStack.size() - languageLevelCount;
                while (i < RubySdkGemsConfigurableBase.this.myCommandStack.size()) {
                    BaseSdkCommand command = (BaseSdkCommand)RubySdkGemsConfigurableBase.this.myCommandStack.get(i);
                    if (command instanceof ChangeLanguageLevelCommand && command.mySdk == newLanguageLevelCommand.mySdk) {
                        if (!RubySdkGemsConfigurableBase.this.myCommandStack.remove((Object)command)) break;
                        continue;
                    }
                    ++i;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedSdk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldLanguageLevel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newLanguageLevel";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$LanguageLevelPopupStep";
            objectArray[2] = "mergeLanguageLevelCommands";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class VersionNode
    extends RenderedNode {
        VersionNode(GemInfo gem) {
            super(gem, false);
        }

        public SimpleNode @NotNull [] getChildren() {
            if (NO_CHILDREN == null) {
                VersionNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$VersionNode", "getChildren"));
        }
    }

    static class GemNode
    extends RenderedNode {
        private final SimpleNode[] myChildren;

        protected GemNode(List<GemInfo> gems) {
            super(gems.get(0), gems.size() > 1);
            if (gems.size() == 1) {
                this.myChildren = NO_CHILDREN;
            } else {
                ArrayList<VersionNode> versions = new ArrayList<VersionNode>();
                gems.sort(Comparator.comparing(GemInfo::getName));
                for (GemInfo gem : gems) {
                    VersionNode versionNode = new VersionNode(gem);
                    versions.add(versionNode);
                }
                versions.sort((o1, o2) -> VersionComparatorUtil.compare((String)o2.getGemVersion(), (String)o1.getGemVersion()));
                this.myChildren = versions.toArray(new SimpleNode[0]);
            }
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                GemNode.$$$reportNull$$$0(0);
            }
            return this.myChildren;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/gem/ui/RubySdkGemsConfigurableBase$GemNode", "getChildren"));
        }
    }
}

