/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;

public final class GemUiUtil {
    private static final Comparator<String> COMPARATOR = Collections.reverseOrder((o1, o2) -> VersionComparatorUtil.compare((String)o1, (String)o2));

    private GemUiUtil() {
    }

    @NlsSafe
    public static String buildInvalidGemsText(Sdk sdk, boolean hasRubyGemsSupport) {
        HtmlChunk.Element text = HtmlChunk.tag((String)"left");
        if (!hasRubyGemsSupport) {
            text = text.addText(RBundle.message((String)"gems.not.installed.for.sdk", (Object[])new Object[]{sdk.getName()}));
            text = text.child((HtmlChunk)RBundle.link((String)"https://rubygems.org/", (String)"gems.not.installed.for.sdk.install.link.text"));
        } else {
            text = text.addText(RBundle.message((String)"sdk.error.home.path.doesnt.exists", (Object[])new Object[]{sdk.getHomePath(), sdk.getName()}));
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", "red").child((HtmlChunk)text)).wrapWithHtmlBody().toString();
    }

    @NotNull
    @NlsSafe
    private static String wrapWithHtmlBodyRedFontLeft(HtmlChunk ... chunks) {
        if (chunks == null) {
            GemUiUtil.$$$reportNull$$$0(0);
        }
        String string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", "red").child((HtmlChunk)HtmlChunk.tag((String)"left").children(chunks))).wrapWithHtmlBody().toString();
        if (string == null) {
            GemUiUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void showInstallErrors(@Nullable Module module, Map<GemDependency, String> errors) {
        GemUiUtil.showInstallErrors(module == null ? null : module.getProject(), errors);
    }

    public static void showInstallErrors(@Nullable Project project, Map<GemDependency, String> errors) {
        String text = GemUiUtil.buildInstallErrorsText(errors);
        if (text != null) {
            Messages.showErrorDialog((Project)project, (String)text, (String)RBundle.message((String)"gems.gem.installing.failed"));
        }
    }

    @NlsContexts.PopupContent
    @Nullable
    public static String buildInstallErrorsText(Map<GemDependency, String> errors) {
        if (!errors.isEmpty()) {
            boolean nativeCompilationFailed = false;
            StringBuilder builder2 = new StringBuilder();
            builder2.append(RBundle.message((String)"gems.gem.installing.failed.list")).append("\n");
            for (Map.Entry<GemDependency, String> entry : errors.entrySet()) {
                GemDependency key = entry.getKey();
                String value = entry.getValue();
                builder2.append(key.getDescription());
                if (value.contains("Failed to build gem native extension") || value.contains("native gem requires installed build tools")) {
                    nativeCompilationFailed = true;
                }
                builder2.append(": ").append(value).append("\n");
            }
            if (SystemInfo.isWindows && nativeCompilationFailed) {
                builder2.insert(0, "<html><body>");
                String devKitLink = "<a href=\"https://github.com/oneclick/rubyinstaller/wiki/Development-Kit\">DevKit</a>";
                builder2.append("<br>").append(RBundle.message((String)"popup.context.compilation.failed.ruby.devkit", (Object[])new Object[]{devKitLink})).append("\n");
                builder2.append("</body></html>");
                @NlsSafe String errorText = builder2.toString().replace("\n", "<br>");
                return errorText;
            }
            @NlsSafe String errorText = builder2.toString();
            return errorText;
        }
        return null;
    }

    public static CollectionComboBoxModel<String> buildGemVersionsModel(@NotNull List<? extends GemInfo> gems, @Nullable String customFirstItem) {
        if (gems == null) {
            GemUiUtil.$$$reportNull$$$0(2);
        }
        return GemUiUtil.buildGemVersionsModel(gems, customFirstItem, false, null);
    }

    public static CollectionComboBoxModel<String> buildGemVersionsModel(@NotNull List<? extends GemInfo> gems, @Nullable String customFirstItem, boolean addSeparatorAfterCustomItem, @Nullable String valueToSelect) {
        if (gems == null) {
            GemUiUtil.$$$reportNull$$$0(3);
        }
        List versions = gems.stream().map(gem -> gem.getVersion()).distinct().sorted(COMPARATOR).collect(Collectors.toList());
        if (customFirstItem != null) {
            versions.add(0, customFirstItem);
            if (addSeparatorAfterCustomItem) {
                versions.add(1, "!!!separator!!!");
            }
        }
        if (valueToSelect == null || !versions.contains(valueToSelect)) {
            valueToSelect = !versions.isEmpty() ? (String)versions.get(0) : null;
        }
        return new CollectionComboBoxModel(versions, (Object)valueToSelect);
    }

    public static void showNoSdkInstallError(Project project) {
        Messages.showErrorDialog((Project)project, (String)RBundle.message((String)"gems.gem.installing.failed.no.sdk"), (String)RBundle.message((String)"gems.gem.installing.failed"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/GemUiUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/GemUiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithHtmlBodyRedFontLeft";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithHtmlBodyRedFontLeft";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildGemVersionsModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

