/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EDT;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerService;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

@Service(value={Service.Level.PROJECT})
public final class RubyMissingGemsNotificationService
implements Disposable.Default {
    private final Project myProject;
    private final List<Module> myModulesWithMissingGems;
    private final AtomicBoolean myNotificationCreated;

    public RubyMissingGemsNotificationService(@NotNull Project project) {
        if (project == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(0);
        }
        this.myModulesWithMissingGems = Collections.synchronizedList(new ArrayList());
        this.myNotificationCreated = new AtomicBoolean(false);
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                RubyMissingGemsNotificationService.this.myModulesWithMissingGems.remove(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/gem/module/RubyMissingGemsNotificationService$1";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static RubyMissingGemsNotificationService getInstance(@NotNull Project project) {
        if (project == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(1);
        }
        RubyMissingGemsNotificationService rubyMissingGemsNotificationService = (RubyMissingGemsNotificationService)project.getService(RubyMissingGemsNotificationService.class);
        if (rubyMissingGemsNotificationService == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(2);
        }
        return rubyMissingGemsNotificationService;
    }

    public void notifyMissingGems() {
        if (!this.myNotificationCreated.get()) {
            new MyNotification(this.myProject, this.myModulesWithMissingGems).notify(this.myProject);
            this.myNotificationCreated.set(true);
        }
    }

    public void tryExpire() {
        List<MyNotification> notifications = RubyMissingGemsNotificationService.getNotifications(this.myProject);
        if (notifications.isEmpty()) {
            return;
        }
        List<Module> modules = this.myModulesWithMissingGems.isEmpty() ? Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()) : List.copyOf(this.myModulesWithMissingGems);
        List modulesWithNoMissingGems = ContainerUtil.filter(modules, module -> !RubyMissingGemsNotificationService.hasMissingGems(module));
        if (modulesWithNoMissingGems.size() == modules.size()) {
            notifications.forEach(Notification::expire);
            this.myModulesWithMissingGems.clear();
            this.myNotificationCreated.set(false);
        } else {
            this.myModulesWithMissingGems.removeAll(modulesWithNoMissingGems);
        }
    }

    @NotNull
    private static List<MyNotification> getNotifications(@NotNull Project project) {
        if (project == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(3);
        }
        List<MyNotification> list = List.of((MyNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyNotification.class, project));
        if (list == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void installMissingGems(@NotNull List<Module> currentModulesWithMissingGems) {
        if (currentModulesWithMissingGems == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(5);
        }
        Module module = currentModulesWithMissingGems.get(0);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        ModuleGemInfrastructure infrastructure = ModuleGemInfrastructure.getInstance(module);
        if (currentModulesWithMissingGems.size() <= 1) {
            infrastructure.installMissing(sdk, () -> {
                if (module.isDisposed()) {
                    return;
                }
                RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
                if (EDT.isCurrentThreadEdt()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> infrastructure.hasMissingGems(sdk));
                } else {
                    infrastructure.hasMissingGems(sdk);
                }
            });
        } else {
            infrastructure.installMissing(sdk, () -> {
                if (module.isDisposed()) {
                    return;
                }
                RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
                currentModulesWithMissingGems.remove(0);
                if (EDT.isCurrentThreadEdt()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> infrastructure.hasMissingGems(sdk));
                } else {
                    infrastructure.hasMissingGems(sdk);
                }
                RubyMissingGemsNotificationService.installMissingGems(currentModulesWithMissingGems);
            });
        }
    }

    private static boolean hasMissingGems(@NotNull Module module) {
        VirtualFile gemfile;
        if (module == null) {
            RubyMissingGemsNotificationService.$$$reportNull$$$0(6);
        }
        return (gemfile = BundlerUtil.getGemfile(module)) != null && BundlerGemInfrastructure.hasMissingGems(gemfile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/module/RubyMissingGemsNotificationService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModulesWithMissingGems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/RubyMissingGemsNotificationService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNotifications";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installMissingGems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingGems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyNotification
    extends Notification {
        private MyNotification(final @NotNull Project project, final @NotNull List<Module> modulesWithMissingGems) {
            if (project == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (modulesWithMissingGems == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            super("Gem Manager: Missing Gems", RBundle.message((String)"gems.requirements.missing.title"), XmlStringUtil.wrapInHtml((CharSequence)RBundle.message((String)"gems.requirements.missing.for.project")), NotificationType.WARNING);
            this.setImportantSuggestion(true);
            this.setSuggestionType(true);
            String actionText = BundlerService.getInstance(project).isUseDefaultArguments() ? RBundle.message((String)"gems.requirements.missing.action.install") : RBundle.message((String)"gems.requirements.missing.action.install.with.pop.up");
            this.addAction((AnAction)new DumbAwareAction(actionText){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    LinkedList<Module> currentModulesWithMissingGems;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((currentModulesWithMissingGems = new LinkedList<Module>(ContainerUtil.filter(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()), RubyMissingGemsNotificationService::hasMissingGems))).isEmpty()) {
                        RubyMissingGemsNotificationService.getNotifications(project).forEach(Notification::expire);
                        return;
                    }
                    RubyMissingGemsNotificationService.installMissingGems(currentModulesWithMissingGems);
                    modulesWithMissingGems.addAll(currentModulesWithMissingGems);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/module/RubyMissingGemsNotificationService$MyNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modulesWithMissingGems";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/module/RubyMissingGemsNotificationService$MyNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

