/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.isolate;

import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.module.RakeBasedGemInfrastructure;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public final class IsolateGemInfrastructure
extends RakeBasedGemInfrastructure {
    private static final String ISOLATE_FILE = "Isolate";
    private static final String CONFIG_ISOLATE_FILE = "config/isolate.rb";

    @Override
    public boolean isApplicable(Module module) {
        return Experiments.getInstance().isFeatureEnabled("ruby.legacy.isolate.support") && IsolateGemInfrastructure.getIsolateFile(module) != null;
    }

    @Override
    protected String getRakeTaskName() {
        return "isolate:env";
    }

    @Nullable
    public static RFile getIsolateFile(Module module) {
        if (module == null || module.isDisposed()) {
            return null;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiFile psiFile;
            for (VirtualFile file : root.getChildren()) {
                PsiFile psiFile2;
                if (!IsolateGemInfrastructure.isIsolate(file) || !((psiFile2 = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)module.getProject()).findFile(file))) instanceof RFile)) continue;
                return (RFile)psiFile2;
            }
            VirtualFile file = root.findFileByRelativePath(CONFIG_ISOLATE_FILE);
            PsiFile psiFile3 = psiFile = file != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)module.getProject()).findFile(file)) : null;
            if (!(psiFile instanceof RFile)) continue;
            return (RFile)psiFile;
        }
        return null;
    }

    public static boolean isIsolate(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && ISOLATE_FILE.equalsIgnoreCase(file.getNameWithoutExtension());
    }
}

