/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.inspection.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;

public class InstallGemQuickFix
implements LocalQuickFix {
    private final Sdk mySdk;
    private final Module myModule;
    private final GemDependency myRequirement;

    public InstallGemQuickFix(Sdk sdk, Module module, GemDependency requirement) {
        this.mySdk = sdk;
        this.myModule = module;
        this.myRequirement = requirement;
    }

    @NotNull
    public String getName() {
        String url = this.myRequirement.getUrl();
        String name = this.myRequirement.getName();
        if (url == null) {
            String string = RBundle.message((String)"gems.inspection.try.to.install", (Object[])new Object[]{name});
            if (string == null) {
                InstallGemQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = RBundle.message((String)"gems.inspection.try.to.install.from", (Object[])new Object[]{name, url});
        if (string == null) {
            InstallGemQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"gems.gems");
        if (string == null) {
            InstallGemQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            InstallGemQuickFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            InstallGemQuickFix.$$$reportNull$$$0(4);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            InstallGemQuickFix.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            InstallGemQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            InstallGemQuickFix.$$$reportNull$$$0(7);
        }
        if (this.mySdk == null) {
            GemUiUtil.showNoSdkInstallError(project);
            return;
        }
        HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
        Runnable callback = () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            RubySdkGemLibraryManager.getInstance().refreshRoots(this.mySdk);
        };
        GemInstallUtil.installGemsInBackground(this.mySdk, this.myModule, Collections.singletonList(this.myRequirement), new GemInstallCommandOptions().withNoDocument(), GemInstallProcessOptions.installMissingOnlyAsync(errors).withCallback(callback));
        ApplicationManager.getApplication().invokeLater(() -> GemUiUtil.showInstallErrors(project, (Map<GemDependency, String>)errors));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/inspection/quickfixes/InstallGemQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/inspection/quickfixes/InstallGemQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

