/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.gem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public final class GemCompatibilityUtil {
    private static final Logger LOG = Logger.getInstance(GemCompatibilityUtil.class);
    @TestOnly
    private static final String MAX_TEST_RAILS_VERSION_PROPERTY = "ruby.integration.test.max.rails.version";
    @TestOnly
    private static final String MAX_TEST_RAILS_VERSION = System.getProperty("ruby.integration.test.max.rails.version");
    private static final MultiMap<String, Constraint> CONSTRAINTS = new MultiMap();

    @Nullable
    public static String getTopCompatibleVersion(@NotNull Sdk sdk, @NotNull String gemName) {
        String versionString;
        if (sdk == null) {
            GemCompatibilityUtil.$$$reportNull$$$0(0);
        }
        if (gemName == null) {
            GemCompatibilityUtil.$$$reportNull$$$0(1);
        }
        if ((versionString = sdk.getVersionString()) == null) {
            return null;
        }
        return GemCompatibilityUtil.getTopCompatibleVersion(RubyVersionUtil.getShortVersion(versionString), gemName);
    }

    @Nullable
    private static String getTopCompatibleVersion(@NotNull String rubyVersion, @NotNull String gemName) {
        if (rubyVersion == null) {
            GemCompatibilityUtil.$$$reportNull$$$0(2);
        }
        if (gemName == null) {
            GemCompatibilityUtil.$$$reportNull$$$0(3);
        }
        String maxAvailable = null;
        boolean hasUnavailable = false;
        for (Constraint constraint : CONSTRAINTS.get((Object)gemName)) {
            if (!constraint.satisfies(rubyVersion)) {
                hasUnavailable = true;
                continue;
            }
            if (maxAvailable != null && VersionComparatorUtil.compare((String)maxAvailable, (String)constraint.maxGemVersion) >= 0) continue;
            maxAvailable = constraint.maxGemVersion;
        }
        String topCompatibleVersion = !hasUnavailable || maxAvailable == null ? null : maxAvailable;
        LOG.debug("Detected compatibility for " + gemName + "; ruby version " + rubyVersion + "; as " + topCompatibleVersion);
        return topCompatibleVersion;
    }

    @TestOnly
    @NotNull
    public static String getMaxTestRailsVersion() {
        if (StringUtil.isEmpty((String)MAX_TEST_RAILS_VERSION)) {
            throw new RuntimeException("You must set max rails version for integration tests using property: ruby.integration.test.max.rails.version");
        }
        String string = MAX_TEST_RAILS_VERSION;
        if (string == null) {
            GemCompatibilityUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    static {
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "0", "2.3.18"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "1.8.7", "3.2.22.5"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "1.9.3", "4.2.11.3"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "2.2.2", "5.2.8.1"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "2.5.0", "6.1.7.10"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "2.7.0", "7.1.5.1"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "3.1.0", "7.2.2.1"));
        CONSTRAINTS.putValue((Object)"rails", (Object)new Constraint(">=", "3.2.0", "8.0.1"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxTestRailsVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTopCompatibleVersion";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class Constraint {
        private final GemDependency.Bound rubyVersionBound;
        private final String rubyVersion;
        private final String maxGemVersion;

        private Constraint(@NotNull String rubyVersionBound, @NotNull String rubyVersion, @NotNull String maxGemVersion) {
            if (rubyVersionBound == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            if (rubyVersion == null) {
                Constraint.$$$reportNull$$$0(1);
            }
            if (maxGemVersion == null) {
                Constraint.$$$reportNull$$$0(2);
            }
            this.rubyVersionBound = GemDependency.Bound.getBound(rubyVersionBound);
            this.rubyVersion = rubyVersion;
            this.maxGemVersion = maxGemVersion;
        }

        private boolean satisfies(@NotNull String rubyVersion) {
            if (rubyVersion == null) {
                Constraint.$$$reportNull$$$0(3);
            }
            return GemDependency.compareVersions(rubyVersion, this.rubyVersion, this.rubyVersionBound);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyVersionBound";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyVersion";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxGemVersion";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemCompatibilityUtil$Constraint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "satisfies";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

