/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public class InstallBundlerAction
extends DumbAwareAction {
    public InstallBundlerAction() {
        this.getTemplatePresentation().setIcon(RubyIcons.Ruby.RubyScript);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallBundlerAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(InstallBundlerAction.isAvailable(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            InstallBundlerAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallBundlerAction.$$$reportNull$$$0(2);
        }
        BundlerUtil.installBundler(RModuleUtil.getInstance().getModule(e.getDataContext()), InstallBundlerAction.getEffectiveRubySdk(e));
    }

    @Nullable
    private static Sdk getEffectiveRubySdk(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallBundlerAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        return module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : InstallBundlerAction.getProjectRubySdk(dataContext);
    }

    private static boolean isAvailable(@NotNull AnActionEvent e) {
        Sdk sdkToSearch;
        if (e == null) {
            InstallBundlerAction.$$$reportNull$$$0(4);
        }
        if ((sdkToSearch = InstallBundlerAction.getEffectiveRubySdk(e)) == null) {
            return false;
        }
        GemInfo bundlerGem = (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(sdkToSearch, "bundler"));
        return bundlerGem == null || !bundlerGem.isValid();
    }

    @Nullable
    private static Sdk getProjectRubySdk(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            InstallBundlerAction.$$$reportNull$$$0(5);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return null;
        }
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return sdk != null && sdk.getSdkType() instanceof RubySdkType ? sdk : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/actions/InstallBundlerAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/actions/InstallBundlerAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveRubySdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRubySdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

