/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerActionType;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerAdditionalOptionsDialog;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerService;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class AbstractBundlerAction
extends DumbAwareAction {
    private static String ourBundlerOptions = null;
    protected static final Logger LOG = Logger.getInstance(AbstractBundlerAction.class);
    @Nullable
    private Computable<Boolean> myPreFlightAction;
    @Nullable
    private Runnable myPostFlightAction;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractBundlerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractBundlerAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        GemInfo gem = RubyGemSearchUtil.findGem(module, sdk, "bundler");
        LOG.debug("Look for a bundler in the context of ", new Object[]{module, "; ", sdk, " got ", gem});
        e.getPresentation().setEnabledAndVisible(module != null && gem != null && this.isEnabled(module, gem));
    }

    protected abstract boolean isEnabled(Module var1, GemInfo var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractBundlerAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        this.runBundlerAction(module);
    }

    public void runBundlerAction(@Nullable Module module) {
        BundlerAdditionalOptionsDialog dialog;
        Project project;
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        Project project2 = project = module != null ? module.getProject() : null;
        if (sdk == null) {
            LOG.debug("No sdk found for a module: ", new Object[]{module});
            new Notification("Gem Manager", RBundle.message((String)"bundler.action.no.sdk.title"), RBundle.message((String)"bundler.action.no.sdk.message"), NotificationType.INFORMATION).notify(project);
            return;
        }
        if (!AbstractBundlerAction.checkBundlerVersion(module, sdk, project)) {
            return;
        }
        boolean isOk = true;
        String additionalArguments = (String)ObjectUtils.notNull((Object)ourBundlerOptions, (Object)"");
        if (this.hasAdditionalOptions() && !ApplicationManager.getApplication().isUnitTestMode() && !BundlerService.getInstance(project).isUseDefaultArguments() && (isOk = (dialog = new BundlerAdditionalOptionsDialog(project, module, this.getActionType())).showAndGet())) {
            additionalArguments = dialog.getAdditionalArguments();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && BundlerService.getInstance(project).isUseDefaultArguments()) {
            additionalArguments = BundlerService.getInstance(project).getDefaultArguments();
        }
        if (isOk) {
            if (this.myPreFlightAction != null) {
                boolean isSucceeded = (Boolean)this.myPreFlightAction.compute();
                this.myPreFlightAction = null;
                if (!isSucceeded) {
                    return;
                }
            }
            Runnable callback = () -> {
                Runnable postFlightAction = this.getPostFlightAction(module);
                if (postFlightAction != null) {
                    postFlightAction.run();
                    this.setPostFlightAction(null);
                }
            };
            GemRunner.bundle(module, sdk, this.getActionType().getCommand(), null, null, callback, additionalArguments);
        }
    }

    private static boolean checkBundlerVersion(@NotNull Module module, @NotNull Sdk sdk, @Nullable Project project) {
        GemDependency expected;
        GemInfo actual;
        if (module == null) {
            AbstractBundlerAction.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            AbstractBundlerAction.$$$reportNull$$$0(4);
        }
        GemInfo gemInfo = actual = (expected = BundlerGitLockReader.getInstance(module).getDependency("bundler")) != null ? RubyGemSearchUtil.findGem(module, sdk, expected) : RubyGemSearchUtil.findGem(module, sdk, "bundler");
        if (expected == null && actual != null || expected != null && actual != null && expected.isSatisfied(actual)) {
            return true;
        }
        String[] options = new String[]{RBundle.message((String)"bundler.action.update.old.bundler"), RBundle.message((String)"bundler.action.cancel")};
        if (Registry.is((String)"bundler.continue.option")) {
            options = ArrayUtil.mergeArrays((String[])options, (String[])new String[]{RBundle.message((String)"bundler.action.continue")});
        }
        if (project != null && BundlerService.getInstance(project).isAlwaysInstallRequestedVersion()) {
            return AbstractBundlerAction.updateBundler(sdk, module, expected);
        }
        int code = Messages.showDialog((Project)project, (String)RBundle.message((String)"bundler.action.dialog.old.version", (Object[])new Object[]{expected != null ? expected.getVersionString() : ">=0"}), (String)RBundle.message((String)"bundler.action.update.old.bundler"), (String[])options, (int)0, (Icon)Messages.getQuestionIcon());
        return code == 2 || code == 0 && AbstractBundlerAction.updateBundler(sdk, module, expected);
    }

    private static boolean updateBundler(Sdk sdk, Module module, GemDependency expected) {
        HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
        GemInstallUtil.installGemsInBackground(sdk, module, Collections.singletonList(expected), new GemInstallCommandOptions().withNoDocument(), GemInstallProcessOptions.updateExistingSync(errors));
        String errorsText = GemUiUtil.buildInstallErrorsText(errors);
        if (errorsText != null) {
            LOG.warn(errorsText);
            new Notification("Gem Manager", RBundle.message((String)"bundler.action.no.sdk.title"), RBundle.message((String)"bundler.action.update.failed"), NotificationType.WARNING).notify(module.getProject());
            return false;
        }
        return true;
    }

    protected boolean hasAdditionalOptions() {
        return false;
    }

    @Nullable
    protected Runnable getPostFlightAction(@Nullable Module module) {
        return this.myPostFlightAction;
    }

    public void setPreFlightAction(@Nullable Computable<Boolean> preFlightAction) {
        this.myPreFlightAction = preFlightAction;
    }

    public void setPostFlightAction(@Nullable Runnable postFlightAction) {
        this.myPostFlightAction = postFlightAction;
    }

    @NonNls
    @NotNull
    public abstract BundlerActionType getActionType();

    @TestOnly
    public static void doWithBundlerOptions(@NotNull Runnable runnable, @Nullable String bundlerOptions) {
        if (runnable == null) {
            AbstractBundlerAction.$$$reportNull$$$0(5);
        }
        ourBundlerOptions = bundlerOptions;
        try {
            runnable.run();
        }
        finally {
            ourBundlerOptions = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/actions/AbstractBundlerAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/actions/AbstractBundlerAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkBundlerVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doWithBundlerOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

