/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerExecSettingsEditor;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingProjectCollector;

public final class BundlerRunConfigurationExtension
extends RubyRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(BundlerRunConfigurationExtension.class);
    @NonNls
    private static final String ID = "BundlerRunConfigurationExtension";

    @Nullable
    static <T extends AbstractRubyRunConfiguration<?>> GemInfo getBundlerGem(T configuration, boolean execution) {
        return BundlerUtil.getBundlerGem(configuration.getSdk(), configuration.shouldUseAlternativeSdk() ? null : configuration.getModule(), execution);
    }

    @NotNull
    protected String getSerializationId() {
        return ID;
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (element == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        BundleExecSettings.putTo(runConfiguration, BundleExecSettings.readExternal(element));
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (element == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        BundleExecSettings.getFrom(runConfiguration).writeExternal(element);
    }

    protected <T extends AbstractRubyRunConfiguration<?>> SettingsEditor<T> createEditor(@NotNull T configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        return new BundlerExecSettingsEditor();
    }

    protected String getEditorTitle() {
        return RBundle.message((String)"run.configuration.extension.bundler.editorTitle");
    }

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        return true;
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration applicableConfiguration, RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        BundleExecSettings config = BundleExecSettings.getFrom(applicableConfiguration);
        if (config.myUsingBundleMode == BundleExecSettings.UsingBundleMode.DISABLE) {
            LOG.debug("Bundle exec is disabled in settings. Can't apply bundle exec.");
            return false;
        }
        Module module = applicableConfiguration.getModule();
        if (module == null) {
            LOG.debug("Module is null. Can't apply bundle exec.");
            return false;
        }
        return config.myUsingBundleMode == BundleExecSettings.UsingBundleMode.AUTO && BundlerUtil.isBundlerRuntimeEmulationEnabled(module);
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (cmdLine == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (runnerId == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (!configuration.isBundlerContextAllowed()) {
            return;
        }
        BundlerUtil.getBundlerPreprocessor(configuration.getSdk(), configuration.getModule(), runnerId, runnerSettings, configuration.shouldUseAlternativeSdk()).preprocess(cmdLine);
    }

    protected void extendTemplateConfiguration(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        BundleExecSettings.putTo(configuration, BundleExecSettings.createSettings(BundleExecSettings.UsingBundleMode.AUTO, true));
    }

    protected void attachToProcess(@NotNull AbstractRubyRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(12);
        }
    }

    @Override
    public void logConfigurationSettingsChange(@NotNull AbstractRubyRunConfiguration<?> oldRunConfiguration, @NotNull AbstractRubyRunConfiguration<?> newRunConfiguration) {
        if (oldRunConfiguration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        if (newRunConfiguration == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (oldRunConfiguration.getClass() == newRunConfiguration.getClass() && this.isApplicableFor(oldRunConfiguration) && this.isApplicableFor(newRunConfiguration)) {
            BundleExecSettings oldBundlerSettings = BundleExecSettings.getFrom(oldRunConfiguration);
            BundleExecSettings newBundlerSettings = BundleExecSettings.getFrom(newRunConfiguration);
            BundleExecSettings.UsingBundleMode oldUsingBundleMode = oldBundlerSettings.myUsingBundleMode;
            BundleExecSettings.UsingBundleMode newUsingBundleMode = newBundlerSettings.myUsingBundleMode;
            if (oldUsingBundleMode != newUsingBundleMode) {
                RubyRunConfigurationSettingChangesCollector.logUsingBundleModeChange(oldRunConfiguration.getType(), oldUsingBundleMode, newUsingBundleMode);
            }
        }
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull MetricEvent> logConfigurationSettings(@NotNull @NotNull List<@NotNull AbstractRubyRunConfiguration<?>> runConfigurationList) {
        if (runConfigurationList == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        ArrayList<Pair> configuredUsingBundleModeData = new ArrayList<Pair>();
        for (AbstractRubyRunConfiguration<?> configuration : runConfigurationList) {
            if (!this.isApplicableFor(configuration)) continue;
            configuredUsingBundleModeData.add(new Pair(configuration.getType().getClass(), (Object)BundleExecSettings.getFrom(configuration).myUsingBundleMode));
        }
        Set<MetricEvent> set = configuredUsingBundleModeData.stream().collect(Collectors.groupingBy(data -> data, Collectors.counting())).entrySet().stream().map(entry -> RubyRunConfigurationSettingProjectCollector.CONFIGURED_USING_BUNDLE_MODE.metric((Object)((Long)entry.getValue()).intValue(), (Object)((Class)((Pair)entry.getKey()).getFirst()), (Object)((BundleExecSettings.UsingBundleMode)((Object)((Object)((Pair)entry.getKey()).getSecond()))))).collect(Collectors.toSet());
        if (set == null) {
            BundlerRunConfigurationExtension.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRunConfiguration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationList";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerRunConfigurationExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerRunConfigurationExtension";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "logConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extendTemplateConfiguration";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettingsChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettings";
                break;
            }
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

