/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.bundler.actions.AbstractBundlerAction;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerService;
import org.jetbrains.plugins.ruby.gem.module.GemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.configuration.RubySharedProjectSettings;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.security.RubyTrustedProjectService;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class BundlerGemInfrastructure
extends GemInfrastructure {
    private static final Key<Boolean> GEMFILE_HAS_MISSING_GEMS = Key.create((String)"GEMFILE_HAS_MISSING_GEMS");
    public static final String GEMFILE_HAS_MISSING_GEMS_ID = "GEMFILE_HAS_MISSING_GEMS";
    private static final Logger LOG = Logger.getInstance(BundlerGemInfrastructure.class);
    @NonNls
    private static final String BUNDLE_CHECK_COMMAND = "check";
    @NonNls
    private static final String BUNDLE_DRY_RUN_OPTION = "--dry-run";

    @Override
    public boolean isApplicable(Module module) {
        return BundlerUtil.hasGemfile(module);
    }

    @Override
    public GemDependencyResolver getDependencyResolver(@NotNull Module module, Collection<GemInfo> sdkGems, Set<@NotNull GemDependency> dependencies) {
        BundlerGitLockReader reader;
        if (module == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(0);
        }
        if (!(reader = BundlerGitLockReader.getInstance(module)).isLocked()) {
            return super.getDependencyResolver(module, sdkGems, dependencies);
        }
        HashMap<String, @NotNull GemDependency> allDependencies = new HashMap<String, GemDependency>(reader.getDependencies());
        for (GemDependency dependency : dependencies) {
            if (allDependencies.containsKey(dependency.getName())) continue;
            allDependencies.put(dependency.getName(), dependency);
        }
        return new BundlerGemDependencyResolver(module, sdkGems, new HashSet<GemDependency>(allDependencies.values()));
    }

    @Override
    protected void runInstall(@NotNull Module module, Sdk sdk, Collection<GemDependency> dependencies, Runnable callback) {
        AnAction action;
        if (module == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(1);
        }
        GemInfo gem = RubyGemSearchUtil.findGem(module, sdk, "bundler");
        LOG.debug("Checked for bundler gem in context of: ", new Object[]{module, "; ", sdk, " got ", gem});
        if (gem == null) {
            boolean shouldInstallBundler = BundlerService.getInstance(module.getProject()).isAlwaysInstallRequestedVersion();
            if (!shouldInstallBundler) {
                int result = Messages.showYesNoDialog((Project)module.getProject(), (String)RBundle.message((String)"bundler.gem.not.found.install.missing.dialog.message"), (String)RBundle.message((String)"bundler.gem.not.found.install.missing.dialog.title"), (Icon)Messages.getQuestionIcon());
                LOG.debug("User chosen for bundler installation dialog: " + result);
                boolean bl = shouldInstallBundler = result == 0;
            }
            if (shouldInstallBundler) {
                LOG.debug("Running bundler installation");
                if (!BundlerUtil.installBundler(module, sdk)) {
                    LOG.debug("Bundler installation was not successful");
                    return;
                }
                LOG.debug("Bundler was installed");
            }
        }
        if ((action = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction")) instanceof AbstractBundlerAction) {
            AbstractBundlerAction bundlerAction = (AbstractBundlerAction)action;
            bundlerAction.setPostFlightAction(callback);
        }
        AnActionEvent e = AnActionEvent.createEvent((AnAction)action, (DataContext)SimpleDataContext.getSimpleContext((DataKey)PlatformCoreDataKeys.MODULE, (Object)module), null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, null);
        ActionUtil.performAction((AnAction)action, (AnActionEvent)e);
    }

    @Override
    public Boolean hasMissingGems(@Nullable Sdk sdk, @NotNull Module module, boolean inspectionMode) {
        Sdk freshModuleSdk;
        Application app;
        boolean headlessMode;
        if (module == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(2);
        }
        if (!(headlessMode = (app = ApplicationManager.getApplication()).isHeadlessEnvironment()) && !app.isDispatchThread()) {
            ThreadingAssertions.assertNoOwnReadAccess();
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        String script = (String)ReadAction.nonBlocking(() -> BundlerUtil.getBundlerScriptPath(sdk, module)).expireWith(RubyPluginUtil.getUnloadAwareDisposable(module)).executeSynchronously();
        if (script == null || gemFile == null) {
            LOG.debug("Bundler script or gemfile not found: script: ", new Object[]{script, "; gemFile: ", gemFile});
            return super.hasMissingGems(sdk, module, inspectionMode);
        }
        if (!inspectionMode) {
            app.invokeAndWait(() -> app.runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
        }
        if ((freshModuleSdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null || !RubySdkUtil.isRubyInterpreterExist(sdk) || !freshModuleSdk.equals(sdk)) {
            LOG.debug("Fresh module sdk is missing or invalid: ", new Object[]{freshModuleSdk});
            return null;
        }
        if (!RubyTrustedProjectService.getInstance(module).isTrusted()) {
            LOG.debug("Unable to run bundle check on untrusted project");
            return null;
        }
        String path = (String)ReadAction.nonBlocking(() -> BundlerGemInfrastructure.getBundleCheckPath(module, gemFile)).expireWith(RubyPluginUtil.getUnloadAwareDisposable(module)).executeSynchronously();
        try {
            boolean hasMissingGems;
            RubyGemExecutionContext executionContext = (RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "bundler").withGemScriptName("bundle").withModule(module)).withWorkingDirPath(path)).withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(false, "", 30))).withExecutionID(GEMFILE_HAS_MISSING_GEMS_ID);
            if (RubySharedProjectSettings.getInstance(module.getProject()).isUseDryBundleCheck()) {
                executionContext.withArguments(BUNDLE_CHECK_COMMAND, BUNDLE_DRY_RUN_OPTION);
            } else {
                executionContext.withArguments(BUNDLE_CHECK_COMMAND);
            }
            BundlerUtil.addBundlerEnvironment(executionContext.getAdditionalEnvs(), sdk, module, gemFile);
            ProcessOutput output2 = executionContext.executeScript();
            if (output2 == null) {
                LOG.warn("bundle check output is null for module: " + String.valueOf(module));
            } else if (output2.getExitCode() != 0) {
                LOG.warn("bundle check exited with non-zero status for module " + String.valueOf(module) + ": " + String.valueOf(output2));
            } else if (!output2.getStderrLines().isEmpty()) {
                LOG.warn("bundle check exited with stderr output for module " + String.valueOf(module) + ": " + String.valueOf(output2));
            }
            if (!inspectionMode) {
                app.invokeAndWait(() -> app.runWriteAction(() -> {
                    if (module.isDisposed()) {
                        return;
                    }
                    VirtualFile lockFile = BundlerUtil.getGemfileLockWithRefresh(module);
                    if (lockFile != null) {
                        lockFile.refresh(false, false);
                    } else {
                        LOG.warn("Unable to find Gemfile.lock after running bundle check in module " + String.valueOf(module));
                    }
                }));
            }
            boolean bl = hasMissingGems = output2 != null && !output2.getStdout().contains("dependencies are satisfied");
            if (hasMissingGems) {
                LOG.debug("Gems are missing because bundler said so: [exitCode = " + output2.getExitCode() + "; stdout = " + output2.getStdout() + "; stderr = " + output2.getStderr() + "]");
            }
            ApplicationManager.getApplication().invokeLater(() -> BundlerGemInfrastructure.setHasMissingGems(gemFile, hasMissingGems));
            return hasMissingGems;
        }
        catch (ExecutionException e) {
            LOG.warn("Error running bundler in module " + String.valueOf(module) + ": " + e.getMessage());
            return null;
        }
    }

    private static void setHasMissingGems(@NotNull VirtualFile gemFile, boolean hasMissingGems) {
        if (gemFile == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(3);
        }
        gemFile.putUserData(GEMFILE_HAS_MISSING_GEMS, (Object)hasMissingGems);
    }

    public static boolean hasMissingGems(@NotNull VirtualFile virtualFile) {
        Boolean result;
        if (virtualFile == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(4);
        }
        return (result = (Boolean)GEMFILE_HAS_MISSING_GEMS.get((UserDataHolder)virtualFile)) != null && result != false;
    }

    @Override
    public String getMissingGemMessage(Module module) {
        BundlerGitLockReader reader = BundlerGitLockReader.getInstance(module);
        if (!reader.isLocked()) {
            return super.getMissingGemMessage(module);
        }
        return RBundle.message((String)"gems.not.activated.bundler");
    }

    @Nullable
    private static String getBundleCheckPath(@NotNull Module module, @NotNull VirtualFile gemFile) {
        if (module == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(5);
        }
        if (gemFile == null) {
            BundlerGemInfrastructure.$$$reportNull$$$0(6);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile parent = gemFile.getParent();
        String path = parent != null ? VfsUtilCore.urlToPath((String)parent.getUrl()) : null;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (path == null && contentRoots.length > 0) {
            path = contentRoots[0].getPath();
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGemInfrastructure";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencyResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runInstall";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMissingGems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setHasMissingGems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleCheckPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

