/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.util.Key;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;

public class BundleExecSettings {
    private static final Key<BundleExecSettings> BUNDLE_EXEC_SETTINGS = new Key("BundleExecSettings_new");
    @NonNls
    private static final String BUNDLE_MODE = "BUNDLE_MODE";
    @NonNls
    private static final String OLD_BUNDLE_EXEC_ENABLED = "bundleExecEnabled";
    private boolean myOldBundleExecSetting;
    private static final String myOldBundleEnumOption = "ENABLE";
    public UsingBundleMode myUsingBundleMode;

    @NotNull
    public static BundleExecSettings getFrom(@NotNull AbstractRubyRunConfiguration configuration) {
        BundleExecSettings data;
        if (configuration == null) {
            BundleExecSettings.$$$reportNull$$$0(0);
        }
        BundleExecSettings bundleExecSettings = (data = (BundleExecSettings)configuration.getCopyableUserData(BUNDLE_EXEC_SETTINGS)) != null ? data : BundleExecSettings.createSettings(UsingBundleMode.AUTO, true);
        if (bundleExecSettings == null) {
            BundleExecSettings.$$$reportNull$$$0(1);
        }
        return bundleExecSettings;
    }

    public static void putTo(AbstractRubyRunConfiguration configuration, BundleExecSettings settings) {
        configuration.putCopyableUserData(BUNDLE_EXEC_SETTINGS, settings);
    }

    public static BundleExecSettings readExternal(Element element) {
        boolean oldBundleExecEnabled = Boolean.valueOf(element.getAttributeValue(OLD_BUNDLE_EXEC_ENABLED));
        String bundleModeAttributeValue = element.getAttributeValue(BUNDLE_MODE);
        if (UsingBundleMode.AUTO.toString().equals(bundleModeAttributeValue) || myOldBundleEnumOption.equals(bundleModeAttributeValue)) {
            return BundleExecSettings.createSettings(UsingBundleMode.AUTO, true);
        }
        if (UsingBundleMode.DISABLE.toString().equals(bundleModeAttributeValue)) {
            return BundleExecSettings.createSettings(UsingBundleMode.DISABLE, false);
        }
        return BundleExecSettings.createSettings(oldBundleExecEnabled ? UsingBundleMode.AUTO : UsingBundleMode.DISABLE, oldBundleExecEnabled);
    }

    public void writeExternal(Element element) {
        element.setAttribute(BUNDLE_MODE, String.valueOf((Object)this.myUsingBundleMode));
        element.setAttribute(OLD_BUNDLE_EXEC_ENABLED, String.valueOf(this.myOldBundleExecSetting));
    }

    public static BundleExecSettings createSettings(@NotNull UsingBundleMode usingBundleMode, boolean oldSetting) {
        if (usingBundleMode == null) {
            BundleExecSettings.$$$reportNull$$$0(2);
        }
        BundleExecSettings settings = new BundleExecSettings();
        settings.myOldBundleExecSetting = oldSetting;
        settings.myUsingBundleMode = usingBundleMode;
        return settings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleExecSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingBundleMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleExecSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrom";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum UsingBundleMode {
        AUTO,
        DISABLE;

    }
}

