/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigDataService;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigListenerService;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class BundleConfigServiceImpl
implements BundleConfigService,
Disposable.Default {
    private final Map<Module, BundleConfig> myConfigs = new ConcurrentHashMap<Module, BundleConfig>();
    private final Map<Module, BundleConfig> myUserConfigs = new ConcurrentHashMap<Module, BundleConfig>();
    private final Set<VirtualFile> myGemFiles = ConcurrentCollectionFactory.createConcurrentSet();
    private final Set<Module> myHandledModules = ConcurrentCollectionFactory.createConcurrentSet();
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("update.queue", 300, true, null, (Disposable)this).usePassThroughInUnitTestMode();
    private boolean myChange = false;

    public BundleConfigServiceImpl() {
        BundleConfigDataService.getInstance();
    }

    public void queueUpdate() {
        if (this.myChange) {
            return;
        }
        this.myUpdateQueue.queue(Update.create((Object)this, () -> WriteIntentReadAction.run(() -> this.refreshConfigs())));
    }

    private void refreshConfigs() {
        HashSet<VirtualFile> oldGemFiles = this.myGemFiles.isEmpty() ? Collections.emptySet() : new HashSet<VirtualFile>(this.myGemFiles);
        this.myGemFiles.clear();
        new ArrayList<Module>(this.myHandledModules).forEach(it -> {
            this.myConfigs.remove(it);
            this.myUserConfigs.remove(it);
            if (!it.isDisposed()) {
                this.getConfig((Module)it);
                this.getUserConfig((Module)it);
            }
        });
        if (!this.myGemFiles.equals(oldGemFiles)) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                this.myChange = true;
                FileTypeManagerEx.getInstanceEx().makeFileTypesChange("Gem files changed: old " + String.valueOf(oldGemFiles) + ", new = " + String.valueOf(this.myGemFiles), EmptyRunnable.getInstance());
                this.myChange = false;
            }));
        }
    }

    private void disposeModuleData(@NotNull Module module) {
        if (module == null) {
            BundleConfigServiceImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        this.myHandledModules.remove(module);
        this.myConfigs.remove(module);
        this.myUserConfigs.remove(module);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Contract(value="null -> false")
    public boolean checkAndRegisterModule(@Nullable Module module) {
        void module2;
        ThreadingAssertions.softAssertReadAccess();
        if (module2 == null || module2.isDisposed() || !RModuleUtil.getInstance().hasRubySupport((Module)module2)) {
            return false;
        }
        if (this.myHandledModules.add((Module)module2)) {
            Disposer.register((Disposable)RubyPluginUtil.getUnloadAwareDisposable((Module)module2), () -> this.lambda$checkAndRegisterModule$5((Module)module2));
            this.getConfig((Module)module2);
            this.getUserConfig((Module)module2);
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    public BundleConfig getConfig(@Nullable Module module) {
        if (!((Boolean)ReadAction.nonBlocking(() -> this.checkAndRegisterModule(module)).executeSynchronously()).booleanValue()) {
            return null;
        }
        BundleConfig config = this.myConfigs.get(module);
        if (config != null) {
            return config;
        }
        config = this.registerGemFile(BundleConfig.createConfig(module));
        if (config == null) {
            return null;
        }
        this.myConfigs.putIfAbsent(module, config);
        return config;
    }

    private BundleConfig registerGemFile(@Nullable BundleConfig config) {
        if (config == null) {
            return null;
        }
        VirtualFile bundleGemfileVirtualFile = config.getBundleGemfileVirtualFile();
        ContainerUtil.addIfNotNull(this.myGemFiles, (Object)bundleGemfileVirtualFile);
        return config;
    }

    @Contract(value="null -> null")
    @Nullable
    public BundleConfig getUserConfig(@Nullable Module module) {
        if (!this.checkAndRegisterModule(module)) {
            return null;
        }
        BundleConfig userConfig = this.myUserConfigs.get(module);
        if (userConfig != null) {
            return userConfig;
        }
        userConfig = BundleConfig.createUserConfig(module);
        if (userConfig == null) {
            return null;
        }
        BundleConfig localConfig = this.getConfig(module);
        if (localConfig == null || localConfig.getBundleGemfileVirtualFile() == null) {
            this.registerGemFile(userConfig);
        }
        this.myUserConfigs.putIfAbsent(module, userConfig);
        return userConfig;
    }

    @Contract(value="null -> false")
    public boolean isGemFile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && this.myGemFiles.contains(virtualFile);
    }

    @NotNull
    public static BundleConfigServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            BundleConfigServiceImpl.$$$reportNull$$$0(1);
        }
        BundleConfigServiceImpl bundleConfigServiceImpl = (BundleConfigServiceImpl)BundleConfigService.getInstance((Project)project);
        if (bundleConfigServiceImpl == null) {
            BundleConfigServiceImpl.$$$reportNull$$$0(2);
        }
        return bundleConfigServiceImpl;
    }

    private /* synthetic */ void lambda$checkAndRegisterModule$5(Module module) {
        this.disposeModuleData(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disposeModuleData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static final class Starter
    implements StartupActivity {
        Starter() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Starter.$$$reportNull$$$0(0);
            }
            project.getService(BundleConfigListenerService.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigServiceImpl$Starter", "runActivity"));
        }
    }
}

