/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;

@Service
public final class BundleConfigDataService
implements VirtualFileListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(BundleConfigDataService.class);
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(\\S+):\\s*(\\S+)\\s*");
    private final Map<VirtualFile, Map<String, String>> myConfigsDataCache = new ConcurrentHashMap<VirtualFile, Map<String, String>>();

    private BundleConfigDataService() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        localFileSystem.addVirtualFileListener((VirtualFileListener)this, (Disposable)this);
        RubyFileSystemUtil.addRootToWatch(BundleConfig.PATH_TO_USER_BUNDLE_FOLDER, false, this);
    }

    public void dispose() {
    }

    @NotNull
    Map<String, String> getValues(@NotNull VirtualFile configFile) {
        Map values;
        if (configFile == null) {
            BundleConfigDataService.$$$reportNull$$$0(0);
        }
        if ((values = this.myConfigsDataCache.get(configFile)) != null) {
            Map map = values;
            if (map == null) {
                BundleConfigDataService.$$$reportNull$$$0(1);
            }
            return map;
        }
        values = (Map)ReadAction.nonBlocking(() -> BundleConfigDataService.computeConfigData(configFile)).executeSynchronously();
        if (values == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                BundleConfigDataService.$$$reportNull$$$0(2);
            }
            return map;
        }
        this.myConfigsDataCache.putIfAbsent(configFile, values);
        Map map = values;
        if (map == null) {
            BundleConfigDataService.$$$reportNull$$$0(3);
        }
        return map;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        VirtualFile virtualFile;
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(4);
        }
        if (!BundleConfig.isConfig(virtualFile = event.getFile())) {
            return;
        }
        VirtualFile userBundleConfig = VfsUtil.findFileByIoFile((File)new File(BundleConfig.PATH_TO_USER_BUNDLE_CONFIG), (boolean)false);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (virtualFile.equals(userBundleConfig)) {
                BundleConfigServiceImpl.getInstance(project).queueUpdate();
                continue;
            }
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (fileModule == null) continue;
            BundleConfigServiceImpl.getInstance(project).getConfig(fileModule);
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(5);
        }
        this.handleParent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(6);
        }
        this.removeAndRequestUpdate(event.getFile());
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(7);
        }
        this.handleParent(event);
    }

    private void removeAndRequestUpdate(@NotNull VirtualFile fileToRemove) {
        if (fileToRemove == null) {
            BundleConfigDataService.$$$reportNull$$$0(8);
        }
        this.myConfigsDataCache.remove(fileToRemove);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            BundleConfigServiceImpl.getInstance(project).queueUpdate();
        }
    }

    private void handleParent(@NotNull VirtualFileEvent event) {
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(9);
        }
        VirtualFile possibleParent = event.getFile();
        ContainerUtil.filter(new ArrayList<VirtualFile>(this.myConfigsDataCache.keySet()), it -> !it.isValid() || VfsUtilCore.isAncestor((VirtualFile)possibleParent, (VirtualFile)it, (boolean)false)).forEach(it -> this.removeAndRequestUpdate((VirtualFile)it));
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            BundleConfigDataService.$$$reportNull$$$0(10);
        }
        this.handleParent((VirtualFileEvent)event);
    }

    @Nullable
    private static Map<String, String> computeConfigData(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            BundleConfigDataService.$$$reportNull$$$0(11);
        }
        try {
            LOG.debug("Computing for " + String.valueOf(configFile));
            String text = VfsUtilCore.loadText((VirtualFile)configFile);
            HashMap values = new HashMap();
            StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)true).forEach(it -> {
                Matcher m = LINE_PATTERN.matcher((CharSequence)it);
                if (m.matches()) {
                    String value;
                    String key = m.group(1);
                    String quotedValue = m.group(2);
                    String string = value = quotedValue == null ? null : StringUtil.unquoteString((String)quotedValue);
                    if (StringUtil.isNotEmpty((String)key) && value != null) {
                        values.put(key, value);
                    }
                }
            });
            return values.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(values);
        }
        catch (IOException e) {
            LOG.error("Error reading config file " + String.valueOf(configFile), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static BundleConfigDataService getInstance() {
        BundleConfigDataService bundleConfigDataService = Objects.requireNonNull((BundleConfigDataService)ApplicationManager.getApplication().getService(BundleConfigDataService.class));
        if (bundleConfigDataService == null) {
            BundleConfigDataService.$$$reportNull$$$0(12);
        }
        return bundleConfigDataService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigDataService";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigDataService";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeAndRequestUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleParent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforeFileMovement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeConfigData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 12 -> new IllegalStateException(string);
        };
    }
}

