/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.application.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import icons.RubyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.application.GemApp;
import org.jetbrains.plugins.ruby.gem.application.actions.BuildGemDialog;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class GemActionBase
extends AnAction {
    @NotNull
    private final String myAction;
    @NlsContexts.Button
    @NotNull
    private final String myActionTitle;

    public GemActionBase(@NotNull String action, @NlsContexts.Button @NotNull String actionTitle) {
        if (action == null) {
            GemActionBase.$$$reportNull$$$0(0);
        }
        if (actionTitle == null) {
            GemActionBase.$$$reportNull$$$0(1);
        }
        this.myAction = action;
        this.myActionTitle = actionTitle;
        this.getTemplatePresentation().setIcon(RubyIcons.Ruby.Rubygems);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GemActionBase.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        VirtualFile gemspecFile = (VirtualFile)ObjectUtils.doIfNotNull((Object)GemApp.fromModule(module), GemApp::getGemspecFile);
        e.getPresentation().setEnabledAndVisible(module != null && sdk != null && gemspecFile != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GemActionBase.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Nullable
    public abstract String getFileName(@NotNull GemApp var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GemActionBase.$$$reportNull$$$0(4);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        if (module == null) {
            return;
        }
        GemApp app = GemApp.fromModule(module);
        if (app == null) {
            return;
        }
        String file = this.getFileName(app);
        if (file == null) {
            return;
        }
        BuildGemDialog dialog = new BuildGemDialog(module, this.myActionTitle);
        if (dialog.showAndGet()) {
            StringBuilder builder2 = new StringBuilder(file);
            String arguments = dialog.getAdditionalArguments();
            if (!arguments.isEmpty()) {
                builder2.append(" ").append(arguments);
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            assert (sdk != null);
            GemRunner.bundle(module, sdk, null, this.myAction, null, null, builder2.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionTitle";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/application/actions/GemActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/application/actions/GemActionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

