/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.application;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.application.BuiltGem;

public final class GemApp {
    private final Module myModule;
    private final VirtualFile myGemspecFile;

    private GemApp(@NotNull Module module) {
        if (module == null) {
            GemApp.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myGemspecFile = GemUtil.findGemspecFile(this.myModule);
    }

    @Nullable
    public BuiltGem findLastBuiltGem() {
        List<BuiltGem> gems = this.findBuiltGems();
        if (!gems.isEmpty()) {
            Collections.sort(gems);
            return gems.get(gems.size() - 1);
        }
        return null;
    }

    public List<BuiltGem> findBuiltGems() {
        ArrayList<BuiltGem> gems = new ArrayList<BuiltGem>();
        for (VirtualFile root : ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()) {
            for (VirtualFile file : root.getChildren()) {
                String extension = file.getExtension();
                if (!"gem".equals(extension)) continue;
                gems.add(new BuiltGem(file));
            }
        }
        return gems;
    }

    @Nullable
    public VirtualFile getGemspecFile() {
        return this.myGemspecFile;
    }

    @Nullable
    public static GemApp fromModule(@Nullable Module module) {
        if (module != null && GemUtil.isGemModule(module)) {
            return new GemApp(module);
        }
        return null;
    }

    public String getLibPath() {
        VirtualFile lib;
        VirtualFile baseDir = GemApp.getBaseDir(this.myModule);
        VirtualFile virtualFile = lib = baseDir != null ? baseDir.findChild("lib") : null;
        if (lib != null) {
            return lib.getPath();
        }
        return null;
    }

    private static VirtualFile getBaseDir(@NotNull Module module) {
        VirtualFile moduleFile;
        if (module == null) {
            GemApp.$$$reportNull$$$0(1);
        }
        return (moduleFile = module.getModuleFile()) != null && moduleFile.getParent() != null ? moduleFile.getParent().getParent() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/application/GemApp";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

