/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;

public class RubyGemsEnvironment {
    @NonNls
    public static final String GEM_PATHS = "GEM PATHS";
    private static final Logger LOG = Logger.getInstance(RubyGemsEnvironment.class);
    private static final RubyGemsEnvironment EMPTY_ENVIRONMENT = new RubyGemsEnvironment();
    private static final Pattern KEY_PATTERN = Pattern.compile(" {2}- ([A-Z ]+):(?:\\s+(.+))?");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\s+-\\s+(.+)");
    private static final String GEM_ENV_WITH_BUNDLE_EXEC_WITH_EMPTY_GEMFILE_COMMAND = "require 'tempfile'\nempty_gemfile = Tempfile.new('foo')\nFile.open(empty_gemfile.path, 'w') do |file| \n  file.puts 'source \"https://rubygems.org\"'\nend\nsystem(\"%s %s exec %s env\")";
    private static final String WINDOWS_BUNDLE_GEMFILE_COMMAND_PREFIX = "set BUNDLE_GEMFILE=#{empty_gemfile.path} &&";
    private static final String NOT_WINDOWS_GEMFILE_COMMAND_PREFIX = "BUNDLE_GEMFILE=#{empty_gemfile.path}";
    private static final List<String> GEM_ENV_WITH_BUNDLE_EXEC = Arrays.asList("bundle", "exec", "gem", "env");
    private final MultiMap<String, String> myParsedValues = new MultiMap();
    private static final Key<RubyGemsEnvironment> ENVIRONMENT_KEY = Key.create((String)"gem env");
    private static MultiMap<String, String> ourMockMap = null;

    private RubyGemsEnvironment() {
    }

    @Nullable
    protected String getSingleValue(@NotNull String key) {
        Collection list;
        if (key == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(0);
        }
        return (list = ((MultiMap)ObjectUtils.notNull(ourMockMap, this.myParsedValues)).get((Object)key)).isEmpty() ? null : (String)list.iterator().next();
    }

    @NotNull
    protected List<String> getListValue(@NotNull String key) {
        if (key == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(1);
        }
        List<String> list = Collections.unmodifiableList((List)((MultiMap)ObjectUtils.notNull(ourMockMap, this.myParsedValues)).get((Object)key));
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String getRubyGemsVersion() {
        return this.getSingleValue("RUBYGEMS VERSION");
    }

    @Nullable
    public String getRubyVersion() {
        return this.getSingleValue("RUBY VERSION");
    }

    @Nullable
    public String getInstallationDirectory() {
        return this.getSingleValue("INSTALLATION DIRECTORY");
    }

    @Nullable
    public String getUserInstallationDirectory() {
        return this.getSingleValue("USER INSTALLATION DIRECTORY");
    }

    @Nullable
    public String getRubyExecutable() {
        return this.getSingleValue("RUBY EXECUTABLE");
    }

    @Nullable
    public String getExecutableDirectory() {
        return this.getSingleValue("EXECUTABLE DIRECTORY");
    }

    @Nullable
    public static String getExecutableDirectory(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(3);
        }
        return RubyGemsEnvironment.get(sdk).getSingleValue("EXECUTABLE DIRECTORY");
    }

    @Nullable
    public String getSpecCacheDiretory() {
        return this.getSingleValue("SPEC CACHE DIRECTORY");
    }

    @Nullable
    public String getSystemConfigurationDirectory() {
        return this.getSingleValue("SYSTEM CONFIGURATION DIRECTORY");
    }

    @NotNull
    public List<String> getRubyGemsPlatforms() {
        List<String> list = this.getListValue("RUBYGEMS PLATFORMS");
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getGemPaths() {
        List<String> list = this.getListValue(GEM_PATHS);
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isEmpty() {
        return (ourMockMap == null || ourMockMap.isEmpty()) && this.myParsedValues.isEmpty();
    }

    @NotNull
    public static List<String> getGemPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(6);
        }
        List<String> list = RubyGemsEnvironment.get(sdk).getGemPaths();
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getGemConfiguration() {
        List<String> configuration = this.getListValue("GEM CONFIGURATION");
        Map map = ContainerUtil.map2Map(configuration, str -> {
            String[] parts = str.split(" => ");
            return Pair.create((Object)parts[0], (Object)parts[1]);
        });
        if (map == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public List<String> getRemoteSources() {
        List<String> list = this.getListValue("REMOTE SOURCES");
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<String> getShellPath() {
        List<String> list = this.getListValue("SHELL PATH");
        if (list == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static RubyGemsEnvironment get(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(11);
        }
        RubyGemsEnvironment rubyGemsEnvironment = RubyGemsEnvironment.get(sdk, null);
        if (rubyGemsEnvironment == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(12);
        }
        return rubyGemsEnvironment;
    }

    public String toString() {
        return "RubyGems environment: " + String.valueOf(this.myParsedValues);
    }

    public static RubyGemsEnvironment get(@Nullable Sdk sdk, @Nullable Module module) {
        if (sdk == null && module != null) {
            sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        }
        if (sdk == null) {
            return EMPTY_ENVIRONMENT;
        }
        RbConfig.initIfNecessary(sdk);
        RubyGemsEnvironment result = (RubyGemsEnvironment)ENVIRONMENT_KEY.get((UserDataHolder)sdk);
        if (result != null) {
            return result;
        }
        result = RubyGemsEnvironment.parse(GemRunner.getRawEnvironment(module, sdk));
        ENVIRONMENT_KEY.set((UserDataHolder)sdk, (Object)result);
        return result;
    }

    public static String getGemEnvironmentWithBundleExec(@Nullable Sdk sdk) {
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.from(sdk);
        if (sdkAdditionalData == null) {
            return null;
        }
        String interpreterPath = sdkAdditionalData.getInterpreterPath(sdk);
        try {
            String result;
            ProcessOutput processOutput = sdkAdditionalData.getRunner(null).execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(GEM_ENV_WITH_BUNDLE_EXEC).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"gems.reading.environment", (Object[])new Object[]{sdk})));
            if (processOutput != null && processOutput.getStderr().contains("GemNotFound")) {
                processOutput = null;
            }
            if ((result = GemRunner.checkGemEnvironmentOutputPresence(sdk, processOutput)) != null) {
                return result;
            }
            processOutput = sdkAdditionalData.getRunner(null).execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(interpreterPath, "-e", RubyGemsEnvironment.getBundleExecWithEmptyGemfileGemEnvCommand(sdk)).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"gems.reading.environment", (Object[])new Object[]{sdk})));
            return GemRunner.checkGemEnvironmentOutputPresence(sdk, processOutput);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to retrieve 'gem env' in the context of bundler for SDK: " + String.valueOf(sdk));
            return null;
        }
    }

    @NotNull
    private static String getBundleExecWithEmptyGemfileGemEnvCommand(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(13);
        }
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.from(sdk);
        assert (sdkAdditionalData != null);
        String binPath = RubySdkAdditionalData.getInterpreterDir(sdk);
        String gemCommandPath = GemRunner.getGemExecutableName(sdk, binPath);
        RubySdkSystemAccessor accessor = sdkAdditionalData.getSdkSystemAccessor();
        String bundlePath = binPath + accessor.getFileSeparator() + "bundle";
        if (!(sdkAdditionalData instanceof RubyRemoteSdkAdditionalData) && SystemInfo.isWindows) {
            String string = String.format(GEM_ENV_WITH_BUNDLE_EXEC_WITH_EMPTY_GEMFILE_COMMAND, WINDOWS_BUNDLE_GEMFILE_COMMAND_PREFIX, bundlePath, gemCommandPath);
            if (string == null) {
                RubyGemsEnvironment.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = String.format(GEM_ENV_WITH_BUNDLE_EXEC_WITH_EMPTY_GEMFILE_COMMAND, NOT_WINDOWS_GEMFILE_COMMAND_PREFIX, bundlePath, gemCommandPath);
        if (string == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static RubyGemsEnvironment parse(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            RubyGemsEnvironment rubyGemsEnvironment = EMPTY_ENVIRONMENT;
            if (rubyGemsEnvironment == null) {
                RubyGemsEnvironment.$$$reportNull$$$0(16);
            }
            return rubyGemsEnvironment;
        }
        RubyGemsEnvironment result = new RubyGemsEnvironment();
        String currentKey = null;
        for (String line : StringUtil.splitByLinesDontTrim((String)text)) {
            Matcher keyMatcher = KEY_PATTERN.matcher(line);
            if (keyMatcher.matches()) {
                if (keyMatcher.groupCount() > 1 && keyMatcher.group(2) != null) {
                    currentKey = null;
                    result.myParsedValues.putValue((Object)keyMatcher.group(1), (Object)keyMatcher.group(2));
                    continue;
                }
                currentKey = keyMatcher.group(1);
                continue;
            }
            Matcher valueMatcher = VALUE_PATTERN.matcher(line);
            if (currentKey == null || !valueMatcher.matches()) continue;
            result.myParsedValues.putValue((Object)currentKey, (Object)valueMatcher.group(1));
        }
        RubyGemsEnvironment rubyGemsEnvironment = result;
        if (rubyGemsEnvironment == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(17);
        }
        return rubyGemsEnvironment;
    }

    public void updateValueList(@NotNull String key, List<String> valueList) {
        if (key == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(18);
        }
        ((MultiMap)ObjectUtils.notNull(ourMockMap, this.myParsedValues)).put((Object)key, valueList);
    }

    @TestOnly
    public static void init(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(19);
        }
        ENVIRONMENT_KEY.set((UserDataHolder)sdk, (Object)MockRubyGemsEnvironment.INSTANCE);
    }

    @TestOnly
    public static void doWithMockEnvironment(@NotNull MultiMap<String, String> mockMap, @NotNull Runnable runnable) {
        if (mockMap == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(20);
        }
        if (runnable == null) {
            RubyGemsEnvironment.$$$reportNull$$$0(21);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("For tests only");
        }
        ourMockMap = mockMap;
        try {
            runnable.run();
        }
        finally {
            ourMockMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 8, 9, 10, 12, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/RubyGemsEnvironment";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/RubyGemsEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyGemsPlatforms";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleExecWithEmptyGemfileGemEnvCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getListValue";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExecutableDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGemPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleExecWithEmptyGemfileGemEnvCommand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateValueList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doWithMockEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 8, 9, 10, 12, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class MockRubyGemsEnvironment
    extends RubyGemsEnvironment {
        static final MockRubyGemsEnvironment INSTANCE = new MockRubyGemsEnvironment();

        private MockRubyGemsEnvironment() {
        }

        @Override
        @Nullable
        protected String getSingleValue(@NotNull String key) {
            if (key == null) {
                MockRubyGemsEnvironment.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @NotNull
        protected List<String> getListValue(@NotNull String key) {
            if (key == null) {
                MockRubyGemsEnvironment.$$$reportNull$$$0(1);
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                MockRubyGemsEnvironment.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/RubyGemsEnvironment$MockRubyGemsEnvironment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/RubyGemsEnvironment$MockRubyGemsEnvironment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSingleValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getListValue";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

