/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubySdkAwareExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyGemExecutionContext
extends RubySdkAwareExecutionContext<RubyGemExecutionContext> {
    private static final Logger LOG = Logger.getInstance(RubyGemExecutionContext.class);
    private static final List<String> KNOWN_TERMINALS = Arrays.asList("bash", "sh", "zsh");
    private static final String BASH_EXECUTE_DIRECTIVE = "#!";
    private static final String MACOS_BUNDLED_RUBY_FRAMEWORK_GEMS_BIN_DIR = "/usr/bin";
    private static final String BIN = "bin";
    @NotNull
    private final String myGemName;
    @Nullable
    private String myGemScriptName;
    @Nullable
    private String myGemVersion;

    public RubyGemExecutionContext(@NotNull RubyGemExecutionContext source) {
        if (source == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(0);
        }
        super(source);
        this.myGemName = source.myGemName;
        this.myGemScriptName = source.myGemScriptName;
        this.myGemVersion = source.myGemVersion;
    }

    public RubyGemExecutionContext(@NotNull Module module, @NotNull String gemName) {
        if (module == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(1);
        }
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(2);
        }
        super(module);
        this.myGemName = RubyGemExecutionContext.validateGemName(gemName);
    }

    public RubyGemExecutionContext(@NotNull Sdk sdk, @NotNull String gemName) {
        if (sdk == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(3);
        }
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(4);
        }
        super(sdk);
        this.myGemName = RubyGemExecutionContext.validateGemName(gemName);
    }

    @NotNull
    private static String validateGemName(@NotNull String gemName) {
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)gemName)) {
            throw new IllegalArgumentException("Gem name can not be empty");
        }
        String string = gemName;
        if (string == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getGemName() {
        String string = this.myGemName;
        if (string == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getGemScriptName() {
        String string = this.myGemScriptName != null ? this.myGemScriptName : this.myGemName;
        if (string == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getGemVersion() {
        return this.myGemVersion;
    }

    @NotNull
    public RubyGemExecutionContext withGemScriptName(@Nullable String gemScriptName) {
        this.myGemScriptName = gemScriptName;
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(9);
        }
        return rubyGemExecutionContext;
    }

    @NotNull
    public RubyGemExecutionContext withGemVersion(@Nullable String gemVersion) {
        this.myGemVersion = gemVersion;
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(10);
        }
        return rubyGemExecutionContext;
    }

    @Nullable
    public String getScriptPath() {
        VirtualFile gemRootBinDir;
        Sdk sdk = this.getRubySdk();
        Module module = this.getModule();
        String gemScriptName = this.getGemScriptName();
        String gemName = this.getGemName();
        String gemVersion = this.getGemVersion();
        LOG.debug("Discovering script path for ", new Object[]{this, "; sdk=", sdk, "; module=", module});
        ArrayList<Object> binaryScriptsLookupFolders = new ArrayList<Object>(4);
        ReadAction.run(() -> BundlerUtil.addBundlerBinPaths(module, binaryScriptsLookupFolders));
        LOG.debug("Bundler bin paths: ", new Object[]{binaryScriptsLookupFolders});
        if (RVMSupportUtil.isRVMInterpreter(sdk)) {
            LOG.debug("Rvm sdk processing");
            Pair<String, String> paths = RVMSupportUtil.determineMainAndGlobalGemPaths(sdk);
            if (paths != null) {
                Object globalGempath;
                String mainGemPath = (String)paths.first;
                if (mainGemPath != null) {
                    binaryScriptsLookupFolders.add(mainGemPath + "/bin");
                }
                if ((globalGempath = (String)paths.second) != null) {
                    binaryScriptsLookupFolders.add((String)globalGempath + "/bin");
                }
            }
            LOG.debug("Rvm ends with ", new Object[]{binaryScriptsLookupFolders});
        }
        String gemEnvBinFolder = RubySdkUtil.getGemsBinFolderPath(sdk);
        binaryScriptsLookupFolders.add(gemEnvBinFolder);
        LOG.debug("Added gem env bin folder: ", new Object[]{gemEnvBinFolder});
        String interpreterDir = RubySdkAdditionalData.getInterpreterDir(sdk);
        if (RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            interpreterDir = FileUtil.join((String[])new String[]{RubyRemoteSdkAdditionalData.getLocalGemsRootPath(sdk), interpreterDir});
        }
        binaryScriptsLookupFolders.add(interpreterDir);
        LOG.debug("Added local interpreter dir ", new Object[]{interpreterDir});
        for (String string : binaryScriptsLookupFolders) {
            LOG.debug("Looking for ", new Object[]{gemScriptName, " in ", string});
            String scriptPathBySdkBin = GemUtil.findExecutableRubyScriptPath(gemScriptName, string);
            if (scriptPathBySdkBin == null) continue;
            LOG.debug("Found ", new Object[]{scriptPathBySdkBin});
            return scriptPathBySdkBin;
        }
        LOG.debug("Not found in bin directories");
        GemInfo gemInfo = module != null ? RubyProjectGemSearchService.Companion.findGem(module, gemName, gemVersion) : null;
        gemInfo = gemInfo == null ? RubyGemSearchUtil.findGem(module, sdk, gemName, gemVersion) : gemInfo;
        LOG.debug("Target gem is: ", new Object[]{gemInfo});
        if (gemInfo == null || !gemInfo.isValid()) {
            LOG.debug("Null or invalid");
            return null;
        }
        VirtualFile virtualFile = gemInfo.getFile();
        assert (virtualFile != null);
        LOG.debug("Gem dir is ", new Object[]{virtualFile});
        String binDirectory = virtualFile.getParent().getParent().getPath() + "/bin";
        LOG.debug("Gem bin dir is ", new Object[]{binDirectory});
        String scriptGemsRootInBinDir = GemUtil.findExecutableRubyScriptPath(gemScriptName, binDirectory);
        if (scriptGemsRootInBinDir != null) {
            LOG.debug("Found ", new Object[]{scriptGemsRootInBinDir});
            return scriptGemsRootInBinDir;
        }
        if (RubyImplementationHandler.notNullFrom(sdk).isMacOsBundledRubySdk()) {
            LOG.debug("Checking macOS bundled Ruby");
            VirtualFile usrBinFolder = LocalFileSystem.getInstance().findFileByPath(MACOS_BUNDLED_RUBY_FRAMEWORK_GEMS_BIN_DIR);
            String macOSBundledRubyGemsBinDir = GemUtil.findScriptInBinDir(gemScriptName, usrBinFolder);
            if (macOSBundledRubyGemsBinDir != null) {
                LOG.debug("macOS bundled ruby gems bin dir: ", new Object[]{macOSBundledRubyGemsBinDir});
                return macOSBundledRubyGemsBinDir;
            }
            LOG.debug("No bundled ruby gems bin dir");
        }
        if ((gemRootBinDir = virtualFile.findChild(BIN)) != null) {
            LOG.debug("Got bin dir inside gem itself: ", new Object[]{gemRootBinDir});
            return GemUtil.findScriptInBinDir(gemScriptName, gemRootBinDir);
        }
        LOG.debug("No bin directory in the gem itself");
        Map<String, String> gemConfiguration = RubyGemsEnvironment.get(sdk).getGemConfiguration();
        String gemCommandConfiguration = gemConfiguration.getOrDefault("\"gem\"", "");
        List gemCommandArguments = ContainerUtil.map((Object[])(gemCommandConfiguration.startsWith("[") && gemCommandConfiguration.endsWith("]") ? gemCommandConfiguration.substring(1, gemCommandConfiguration.length() - 1).split(", ") : ArrayUtil.EMPTY_STRING_ARRAY), StringUtil::unquoteString);
        int bindirIndex = ContainerUtil.indexOf((List)gemCommandArguments, str -> str.equals("--bindir"));
        if (bindirIndex >= 0 && bindirIndex + 1 < gemCommandArguments.size()) {
            String bindir = (String)gemCommandArguments.get(bindirIndex + 1);
            LOG.debug("Searching in the global bindir " + bindir);
            return GemUtil.findScriptInBinDir(gemScriptName, VfsUtil.findFile((Path)Paths.get(bindir, new String[0]), (boolean)false));
        }
        LOG.debug("Nothing found");
        return null;
    }

    public String @Nullable [] getScriptExecutionCommands() throws ExecutionException {
        try {
            Sdk rubySdk = this.getRubySdk();
            RunnerUtil.validateSDK(rubySdk);
            String scriptPath = this.getScriptPath();
            if (scriptPath != null) {
                ArrayList<String> result = new ArrayList<String>();
                RubyVersionManagerHandler rubyVersionManagerHandler = RubyVersionManagerHandler.notNullFrom(rubySdk);
                if (!ShimsBasedVersionManagerHandler.is(rubyVersionManagerHandler)) {
                    result.add(RubySdkAdditionalData.getInterpreterPathFor(rubySdk));
                }
                result.add(RubySdkUtil.convertToRemote(rubySdk, this.getModule(), rubyVersionManagerHandler.getAdjustedGemScriptPathForExecution(scriptPath)));
                return ArrayUtilRt.toStringArray(result);
            }
            String msg = RBundle.message((String)"execution.error.no.executable.cmd.for.gem.name", (Object[])new Object[]{this.getGemName(), this.getGemScriptName()});
            throw new ExecutionException(msg);
        }
        catch (ExecutionException e) {
            RunnerUtil.showExecutionErrorDialog(e);
            return null;
        }
    }

    @Nullable
    public ProcessOutput executeScript() throws ExecutionException {
        RubyScriptExecutionContext executionContext = this.toRubyScriptExecutionContext();
        return executionContext == null ? null : executionContext.executeScript();
    }

    @Nullable
    public RubyScriptExecutionContext toRubyScriptExecutionContext() {
        if (this.hasModule() && !"bundler".equals(this.myGemName)) {
            LOG.debug("Adding Bundler preprocessor");
            this.withCommandLinePreprocessor(BundlerUtil.getBundlerPreprocessor(this.getRubySdk(), this.getModule()));
        }
        return RubyScriptExecutionContext.create(this);
    }

    public static RubyGemExecutionContext create(@NotNull Sdk sdk, @NotNull String gemName) {
        if (sdk == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(11);
        }
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(12);
        }
        return new RubyGemExecutionContext(sdk, gemName);
    }

    public String toString() {
        return "RubyGemExecutionContext{myGemName='" + this.myGemName + "', myGemScriptName='" + this.myGemScriptName + "', myGemVersion='" + this.myGemVersion + "'}";
    }

    @Nullable
    public static String getScriptPath(@Nullable Sdk sdk, @Nullable Module module, @NotNull String gemName) {
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(13);
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module, gemName, null);
    }

    @Nullable
    public static RubyGemExecutionContext tryCreate(@Nullable Sdk sdk, @Nullable Module module, @NotNull String gemName) {
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(14);
        }
        return RubyGemExecutionContext.tryCreate(sdk, module, gemName, null);
    }

    @Nullable
    public static RubyGemExecutionContext tryCreate(@Nullable Sdk sdk, @Nullable Module module, @NotNull String gemName, @Nullable String gemVersion) {
        GemInfo gemInfo;
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(15);
        }
        if (module != null && (gemInfo = RubyProjectGemSearchService.Companion.findGem(module, gemName, gemVersion)) != null) {
            LOG.debug("Found gem in module context ", new Object[]{gemName, " module ", module, ", gemVersion=", gemVersion});
            return (RubyGemExecutionContext)ReadAction.compute(() -> RubySdkUtil.isRubySDK(sdk) || RModuleUtil.getInstance().findRubySdkForModule(module) != null ? new RubyGemExecutionContext(module, gemName).withGemVersion(gemInfo.getVersion()) : null);
        }
        if (sdk != null && (gemInfo = (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(List.of(sdk), gemName, gemVersion))) != null) {
            LOG.debug("Found gem in sdk context ", new Object[]{gemName, " sdk ", sdk, ", gemVersion=", gemVersion});
            RubyGemExecutionContext context = new RubyGemExecutionContext(sdk, gemName).withGemVersion(gemInfo.getVersion());
            return module == null ? context : (RubyGemExecutionContext)context.withModule(module);
        }
        LOG.debug("Could not find a ", new Object[]{gemName, ", version=", gemVersion, " in the context of ", sdk, " and ", module});
        return null;
    }

    private static boolean isBashScript(@NotNull String scriptPath) {
        VirtualFile scriptFile;
        if (scriptPath == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(16);
        }
        if (SystemInfo.isUnix && (scriptFile = LocalFileSystem.getInstance().findFileByPath(scriptPath)) != null) {
            try {
                String[] lines;
                String fileText = VfsUtilCore.loadText((VirtualFile)scriptFile);
                String fileTextHead = fileText.substring(0, Math.min(300, fileText.length()));
                for (String line : lines = StringUtil.splitByLines((String)fileTextHead.trim())) {
                    if (StringUtil.isEmpty((String)line)) continue;
                    if (line.trim().startsWith(BASH_EXECUTE_DIRECTIVE)) {
                        for (String knownTerminal : KNOWN_TERMINALS) {
                            if (!line.endsWith("/" + knownTerminal) && !line.endsWith("/env " + knownTerminal)) continue;
                            return true;
                        }
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static String getScriptPath(@Nullable Sdk sdk, @Nullable Module module, @NotNull String gemName, @Nullable String gemScriptName) {
        if (gemName == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(17);
        }
        LOG.debug("Looking for a script: gemName=", new Object[]{gemName, "; gemScriptName=", gemScriptName, "; sdk=", sdk, "; module=", module});
        RubyGemExecutionContext gemExecutionContext = RubyGemExecutionContext.tryCreate(sdk, module, gemName);
        LOG.debug("Created context: ", new Object[]{gemExecutionContext});
        return gemExecutionContext == null ? null : gemExecutionContext.withGemScriptName(gemScriptName).getScriptPath();
    }

    @Override
    @NotNull
    protected RubyGemExecutionContext self() {
        RubyGemExecutionContext rubyGemExecutionContext = this;
        if (rubyGemExecutionContext == null) {
            RubyGemExecutionContext.$$$reportNull$$$0(18);
        }
        return rubyGemExecutionContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/RubyGemExecutionContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/RubyGemExecutionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateGemName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemScriptName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemScriptName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withGemVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateGemName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getScriptPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryCreate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBashScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 18 -> new IllegalStateException(string);
        };
    }
}

