/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.support.UIUtil;

public final class MissingGemNotificationWithFix
extends Notification {
    private static final String NOTIFICATION_GROUP_ID = "Gem";
    private static final NotificationGroup LOG_GROUP = NotificationGroup.logOnlyGroup((String)"Gem.Installing.Errors");

    private MissingGemNotificationWithFix(final @NotNull Reason reason, final @NotNull Module module, final @Nullable Sdk sdk, final @NotNull String gemName, @NotNull NotificationType type, final @Nullable Runnable postAction) {
        if (reason == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(1);
        }
        if (gemName == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(2);
        }
        if (type == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(3);
        }
        super(NOTIFICATION_GROUP_ID, MissingGemNotificationWithFix.renderMessage(reason, gemName, sdk), type);
        this.addAction((AnAction)new DumbAwareAction(RBundle.message((String)reason.getLinkKey())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reason == Reason.SDK_NOT_SET) {
                    UIUtil.openRubyModuleSettings(module);
                    if (postAction != null) {
                        postAction.run();
                    }
                } else if (reason == Reason.GEM_NOT_FOUND) {
                    if (sdk == null) {
                        throw new IllegalStateException("sdk must not be null in that notification type");
                    }
                    MissingGemNotificationWithFix.this.installGem(sdk, module, gemName, postAction);
                }
                MissingGemNotificationWithFix.this.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/MissingGemNotificationWithFix$1", "actionPerformed"));
            }
        });
    }

    @RequiresReadLock
    private void installGem(@NotNull Sdk sdk, @NotNull Module module, @NotNull String name, @Nullable Runnable postAction) {
        if (sdk == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(4);
        }
        if (module == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(5);
        }
        if (name == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (module.isDisposed()) {
            return;
        }
        HashMap<GemDependency, String> errorsMap = new HashMap<GemDependency, String>();
        Runnable callback = () -> {
            if (module.isDisposed()) {
                return;
            }
            this.expire();
            if (postAction != null) {
                postAction.run();
            }
        };
        GemInstallCommandOptions options = new GemInstallCommandOptions().withNoDocument();
        GemInstallProcessOptions processOptions = GemInstallProcessOptions.installMissingOnlyAsync(errorsMap).withCallback(callback);
        GemInstallUtil.installGemsInBackground(sdk, module, GemDependency.anyAsList(name), options, processOptions);
        if (!errorsMap.isEmpty()) {
            @NlsSafe String notificationContent = errorsMap.values().stream().reduce((s1, s2) -> s1 + "\n\n" + s2).orElseGet(String::new);
            LOG_GROUP.createNotification(notificationContent, NotificationType.ERROR);
        }
    }

    public static boolean checkGemExecPresenceOrInstall(@NotNull Module module, @Nullable Sdk rubySdk, @NotNull String gemName, @NotNull Callback callback) {
        if (module == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(7);
        }
        if (gemName == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(9);
        }
        return MissingGemNotificationWithFix.checkGemExecPresenceOrInstallWithAttempt(module, rubySdk, gemName, 0, callback);
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String renderMessage(@NotNull Reason reason, @NotNull String gemName, @Nullable Sdk sdk) {
        if (reason == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(10);
        }
        if (gemName == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(11);
        }
        String string = HtmlChunk.p().style("padding: 0; margin: 0;").addText(RBundle.message((String)reason.getNotificationContentKey(), (Object[])new Object[]{gemName, sdk == null ? gemName : sdk.getName()})).toString();
        if (string == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void notify(@NotNull Reason reason, @NotNull Module module, @Nullable Sdk sdk, @NotNull String gemName, @NotNull NotificationType type, @Nullable Runnable postAction) {
        if (reason == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(13);
        }
        if (module == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(14);
        }
        if (gemName == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(15);
        }
        if (type == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(16);
        }
        new MissingGemNotificationWithFix(reason, module, sdk, gemName, type, postAction).setImportant(true).notify(module.getProject());
    }

    private static boolean checkGemExecPresenceOrInstallWithAttempt(@NotNull Module module, @Nullable Sdk rubySdk, @NotNull String gemName, int attempt, @NotNull Callback callback) {
        if (module == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(17);
        }
        if (gemName == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            MissingGemNotificationWithFix.$$$reportNull$$$0(19);
        }
        if (rubySdk == null) {
            MissingGemNotificationWithFix.notify(Reason.SDK_NOT_SET, module, null, gemName, NotificationType.ERROR, () -> callback.done(false));
            return false;
        }
        GemInfo gem = RubyGemSearchUtil.findGem(module, rubySdk, gemName);
        if (gem == null) {
            MissingGemNotificationWithFix.notify(Reason.GEM_NOT_FOUND, module, rubySdk, gemName, NotificationType.ERROR, () -> {
                if (attempt == 0) {
                    MissingGemNotificationWithFix.checkGemExecPresenceOrInstallWithAttempt(module, rubySdk, gemName, attempt + 1, callback);
                } else {
                    callback.done(false);
                }
            });
            return false;
        }
        callback.done(true);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/MissingGemNotificationWithFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/MissingGemNotificationWithFix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "renderMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installGem";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkGemExecPresenceOrInstall";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderMessage";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkGemExecPresenceOrInstallWithAttempt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    private static enum Reason {
        SDK_NOT_SET("gems.inspection.gem.no.sdk", "sdk.select.prompt.title"),
        GEM_NOT_FOUND("gems.inspection.gem.not.available", "gems.inspection.try.to.install");

        @NotNull
        @NonNls
        private final String myNotificationContentKey;
        @Nullable
        @NonNls
        private final String myLinkKey;

        private Reason(String content, String linkKey) {
            if (content == null) {
                Reason.$$$reportNull$$$0(0);
            }
            this.myNotificationContentKey = content;
            this.myLinkKey = linkKey;
        }

        @NotNull
        @NonNls
        public String getNotificationContentKey() {
            String string = this.myNotificationContentKey;
            if (string == null) {
                Reason.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getLinkKey() {
            if (this.myLinkKey == null) {
                throw new UnsupportedOperationException();
            }
            String string = this.myLinkKey;
            if (string == null) {
                Reason.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/gem/MissingGemNotificationWithFix$Reason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/MissingGemNotificationWithFix$Reason";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationContentKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinkKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void done(boolean var1);
    }
}

