/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.gem.GemAdditionalInfo;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemSpecContext;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.library.RubyLibraryKind;
import org.jetbrains.plugins.ruby.library.RubyLibraryProperties;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemInfo {
    private static final Logger LOG = Logger.getInstance(GemInfo.class);
    @NonNls
    public static final String GEM_LIBRARY_SUFFIX = "[gem]";
    @NonNls
    private static final String PATH_GEM_SUFFIX = "[path]";
    @NonNls
    private static final String PATH_LIBRARY_SUFFIX = "[path][gem]";
    @NonNls
    private static final Pattern GEM_LIBRARY_PATTERN = Pattern.compile("(.+) \\(v([^,]*)(?:, (.*))?\\) (?:\\[path\\])?\\[gem\\]");
    private static final String[] REQUIRE_PATH_ADDITIONAL_DIRECTORIES = new String[]{"app", "config", "db", "features", "frameworks", "node_modules", "vendor"};
    private static final Map<String, List<String>> ADDITIONAL_SOURCE_DIRECTORIES_BY_LIBRARY = Map.ofEntries(Map.entry("rbs", List.of("core", "sig", "stdlib")));
    private static final List<String> DEFAULT_ADDITIONAL_SOURCE_DIRECTORIES = List.of("sig");
    private static final Pattern CLEANUP_PATTERN = Pattern.compile("\u0000");
    private static final GemDependency[] EMPTY_DEPENDENCIES = new GemDependency[0];
    @NotNull
    private final String myName;
    @Nullable
    private final String myVersion;
    @NotNull
    private final String myUrl;
    @Nullable
    private String myReadme;
    private boolean alreadyResolvedReadme;
    private final GemAdditionalInfo myAdditionalInfo;
    private final GemDependency[] myDependencies;
    @Nullable
    private final Sdk mySdk;
    private final boolean myRemote;
    private VirtualFile myFile;
    private final boolean myIsGit;
    private boolean myIsLocalGitRepo;
    @Nullable
    private final String myRef;
    private final boolean myFromPath;
    @NotNull
    private final List<String> myRequirePaths;

    public GemInfo(@NotNull String name, @Nullable String version, @NotNull String url, @Nullable String readme, @Unmodifiable Set<GemDependency> dependencies, @Nullable Sdk sdk, boolean remote, @NotNull GemAdditionalInfo additionalInfo, boolean isGit, @Nullable String ref, boolean fromPath, @NotNull List<String> requirePaths) {
        if (name == null) {
            GemInfo.$$$reportNull$$$0(0);
        }
        if (url == null) {
            GemInfo.$$$reportNull$$$0(1);
        }
        if (additionalInfo == null) {
            GemInfo.$$$reportNull$$$0(2);
        }
        if (requirePaths == null) {
            GemInfo.$$$reportNull$$$0(3);
        }
        this.myIsLocalGitRepo = false;
        this.myName = name;
        this.myVersion = version;
        this.myUrl = url;
        this.myReadme = readme;
        this.mySdk = sdk;
        this.myRemote = remote;
        this.myIsGit = isGit;
        this.myRef = ref;
        this.myFromPath = fromPath;
        this.myDependencies = dependencies != null ? dependencies.toArray(new GemDependency[0]) : EMPTY_DEPENDENCIES;
        this.myAdditionalInfo = additionalInfo;
        this.myRequirePaths = requirePaths;
        LOG.assertTrue(this.myRemote || this.myFromPath || this.mySdk != null, (Object)"GemInfo created with invalid setup: myRemote=%s, myFromPath=%s, mySdk=%s".formatted(this.myRemote, this.myFromPath, this.mySdk));
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GemInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public final String getVersion() {
        String string = this.myVersion != null ? this.myVersion : StringUtil.notNullize((String)this.getHumanRef(), (String)PATH_GEM_SUFFIX);
        if (string == null) {
            GemInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isLocalGitRepo() {
        return this.myIsLocalGitRepo;
    }

    public void setLocalGitRepo(boolean localGitRepo) {
        this.myIsLocalGitRepo = localGitRepo;
    }

    @Nullable
    @NlsSafe
    private String getHumanRef() {
        return this.myRef != null ? this.myRef.substring(0, Math.min(6, this.myRef.length())) : null;
    }

    @Nullable
    @NlsSafe
    public final String getNullableVersion() {
        return this.myVersion;
    }

    @NotNull
    @NlsSafe
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            GemInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getReadme() {
        if (this.myReadme == null && !this.isRemote() && !this.alreadyResolvedReadme) {
            VirtualFile gemFile = this.getFile();
            this.myReadme = gemFile != null ? GemUtil.getGemReadme(gemFile) : null;
            this.alreadyResolvedReadme = true;
        }
        return this.myReadme;
    }

    public @NotNull List<@NlsSafe String> getRequirePaths() {
        List<String> list = this.myRequirePaths;
        if (list == null) {
            GemInfo.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile) {
        if (gemFile == null) {
            GemInfo.$$$reportNull$$$0(8);
        }
        return GemInfo.create(sdk, gemFile, false);
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile, boolean fromPath) {
        if (gemFile == null) {
            GemInfo.$$$reportNull$$$0(9);
        }
        ArrayList<GemInfo> result = new ArrayList<GemInfo>();
        GemInfo.createAndAdd(sdk, gemFile, fromPath, result);
        for (VirtualFile virtualFile : gemFile.getChildren()) {
            if (!virtualFile.isDirectory() || FileTypeManager.getInstance().isFileIgnored(virtualFile)) continue;
            GemInfo.createAndAdd(sdk, virtualFile, fromPath, result);
        }
        ArrayList<GemInfo> arrayList = result;
        if (arrayList == null) {
            GemInfo.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void createAndAdd(Sdk sdk, VirtualFile gemFile, boolean fromPath, List<GemInfo> result) {
        GemSpecContext spec = GemInfo.parseSpecification(gemFile);
        if (spec != null) {
            spec.putData(GemsSpecKeys.SDK, sdk);
            spec.putData(GemsSpecKeys.FROM_PATH, fromPath);
            GemInfo gem = GemInfo.create(spec, gemFile.getUrl(), null);
            ContainerUtil.addIfNotNull(result, (Object)gem);
        }
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    @Nullable
    public VirtualFile getFile() {
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        }
        return this.myFile;
    }

    @Nullable
    public VirtualFile getSpecFile() {
        return GemUtil.findGemspecFileInSpecOrCurrent(this.getFile());
    }

    @Nullable
    public VirtualFile getLibFolder() {
        return GemUtil.findGemLibDirectory(this.getFile());
    }

    @NotNull
    public GemDependency asDependency() {
        GemDependency gemDependency = GemDependency.exact(this);
        if (gemDependency == null) {
            GemInfo.$$$reportNull$$$0(11);
        }
        return gemDependency;
    }

    public void createLibrary(LibraryTable.ModifiableModel model) {
        String libraryName = this.getLibraryName();
        LibraryEx library = (LibraryEx)model.getLibraryByName(libraryName);
        if (library == null) {
            library = (LibraryEx)model.createLibrary(libraryName, (PersistentLibraryKind)RubyLibraryKind.INSTANCE);
        } else {
            MutableEntityStorage mutableEntityStorage = ((LegacyBridgeModifiableBase)model).getDiff();
            ((LibraryBridgeImpl)library).setTargetBuilder(mutableEntityStorage);
        }
        LibraryEx.ModifiableModelEx libModel = ((LibraryBridgeImpl)library).getModifiableModelToTargetBuilder();
        LOG.debug(this.toString(), new Object[]{": ", "created library, configuring: ", library});
        libModel.setProperties((LibraryProperties)this.createLibraryProperties());
        ArrayList paths = new ArrayList(ContainerUtil.concat(this.getValidRequirePaths(), this.getAdditionalSourcePaths()));
        VirtualFile root = this.getFile();
        if (root != null) {
            for (VirtualFile file : root.getChildren()) {
                if (!file.isDirectory()) continue;
                LOG.debug(this.toString(), new Object[]{": ", "adding class and source roots: ", file});
                libModel.addRoot(file.getUrl(), OrderRootType.CLASSES);
                libModel.addRoot(file.getUrl(), OrderRootType.SOURCES);
                if (paths.remove(file) || !file.isDirectory()) continue;
                LOG.debug(this.toString(), new Object[]{": ", "adding excluded root: ", file});
                libModel.addExcludedRoot(file.getUrl());
            }
            for (VirtualFile path : paths) {
                LOG.debug(this.toString(), new Object[]{": ", "adding included sources: ", path});
                libModel.addRoot(path.getUrl(), OrderRootType.SOURCES);
            }
        }
        libModel.commit();
        LOG.debug(this.toString(), new Object[]{": ", "commited library: ", library});
    }

    @Nullable
    private static GemSpecContext parseSpecification(VirtualFile gemFile) {
        VirtualFile specFile = GemUtil.findGemspecFileInSpecOrCurrent(gemFile);
        if (specFile == null) {
            return null;
        }
        return GemSpecParser.getInstance().getGemSpec(gemFile, specFile);
    }

    @Nullable
    public static GemInfo create(@NotNull Sdk sdk, @NotNull RubyLibraryProperties properties) {
        if (sdk == null) {
            GemInfo.$$$reportNull$$$0(12);
        }
        if (properties == null) {
            GemInfo.$$$reportNull$$$0(13);
        }
        String name = properties.getName();
        String url = properties.getUrl();
        RubyLibraryProperties.AdditionalInfo additionalInfo = properties.getAdditionalInfo();
        if (name == null || url == null) {
            return null;
        }
        Set dependencies = ContainerUtil.map2SetNotNull(properties.getDependencies(), dependency -> {
            String dependencyName = dependency.getName();
            if (dependencyName == null) {
                return null;
            }
            return new GemDependency(dependencyName, ContainerUtil.map(dependency.getBounds(), it -> new Pair((Object)GemDependency.Bound.getBound(it.getOperator()), (Object)it.getVersion())), dependency.getUrl(), dependency.getLib(), dependency.isGit(), dependency.getRef(), dependency.isDoRequire(), dependency.getFromPath(), ArrayUtil.toStringArray(dependency.getPlatforms()));
        });
        return new GemInfo(name, properties.getVersion(), url, properties.getReadme(), dependencies, sdk, properties.isRemote(), new GemAdditionalInfo(additionalInfo.getSummary(), additionalInfo.getHomepage(), additionalInfo.getEmail(), additionalInfo.getAuthors()), properties.isGit(), properties.getRef(), properties.isFromPath(), properties.getRequirePaths());
    }

    @NonNls
    @NotNull
    public String getLibraryName() {
        String name;
        if (this.myFromPath) {
            name = this.myName + " (v" + this.getVersion() + ") [path][gem]";
        } else {
            String version = this.getVersion();
            String ref = this.getHumanRef();
            version = this.isGit() ? (StringUtil.equals((CharSequence)version, (CharSequence)ref) ? "@" + ref : version + "@" + ref) : version;
            Object gemset = RbenvGemsetManager.fetchGemGemset(this);
            gemset = gemset == null ? "" : ", " + (String)gemset;
            name = this.myName + " (v" + version + ", " + (this.mySdk != null ? this.mySdk.getName() : "") + (String)gemset + ") [gem]";
        }
        String string = name;
        if (string == null) {
            GemInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String cleanup(String string) {
        return CLEANUP_PATTERN.matcher(string).replaceAll("");
    }

    @Nullable
    public static Pair<String, String> getNameAndVersion(String libraryName) {
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = GEM_LIBRARY_PATTERN.matcher(libraryName);
        if (matcher.matches()) {
            String name = matcher.group(1);
            String versionAndRef = matcher.group(2);
            String[] split = versionAndRef.split("@");
            if (split.length == 0) {
                LOG.warn("split.length == 0: " + libraryName);
                return Pair.create((Object)name, (Object)"");
            }
            String version = StringUtil.isEmpty((String)split[0]) && split.length > 1 ? split[1] : split[0];
            return Pair.create((Object)name, (Object)version);
        }
        LOG.warn("error matching gem name: " + libraryName);
        return null;
    }

    @Nullable
    public static String getSdkName(String libraryName) {
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = GEM_LIBRARY_PATTERN.matcher(libraryName);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        LOG.warn("error matching gem name: " + libraryName);
        return null;
    }

    public static boolean isGemLibrary(@Nullable String libraryName) {
        return libraryName != null && libraryName.endsWith(GEM_LIBRARY_SUFFIX);
    }

    public static boolean isPathGemLibrary(@Nullable String libraryName) {
        return libraryName != null && libraryName.endsWith(PATH_LIBRARY_SUFFIX);
    }

    @NotNull
    public List<VirtualFile> getValidRequirePaths() {
        VirtualFile lib;
        VirtualFile file = this.getFile();
        if (file == null || !file.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GemInfo.$$$reportNull$$$0(15);
            }
            return list;
        }
        List requirePaths = this.myRequirePaths.stream().map(it -> file.findFileByRelativePath(it)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (requirePaths.isEmpty() && (lib = file.findFileByRelativePath("lib")) != null && lib.isDirectory()) {
            requirePaths.add(lib);
        }
        for (String directory : REQUIRE_PATH_ADDITIONAL_DIRECTORIES) {
            VirtualFile directoryFile = file.findFileByRelativePath(directory);
            if (directoryFile == null || !directoryFile.isDirectory() || requirePaths.contains(directoryFile)) continue;
            requirePaths.add(directoryFile);
        }
        List list = requirePaths;
        if (list == null) {
            GemInfo.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getAdditionalSourcePaths() {
        VirtualFile file = this.getFile();
        if (file == null || !file.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GemInfo.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<VirtualFile> list = ADDITIONAL_SOURCE_DIRECTORIES_BY_LIBRARY.getOrDefault(this.myName, DEFAULT_ADDITIONAL_SOURCE_DIRECTORIES).stream().map(arg_0 -> ((VirtualFile)file).findFileByRelativePath(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GemInfo.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public GemAdditionalInfo getAdditionalInfo() {
        GemAdditionalInfo gemAdditionalInfo = this.myAdditionalInfo;
        if (gemAdditionalInfo == null) {
            GemInfo.$$$reportNull$$$0(19);
        }
        return gemAdditionalInfo;
    }

    public GemDependency[] getDependencies() {
        return this.myDependencies;
    }

    public boolean isRemote() {
        return this.myRemote;
    }

    public String toString() {
        return String.format("GemInfo{myName='%s', myVersion='%s', myUrl='%s'}", this.myName, this.getPresentableVersion(), this.myUrl);
    }

    @Nullable
    protected String getPresentableVersion() {
        return this.myVersion;
    }

    @Nullable
    public Library getLibrary(LibraryTable.ModifiableModel model) {
        return model.getLibraryByName(this.getLibraryName());
    }

    @Nullable
    public String getRef() {
        return this.myRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GemInfo)) {
            return false;
        }
        GemInfo gemInfo = (GemInfo)o;
        if (!this.myName.equals(gemInfo.myName)) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(gemInfo.myVersion) : gemInfo.myVersion != null) {
            return false;
        }
        if (this.myRemote && gemInfo.myRemote) {
            return true;
        }
        if (!this.myUrl.equals(gemInfo.myUrl)) {
            return false;
        }
        if (this.myIsGit != gemInfo.myIsGit) {
            return false;
        }
        return !(this.myRef != null ? !this.myRef.equals(gemInfo.myRef) : gemInfo.myRef != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        if (this.myRemote) {
            return result;
        }
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + (this.myIsGit ? 1 : 0);
        result = 31 * result + (this.myRef != null ? this.myRef.hashCode() : 0);
        return result;
    }

    public boolean isGit() {
        return this.myIsGit;
    }

    public boolean isFromPath() {
        return this.myFromPath;
    }

    @Contract(value="null,_,_->null")
    @Nullable
    public static GemInfo create(@Nullable GemSpecContext specs, @NotNull String url, @Nullable String readme) {
        boolean isFromPath;
        if (url == null) {
            GemInfo.$$$reportNull$$$0(20);
        }
        if (specs == null) {
            return null;
        }
        String gemName = (String)GemsSpecKeys.NAME.get((UserDataHolder)specs);
        String gemVersion = (String)GemsSpecKeys.VERSION.get((UserDataHolder)specs);
        GemAdditionalInfo additionalInfo = GemAdditionalInfo.create(specs);
        Set dependencies = (Set)GemsSpecKeys.DEPENDENCIES.get((UserDataHolder)specs);
        Sdk sdk = (Sdk)GemsSpecKeys.SDK.get((UserDataHolder)specs);
        Boolean remote = (Boolean)GemsSpecKeys.REMOTE.get((UserDataHolder)specs);
        Boolean git = (Boolean)GemsSpecKeys.GIT.get((UserDataHolder)specs);
        Boolean fromPath = (Boolean)GemsSpecKeys.FROM_PATH.get((UserDataHolder)specs);
        String ref = (String)GemsSpecKeys.REF.get((UserDataHolder)specs);
        List<String> requirePaths = (List<String>)GemsSpecKeys.REQUIRE_PATHS.get((UserDataHolder)specs);
        boolean bl = isFromPath = fromPath != null && fromPath != false;
        if (gemName == null || gemVersion == null && ref == null && !isFromPath) {
            LOG.debug("Unable to build gemInfo from: name=", new Object[]{gemName, " gemVersion=", gemVersion, " ref=", ref, " isFromPath=", isFromPath});
            return null;
        }
        return new GemInfo(GemInfo.cleanup(gemName), gemVersion, GemInfo.cleanup(url), readme != null ? readme : (String)GemsSpecKeys.DESCRIPTION.get((UserDataHolder)specs), dependencies, sdk, remote != null && remote != false, additionalInfo, git != null && git != false, ref, isFromPath, requirePaths != null ? requirePaths : Collections.singletonList("lib"));
    }

    @Nullable
    public Sdk getSdk() {
        return this.mySdk;
    }

    public boolean isDefaultGem() {
        return StringUtil.endsWith((CharSequence)this.getAdditionalInfo().summary(), (CharSequence)" is bundled with Ruby");
    }

    @NotNull
    public RubyLibraryProperties createLibraryProperties() {
        RubyLibraryProperties properties = new RubyLibraryProperties();
        properties.setName(this.myName);
        properties.setVersion(this.myVersion);
        properties.setUrl(this.myUrl);
        properties.setReadme(this.myReadme);
        properties.setRef(this.myRef);
        properties.setAdditionalInfo(new RubyLibraryProperties.AdditionalInfo(this.myAdditionalInfo.authors(), this.myAdditionalInfo.email(), this.myAdditionalInfo.homepage(), this.myAdditionalInfo.summary()));
        properties.setRequirePaths(this.myRequirePaths);
        properties.setDependencies(ContainerUtil.map((Object[])this.myDependencies, dependency -> new RubyLibraryProperties.Dependency(dependency.getName(), ContainerUtil.map(dependency.getBounds(), it -> new RubyLibraryProperties.Dependency.Bound(((GemDependency.Bound)((Object)((Object)((Object)it.first)))).getOperator(), (String)it.second)), dependency.getUrl(), dependency.getLibScript(), dependency.getRef(), List.of((String[])ObjectUtils.coalesce((Object)dependency.getPlatforms(), (Object)ArrayUtil.EMPTY_STRING_ARRAY)), dependency.doRequire(), dependency.isGit(), dependency.isFromPath())));
        properties.setFromPath(this.myFromPath);
        properties.setGit(this.myIsGit);
        properties.setRemote(this.myRemote);
        RubyLibraryProperties rubyLibraryProperties = properties;
        if (rubyLibraryProperties == null) {
            GemInfo.$$$reportNull$$$0(21);
        }
        return rubyLibraryProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 11, 14, 15, 16, 17, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirePaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirePaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asDependency";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidRequirePaths";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalSourcePaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 11, 14, 15, 16, 17, 18, 19, 21 -> new IllegalStateException(string);
        };
    }
}

