/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;

final class GemBoxState {
    private Map<String, GemInfo> myGemsMap = Collections.emptyMap();
    private Set<GemInfo> myOldGemsSet = Collections.emptySet();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock(true);
    private final AtomicInteger myModificationCount = new AtomicInteger(0);

    GemBoxState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWrite(@NotNull BiConsumer<? super Map<String, GemInfo>, ? super Set<GemInfo>> consumer) {
        if (consumer == null) {
            GemBoxState.$$$reportNull$$$0(0);
        }
        boolean doneFlag = false;
        AtomicInteger snapshotCount = new AtomicInteger();
        while (!doneFlag) {
            Pair snapShot = this.compute((gemsMap, oldGemsSet) -> {
                snapshotCount.set(this.myModificationCount.get());
                return Pair.create(new HashMap(gemsMap), new HashSet(oldGemsSet));
            });
            consumer.accept((Map<String, GemInfo>)snapShot.getFirst(), (Set<GemInfo>)snapShot.getSecond());
            ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
            writeLock.lock();
            try {
                if (this.myModificationCount.get() != snapshotCount.get()) continue;
                this.myGemsMap = Collections.unmodifiableMap((Map)snapShot.getFirst());
                this.myOldGemsSet = Collections.unmodifiableSet((Set)snapShot.getSecond());
                this.myModificationCount.incrementAndGet();
                doneFlag = true;
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T compute(@NotNull BiFunction<? super Map<String, GemInfo>, ? super Set<GemInfo>, T> computable) {
        if (computable == null) {
            GemBoxState.$$$reportNull$$$0(1);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            T t = computable.apply(this.myGemsMap, this.myOldGemsSet);
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    public String toString() {
        return "GemBoxState{myGemsMap=" + String.valueOf(this.myGemsMap) + ", myOldGemsSet=" + String.valueOf(this.myOldGemsSet) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemBoxState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doWrite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

