/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.psi.presentation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import icons.RubyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotFactoryCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotSequenceCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotTraitCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.RubyFactoryBotModelFakePsiElement;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.util.RubyFactoryBotPsiUtil;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public final class RubyFactoryBotPresentationUtil {
    private RubyFactoryBotPresentationUtil() {
    }

    @Nullable
    public static Icon getFactoryIcon(@NotNull RubyFactoryBotFactory factory) {
        RubyFactoryBotModelFakePsiElement declaration;
        if (factory == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(0);
        }
        if ((declaration = factory.getPrimaryDeclaration()) == null) {
            return RubyIcons.FactoryBot.Factory;
        }
        return declaration.getIcon();
    }

    @Nullable
    public static Icon getModelIcon(@NotNull RPossibleCall call, @Nullable PsiElement element) {
        if (call == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(1);
        }
        boolean original = element == null || RubyFactoryBotPsiUtil.getModelNameElement(call) == element;
        RubyCallType callType = call.getCallType();
        if (callType instanceof RubyFactoryBotFactoryCallType) {
            return original ? RubyIcons.FactoryBot.Factory : RubyIcons.FactoryBot.AliasFactory;
        }
        if (callType instanceof RubyFactoryBotSequenceCallType) {
            return original ? RubyIcons.FactoryBot.Sequence : RubyIcons.FactoryBot.AliasSequence;
        }
        if (callType instanceof RubyFactoryBotTraitCallType) {
            return RubyIcons.FactoryBot.Trait;
        }
        return null;
    }

    @NotNull
    public static String getModelLocationString(@NotNull RPsiElement element) {
        if (element == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(2);
        }
        String string = TextUtil.wrapInParens((String)RContainerPresentationUtil.getLocation((RPsiElement)element));
        if (string == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    @Nls
    public static String getModelTypeString(@NotNull RCall call) {
        RubyCallType callType;
        if (call == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(4);
        }
        if ((callType = call.getCallType()) instanceof RubyFactoryBotFactoryCallType) {
            return RBundle.message((String)"ruby.factoryBot.presentation.factory.type");
        }
        if (callType instanceof RubyFactoryBotSequenceCallType) {
            return RBundle.message((String)"ruby.factoryBot.presentation.sequence.type");
        }
        if (callType instanceof RubyFactoryBotTraitCallType) {
            return RBundle.message((String)"ruby.factoryBot.presentation.trait.type");
        }
        return null;
    }

    @NotNull
    public static ItemPresentation getModelPresentation(final @NotNull RPossibleCall call) {
        if (call == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(5);
        }
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String callTypeName = RubyFactoryBotModelCallType.getName(call);
                String string = callTypeName != null ? callTypeName : RBundle.message((String)"ruby.presentation.unknown");
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = RubyFactoryBotPresentationUtil.getModelLocationString((RPsiElement)call);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return RubyFactoryBotPresentationUtil.getModelIcon(call, (PsiElement)RubyFactoryBotPsiUtil.getModelNameElement(call));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/factoryBot/psi/presentation/RubyFactoryBotPresentationUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static Icon getTraitIcon() {
        Icon icon = RubyIcons.FactoryBot.Trait;
        if (icon == null) {
            RubyFactoryBotPresentationUtil.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/psi/presentation/RubyFactoryBotPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/psi/presentation/RubyFactoryBotPresentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelLocationString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModelIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModelLocationString";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModelTypeString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModelPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

