/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.RubyFactoryBotModelFakePsiElement;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotModelUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public final class RubyFactoryBotGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        ArrayList<Object> items = new ArrayList<Object>();
        items.addAll(RubyFactoryBotGotoRelatedProvider.getClassRelatedItems(context.getProject(), context));
        items.addAll(RubyFactoryBotGotoRelatedProvider.getFactoryRelatedItems(context));
        ArrayList<Object> arrayList = items;
        if (arrayList == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> getClassRelatedItems(@NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        SortedList items = new SortedList(Comparator.comparing(GotoRelatedItem::getCustomName));
        FQN fqn = (FQN)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getContainingRClass(context), RElementWithFQN::getFQNWithNesting);
        if (fqn == null || fqn == FQN.INVALID) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        RubyFactoryBotModelUtil.processFactories(project, (SearchScope)GlobalSearchScopesCore.projectTestScope((Project)project), (Processor<? super RubyFactoryBotFactory>)((Processor)arg_0 -> RubyFactoryBotGotoRelatedProvider.lambda$getClassRelatedItems$0(fqn, (List)items, arg_0)));
        SortedList sortedList = items;
        if (sortedList == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(5);
        }
        return sortedList;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> getFactoryRelatedItems(@NotNull PsiElement context) {
        RubyFactoryBotFactory factory;
        if (context == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(6);
        }
        if ((factory = RubyFactoryBotGotoRelatedProvider.getFactory(context)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        Symbol symbol = factory.getInstanceSymbol();
        if (symbol == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiElement declaration = (PsiElement)ContainerUtil.getFirstItem((Collection)symbol.getAllDeclarations(context));
        List<Object> list = declaration != null ? Collections.singletonList(new GotoRelatedItem(declaration)) : Collections.emptyList();
        if (list == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static RubyFactoryBotFactory getFactory(@NotNull PsiElement element) {
        RBlockCall blockCall;
        if (element == null) {
            RubyFactoryBotGotoRelatedProvider.$$$reportNull$$$0(10);
        }
        if ((blockCall = Optional.ofNullable((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)element, RPossibleCall.class)).map(RCallNavigator::getRealCall).map(RBlockCallNavigator::getByCall).filter(call -> RubyPsiUtil.isCallOfType((PsiElement)call, callType -> callType instanceof RubyFactoryBotModelCallType)).orElse(RubyPsiUtil.getParentBlockCall(element, parent -> parent.getCallType() instanceof RubyFactoryBotModelCallType))) == null) {
            return null;
        }
        String parentName = RubyFactoryBotModelCallType.getName((RPossibleCall)blockCall);
        return parentName != null ? RubyFactoryBotFactory.findByName(element.getProject(), (SearchScope)element.getResolveScope(), parentName) : null;
    }

    private static /* synthetic */ boolean lambda$getClassRelatedItems$0(FQN fqn, List items, RubyFactoryBotFactory factory) {
        RubyFactoryBotModelFakePsiElement declaration;
        ProgressManager.checkCanceled();
        if (fqn.equals(factory.getInstanceFqn()) && !factory.isAlias() && (declaration = factory.getPrimaryDeclaration()) != null) {
            items.add(new MyFactoryRelatedItem(factory.getName(), declaration));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/navigation/RubyFactoryBotGotoRelatedProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/navigation/RubyFactoryBotGotoRelatedProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRelatedItems";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryRelatedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassRelatedItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryRelatedItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyFactoryRelatedItem
    extends GotoRelatedItem {
        private final @NlsContexts.ListItem String myName;

        private MyFactoryRelatedItem(@NlsContexts.ListItem @NotNull String name, @NotNull RubyFactoryBotModelFakePsiElement element) {
            if (name == null) {
                MyFactoryRelatedItem.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MyFactoryRelatedItem.$$$reportNull$$$0(1);
            }
            super((PsiElement)element, RBundle.message((String)"ruby.factoryBot.gotoRelated.factories.title"));
            this.myName = name;
        }

        @Nullable
        public Icon getCustomIcon() {
            return this.getElement().getIcon();
        }

        @NotNull
        public String getCustomName() {
            String string = this.myName;
            if (string == null) {
                MyFactoryRelatedItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public RubyFactoryBotModelFakePsiElement getElement() {
            RubyFactoryBotModelFakePsiElement rubyFactoryBotModelFakePsiElement = (RubyFactoryBotModelFakePsiElement)Objects.requireNonNull(super.getElement());
            if (rubyFactoryBotModelFakePsiElement == null) {
                MyFactoryRelatedItem.$$$reportNull$$$0(3);
            }
            return rubyFactoryBotModelFakePsiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/navigation/RubyFactoryBotGotoRelatedProvider$MyFactoryRelatedItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/navigation/RubyFactoryBotGotoRelatedProvider$MyFactoryRelatedItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

