/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.model;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.stubs.indexes.RubyFactoryBotFactoryNameIndex;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.stubs.indexes.RubyFactoryBotSequenceNameIndex;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.stubs.indexes.RubyFactoryBotTraitNameIndex;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotSequence;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotTrait;

public final class RubyFactoryBotModelUtil {
    private RubyFactoryBotModelUtil() {
    }

    public static void processFactories(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super RubyFactoryBotFactory> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(2);
        }
        for (String name : RubyFactoryBotFactoryNameIndex.getInstance().getAllKeys(project)) {
            RubyFactoryBotFactory factory = RubyFactoryBotFactory.findByName(project, searchScope, name);
            if (factory.getDeclarations().isEmpty() || processor.process((Object)factory)) continue;
            return;
        }
    }

    public static void processFactoryNames(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(5);
        }
        RubyFactoryBotModelUtil.processFactories(project, searchScope, (Processor<? super RubyFactoryBotFactory>)((Processor)factory -> processor.process((Object)factory.getName())));
    }

    public static void processSequences(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super RubyFactoryBotSequence> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(8);
        }
        for (String name : RubyFactoryBotSequenceNameIndex.getInstance().getAllKeys(project)) {
            RubyFactoryBotSequence sequence = RubyFactoryBotSequence.findByName(project, searchScope, name);
            if (sequence.getDeclarations().isEmpty() || processor.process((Object)sequence)) continue;
            return;
        }
    }

    public static void processSequenceNames(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(11);
        }
        RubyFactoryBotModelUtil.processSequences(project, searchScope, (Processor<? super RubyFactoryBotSequence>)((Processor)sequence -> processor.process((Object)sequence.getName())));
    }

    public static void processTraits(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super RubyFactoryBotTrait> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(14);
        }
        for (String name : RubyFactoryBotTraitNameIndex.getInstance().getAllKeys(project)) {
            for (RubyFactoryBotTrait trait : RubyFactoryBotTrait.findAllByName(project, searchScope, name)) {
                if (processor.process((Object)trait)) continue;
                return;
            }
        }
    }

    public static boolean processTraitsByName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PairProcessor<? super String, ? super List<RubyFactoryBotTrait>> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(17);
        }
        for (String name : RubyFactoryBotTraitNameIndex.getInstance().getAllKeys(project)) {
            List<RubyFactoryBotTrait> traits = RubyFactoryBotTrait.findAllByName(project, searchScope, name);
            if (traits.isEmpty() || processor.process((Object)name, traits)) continue;
            return false;
        }
        return true;
    }

    public static void processTraitNames(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            RubyFactoryBotModelUtil.$$$reportNull$$$0(20);
        }
        CommonProcessors.UniqueProcessor wrapper = new CommonProcessors.UniqueProcessor(processor);
        RubyFactoryBotModelUtil.processTraits(project, searchScope, (Processor<? super RubyFactoryBotTrait>)((Processor)trait -> wrapper.process((Object)trait.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/model/RubyFactoryBotModelUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFactories";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processFactoryNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processSequences";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processSequenceNames";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processTraits";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processTraitsByName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "processTraitNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

