/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.model;

import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotFactoryCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.RubyFactoryBotModelFakePsiElement;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.stubs.indexes.RubyFactoryBotFactoryNameIndex;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotModelBase;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyFactoryBotFactory
extends RubyFactoryBotModelBase {
    private final NullableLazyValue<RubyFactoryBotFactory> myParentFactory;
    private final NotNullLazyValue<FQN> myInstanceFqn;
    private final NullableLazyValue<Symbol> myInstanceSymbol;

    private RubyFactoryBotFactory(@NotNull String name, @NotNull Collection<RCall> declarations) {
        if (name == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(0);
        }
        if (declarations == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(1);
        }
        super(name, declarations);
        this.myParentFactory = NullableLazyValue.atomicLazyNullable(this::computeParentFactory);
        this.myInstanceFqn = NotNullLazyValue.atomicLazy(() -> this.computeInstanceFqn());
        this.myInstanceSymbol = NullableLazyValue.atomicLazyNullable(this::computeInstanceSymbol);
    }

    @NotNull
    public FQN getInstanceFqn() {
        FQN fQN = (FQN)this.myInstanceFqn.getValue();
        if (fQN == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @Nullable
    public Symbol getInstanceSymbol() {
        return (Symbol)this.myInstanceSymbol.getValue();
    }

    @Nullable
    public RubyFactoryBotFactory getParentFactory() {
        return (RubyFactoryBotFactory)this.myParentFactory.getValue();
    }

    public boolean isAlias() {
        RubyFactoryBotModelFakePsiElement declaration = this.getPrimaryDeclaration();
        return declaration != null && declaration.isAlias();
    }

    @NotNull
    private FQN computeInstanceFqn() {
        RCall declaration = this.getPrimaryDeclarationCall();
        if (declaration == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RubyFactoryBotFactory.$$$reportNull$$$0(3);
            }
            return fQN;
        }
        InflectorService inflectorService = (InflectorService)ObjectUtils.doIfNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)declaration), InflectorService::getInstance);
        if (inflectorService == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RubyFactoryBotFactory.$$$reportNull$$$0(4);
            }
            return fQN;
        }
        String className = RubyFactoryBotModelCallType.getClassOption((RPossibleCall)declaration);
        if (StringUtil.isNotEmpty((String)className)) {
            FQN fQN = FQN.ofNullable((String)inflectorService.classify(className));
            if (fQN == null) {
                RubyFactoryBotFactory.$$$reportNull$$$0(5);
            }
            return fQN;
        }
        RubyFactoryBotFactory parentFactory = this.getParentFactory();
        if (parentFactory != null) {
            FQN fqn = (FQN)RecursionManager.doPreventingRecursion((Object)this.myName, (boolean)false, parentFactory::getInstanceFqn);
            FQN fQN = (FQN)ObjectUtils.coalesce((Object)fqn, (Object)FQN.INVALID);
            if (fQN == null) {
                RubyFactoryBotFactory.$$$reportNull$$$0(6);
            }
            return fQN;
        }
        String name = RubyFactoryBotModelCallType.getName((RPossibleCall)declaration);
        FQN fQN = FQN.ofNullable((String)inflectorService.classify(name));
        if (fQN == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(7);
        }
        return fQN;
    }

    @Nullable
    private Symbol computeInstanceSymbol() {
        RCall declaration = this.getPrimaryDeclarationCall();
        if (declaration == null) {
            return null;
        }
        Symbol symbol = SymbolUtil.findConstantByFQN(declaration.getProject(), Type.CLASS, this.getInstanceFqn(), (PsiElement)declaration);
        return (Symbol)ObjectUtils.coalesce((Object)RailsModelSymbol.createModelSymbol(symbol), (Object)symbol);
    }

    @Nullable
    private RubyFactoryBotFactory computeParentFactory() {
        String parentName;
        RCall declaration = this.getPrimaryDeclarationCall();
        if (declaration == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)RubyFactoryBotModelCallType.getClassOption((RPossibleCall)declaration))) {
            return null;
        }
        Project project = declaration.getProject();
        String parentOption = RubyFactoryBotModelCallType.getParentOption((RPossibleCall)declaration);
        if (StringUtil.isNotEmpty((String)parentOption)) {
            return RubyFactoryBotFactory.findByName(project, (SearchScope)declaration.getResolveScope(), parentOption);
        }
        RBlockCall parentBlockCall = RubyPsiUtil.getContainingRBlockCall((PsiElement)declaration);
        if (RubyPsiUtil.isCallOfType((PsiElement)parentBlockCall, callType -> callType instanceof RubyFactoryBotFactoryCallType) && StringUtil.isNotEmpty((String)(parentName = RubyFactoryBotModelCallType.getName((RPossibleCall)parentBlockCall)))) {
            return RubyFactoryBotFactory.findByName(project, (SearchScope)declaration.getResolveScope(), parentName);
        }
        return null;
    }

    @NotNull
    public static RubyFactoryBotFactory findByName(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(9);
        }
        if (name == null) {
            RubyFactoryBotFactory.$$$reportNull$$$0(10);
        }
        return new RubyFactoryBotFactory(name, RubyFactoryBotFactoryNameIndex.getInstance().getElements(project, searchScope, name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/model/RubyFactoryBotFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/model/RubyFactoryBotFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFqn";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInstanceFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

